package cc.lechun.framework.common.enums.sales;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Arrays;
import java.util.List;

/**
 * Created by wangxs on 2018/5/10
 * Description:
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum RegularTypeEnum {

    month(2, "包月"),
    threemonth(3, "包季"),
    year(4, "包年");

    private int value;
    private String name;

    /**
     * 获取列表
     */
    public static List<RegularTypeEnum> getList() {
        return Arrays.asList(RegularTypeEnum.values());
    }

    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        RegularTypeEnum[] ls = RegularTypeEnum.values();
        for (RegularTypeEnum rs : ls) {
            if (rs.getValue() == value) {
                return rs.getName();
            }
        }
        return "";
    }

    RegularTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
