package cc.lechun.framework.common.utils.exception;

import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.log.*;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.utils.log.AccessLogEntity;
import cc.lechun.framework.common.utils.log.LoggerUtil;
import cc.lechun.framework.common.vo.BaseJsonVo;
import ch.qos.logback.classic.spi.ThrowableProxy;
import com.alibaba.fastjson.JSON;
import cc.lechun.framework.common.utils.log.AccessLogEntity;
import cc.lechun.framework.common.utils.log.LoggerUtil;
import cc.lechun.framework.common.vo.BaseJsonVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * Created by wangxs on 2017/12/26
 * Description:接口异常拦截 统一返回错误状态
 */
public class MyExceptionHandler implements HandlerExceptionResolver {

    @Autowired
    private AccessLogDBConfig accessLogDBConfig;
    private static final Logger log = LoggerFactory.getLogger(MyExceptionHandler.class);

    @Override
    @ResponseBody
    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        AccessLogEntity accessLog = LoggerUtil.getAccessLog(request);
        ModelAndView mav = new ModelAndView(new MappingJackson2JsonView());
        if (ex != null && ex instanceof AuthorizeException) {
            BaseJsonVo.noLogin().addObject(mav);
        } else {
            long endTime = System.currentTimeMillis();
            accessLog.setEndTime(endTime);
            accessLog.setRunTimes(endTime - accessLog.getBeginTime());
            log.error(JSON.toJSONString(accessLog), ex);
            if(accessLogDBConfig!=null) {
                StringWriter sw = new StringWriter();
                try(PrintWriter pw = new PrintWriter(sw);){
                    ex.printStackTrace(pw);
                }
                String errorInfo = sw.toString();
                accessLog.setMessage(errorInfo);
                accessLogDBConfig.writeErrorDBLog(accessLog);
            }
            BaseJsonVo.error().addObject(mav);
        }
        return mav;
    }
}
