package cc.lechun.framework.common.utils.ids;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;

/**
 * 序列化、反序列化工具
 */
public class Serializer {

    private final static Logger log = LoggerFactory.getLogger(Serializer.class);

    public static byte[] serialize(Object target) {
        ByteArrayOutputStream bo = null;
        ObjectOutputStream oo = null;
        try {
            bo = new ByteArrayOutputStream();
            oo = new ObjectOutputStream(bo);
            oo.writeObject(target);
            return bo.toByteArray();
        } catch (IOException e) {
            log.error("序列化失败." + e.getMessage());
        } finally {
            try {
                if (bo != null) oo.close();
                if (oo != null) oo.close();
            } catch (IOException e) {
            }
        }
        return null;
    }

    public static <T> T unserialize(byte[] bytes) {
        ByteArrayInputStream bi = null;
        ObjectInputStream oi = null;
        try {
            bi = new ByteArrayInputStream(bytes);
            oi = new ObjectInputStream(bi);
            Object image = oi.readObject();
            return (T) image;
        } catch (ClassNotFoundException | IOException e) {
            log.error("反序列化失败." + e.getMessage());
        } finally {
            try {
                if (bi != null) bi.close();
                if (oi != null) oi.close();
            } catch (IOException e) {
            }
        }
        return null;
    }
}
