package cc.lechun.framework.common.utils.login;

import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.utils.web.CookieUtils;
import cc.lechun.framework.common.utils.web.RequestDetail;
import cc.lechun.framework.common.vo.BaseJsonVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@Component
public class LoginUtils {
    @Autowired
    private RedisCacheUtil redisCacheUtil;
    private static final Logger log = LoggerFactory.getLogger(LoginUtils.class);
    public Map<String,String> getUserMap() throws AuthorizeException {
        HttpServletRequest req = RequestDetail.getCurrentRequest();
        if(req==null){
            log.info("请求request 为空");
            throw new AuthorizeException("用户未登陆");
        }
        log.info("请求地址："+req.getRequestURI());
        String testAuthor=req.getParameter("testAuthor");
        if(StringUtils.isEmpty(testAuthor)){
            testAuthor=req.getHeader("testAuthor");
        }
        log.info("testAuthor:"+testAuthor);
        if(checkTestAuthor(testAuthor).isSuccess()){
            Map<String,String>map =new HashMap<>();
            map.put("userId",testAuthor.split("_")[0]);
            map.put("userName","test");
            map.put("userNick","test");
            return map;
        }

        String key="JSESSIONID";

        String jsessionid=CookieUtils.getCookie(req,"JSESSIONID").getValue();
        log.info("jsessionid："+jsessionid);
        if(StringUtils.isEmpty(jsessionid)){
            throw new AuthorizeException("用户未登陆");
        }
        Object user = redisCacheUtil.get(key+jsessionid);
        if(user==null){
            log.info("获取用户为空");
            throw new AuthorizeException("用户未登陆");
        }
        return (Map<String,String>)user;
        ///throw new AuthorizeException("用户未登陆");
    }
    public MallUserEntity getUser() throws AuthorizeException {

        try {
            Map<String,String> map=getUserMap();
            return ObjectConvert.mapConvertToObject(map, MallUserEntity.class);
        }catch (Exception e){
            throw new AuthorizeException("用户未登陆");
        }
        ///throw new AuthorizeException("用户未登陆");
    }
    public static void main(String[] args) {
        String path="https://gatewaytest.lechun.cc/lechun-tools/app/getAppList?pageSize=20&pageNum=1&pageRouterUrl=%2Fdashboard";
        String[] paths=path.split("/");
        if(paths.length<4){
            System.out.println("错误");
        }
        System.out.println(paths[3]);
    }
    public   BaseJsonVo checkTestAuthor(String author){
        HttpServletRequest req = RequestDetail.getCurrentRequest();
        if(req==null){
            return BaseJsonVo.error("用户未登陆");
        }
        String path =req.getRequestURI().toLowerCase();
        if(StringUtils.isEmpty(path)||StringUtils.isEmpty(author)){
            return BaseJsonVo.error("认证为空");
        }
        String[] paths=path.split("/");
        if(paths.length<4){
            return BaseJsonVo.error("认证错误");
        }

        String sys=paths[3];
        String key=sys+"_"+author.split("_")[0];
        log.info("认证字符串key："+key);
        Object value=redisCacheUtil.get(key);
        //log.info("认证字符串value："+value);
        if(value!=null) {
            log.info("认证字符串value：" + value.toString()+",author:"+author);
            if (author.equals(value.toString())) {
                return BaseJsonVo.success("");
            }
        }

        return BaseJsonVo.error("认证错误");
    }
}
