package cc.lechun.framework.common.utils.web;


import cc.lechun.framework.common.constants.cache.CacheMemcacheConstants;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Created by liqun on 2017/11/1.
 */
@Component
public class IpUtil {

    private final static Logger log = LoggerFactory.getLogger(IpUtil.class);
    private static  RedisCacheUtil redisCacheUtil;
    @Autowired
    private RedisCacheUtil _redisCacheUtil;
    @PostConstruct
    public void init(){
        redisCacheUtil = this._redisCacheUtil;
    }

    /**
     * 获取客户端ip地址
     */
    public static String getCliectIp(HttpServletRequest request) {
        String ipAddress = null;
        //ipAddress = this.getRequest().getRemoteAddr();
        ipAddress = request.getHeader("x-forwarded-for");
        if(ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if(ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if(ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getRemoteAddr();
            if(ipAddress.equals("127.0.0.1")){
//                //根据网卡取本机配置的IP
//                InetAddress inet=null;
//                try {
//                    inet = InetAddress.getLocalHost();
//                } catch (UnknownHostException e) {
//                    e.printStackTrace();
//                }
//                ipAddress= inet.getHostAddress();
            }

        }

        //对于通过多个代理的情况，第一个IP为客户端真实IP,多个IP按照','分割
        if(ipAddress!=null && ipAddress.length()>15){ //"***.***.***.***".length() = 15
            if(ipAddress.indexOf(",")>0){
                ipAddress = ipAddress.substring(0,ipAddress.indexOf(","));
            }
        }
        return ipAddress;
    }

    /**
     * 获取本机IP
     */
    public static InetAddress getLocalHostLANAddress() {
        try {
            /*InetAddress candidateAddress = null;
            // 遍历所有的网络接口
            for (Enumeration ifaces = NetworkInterface.getNetworkInterfaces(); ifaces.hasMoreElements(); ) {
                NetworkInterface iface = (NetworkInterface) ifaces.nextElement();
                // 在所有的接口下再遍历IP
                for (Enumeration inetAddrs = iface.getInetAddresses(); inetAddrs.hasMoreElements(); ) {
                    InetAddress inetAddr = (InetAddress) inetAddrs.nextElement();
                    if (!inetAddr.isLoopbackAddress()) {// 排除loopback类型地址
                        if (inetAddr.isSiteLocalAddress()) {
                            // 如果是site-local地址，就是它了
                            return inetAddr;
                        } else if (candidateAddress == null) {
                            // site-local类型的地址未被发现，先记录候选地址
                            candidateAddress = inetAddr;
                        }
                    }
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }*/
            // 如果没有发现 non-loopback地址.只能用最次选的方案
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            return jdkSuppliedAddress;
        } catch (Exception e) {
            log.error("获取IP地址错误", e);
        }
        return null;
    }

    public static String getCityIdByIp( String ip){
        String key="iputil_getCityIdByIp"+ip;
        if(StringUtils.isEmpty(ip)){
            return null;
        }
        Object o =redisCacheUtil.get(key);
        if(o!=null&&!"None".equals(o)){
            return o.toString();
        }
        String result=tengxunIp(ip);
        if(StringUtils.isEmpty(result)){
            result=gaodeIp(ip);
        }

        if(StringUtils.isNotEmpty(result)){
            redisCacheUtil.set(key,result,3600*24*365L);
        }
        return result;
    }
    private static  String baiduIp(String ip){
        try {
            String cityUrl = "http://api.map.baidu.com/location/ip";
            String s = HttpRequest.get(cityUrl, "ak=827c6dd4b8f06ecc01162f44bf2e3ffd&coor=bd09ll&ip=" + ip.split(",")[0]);
            Map<String, Object> r = JsonUtils.fromJson(s, HashMap.class);
            if (r.containsKey("address") && r.get("address") != null) {
                String rr = (String) r.get("address");
                if (StringUtils.isNotEmpty(rr)) {
                    String result = rr.split("\\|")[2];
                    if("None".equals(result)){
                        return null;
                    }
                    return result;
                }
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }
    private static  String gaodeIp(String ip){
        try {
            String cityUrl = "https://restapi.amap.com/v3/ip";
            String s = HttpRequest.get(cityUrl, "key=a267a66e42966e20659059a3c33c24a2&ip=" + ip.split(",")[0]);
            Map<String, Object> r = JsonUtils.fromJson(s, HashMap.class);
            if (r.containsKey("city") && r.get("city") != null) {
                return (String) r.get("city");
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }
    private static  String tengxunIp(String ip){
        try {
            String cityUrl = "https://apis.map.qq.com/ws/location/v1/ip";
            String s = HttpRequest.get(cityUrl, "ip=" + ip.split(",")[0]+"&key=M24BZ-NNNK4-2PDUP-XZ3FU-FDGKT-7WBYZ");
            Map<String, Object> r = JsonUtils.fromJson(s, HashMap.class);
            if (r.get("status")!=null&&"0".equals(r.get("status").toString())) {
                if(r.get("result")!=null) {
                    Map result1 = (Map) r.get("result");
                    if(result1.get("ad_info")!=null) {
                        Map adInfo = (Map) result1.get("ad_info");
                        if (adInfo.get("city") != null) {
                            String result =adInfo.get("city").toString();

                            return result;
                        }
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }

}
