package cc.lechun.framework.common.utils.web;

import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Created by wangxs on 2018/4/14
 * Description:
 */
public class ResponseUtils {

    private final static Logger log = LoggerFactory.getLogger(ResponseUtils.class);

    public static void corsConfig(HttpServletRequest request, HttpServletResponse httpServletResponse) {
        String curOrigin = request.getHeader("Origin");
        if (!StringUtils.isEmpty(curOrigin)) {
            httpServletResponse.setHeader("Access-Control-Allow-Origin", curOrigin);
            httpServletResponse.setHeader("Access-Control-Allow-Credentials", "true");
        }
        httpServletResponse.setCharacterEncoding("UTF-8");
        httpServletResponse.setContentType("application/json; charset=utf-8");
        if (request.getMethod().equals("OPTIONS")) {
            httpServletResponse.setStatus(HttpStatus.OK.value());
            httpServletResponse.setHeader("Access-Control-Allow-Methods", "*");
            httpServletResponse.setHeader("Access-Control-Allow-Headers", "Content-Type,Access-Token");
            httpServletResponse.setHeader("Access-Control-Expose-Headers", "*");
        }
    }
    public static  void corsConfigFilter(HttpServletRequest request, HttpServletResponse response){

        response.setHeader("Access-Control-Allow-Origin", request.getHeader("Origin"));
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Allow-Methods", "POST, PUT, GET, OPTIONS, DELETE");
        response.setHeader("Access-Control-Allow-Headers", "Content-Type,Access-Token,Authorization, Content-Type,X-Requested-With,Pagerouterurl,testAuthor");
        //response.setHeader("Access-Control-Max-Age", "3600");
        if ("OPTIONS".equalsIgnoreCase(request.getMethod())) {
            response.setStatus(HttpServletResponse.SC_OK);
        }
    }

    /**
     * 跨域返回json数据
     */
    public static void writeCorsJsonDate(HttpServletRequest request, HttpServletResponse httpServletResponse, Object obj) throws IOException {
        ResponseUtils.corsConfig(request, httpServletResponse);
        httpServletResponse.getWriter().print(JSON.toJSONString(obj));
    }
}
