package cc.lechun.framework.common.enums.quartz;

import java.util.Arrays;
import java.util.List;

/**
 * Created by wangxs on 2017/12/13
 * Description: quartz 状态枚举
 */
public enum QuartzEnum {

    ACQUIRED("ACQUIRED", "运行中"),
    PAUSED("PAUSED", "暂停中"),
    WAITING("WAITING", "等待中");

    private String value;
    private String name;

    /**
     * 获取列表
     */
    public static List<QuartzEnum> getList() {
        return Arrays.asList(QuartzEnum.values());
    }

    /**
     * 通过value获取名称
     */
    public static String getName(String value) {
        QuartzEnum[] ls = QuartzEnum.values();
        for (QuartzEnum rs : ls) {
            if (rs.getValue().equals(value)) {
                return rs.getName();
            }
        }
        return "";
    }

    QuartzEnum(String value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "QuartzEnum{" +
                "value='" + value + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
