/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.date;

import cc.lechun.framework.common.utils.date.DateUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.quartz.CronExpression;

public class CronUtils {
    public static Date getCronTime(String cron) {
        return CronUtils.getCronTime(cron, DateUtils.getAddDateBySecond(new Date(), 0));
    }

    public static Date getCronTime(String cron, Date initDate) {
        CronExpression cronExpression;
        try {
            cronExpression = new CronExpression(cron);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        Date execTime = cronExpression.getTimeAfter(initDate);
        if (execTime == null) {
            return null;
        }
        return execTime;
    }

    public static List<Date> getCronTime(String cron, Integer count, Date initDate) {
        CronExpression cronExpression;
        try {
            cronExpression = new CronExpression(cron);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        if (count == null) {
            count = 1;
        }
        if (count > 20) {
            count = 20;
        }
        ArrayList<Date> result = new ArrayList<Date>();
        Date exec = new Date();
        for (int i = 0; i < count; ++i) {
            Date execTime = cronExpression.getTimeAfter(initDate);
            if (execTime == null) {
                return result;
            }
            exec = execTime;
            result.add(execTime);
        }
        return result;
    }

    public static List<Date> getCronTime(String cron, Integer count) {
        return CronUtils.getCronTime(cron, count, DateUtils.getAddDateBySecond(new Date(), 0));
    }
}

