package cc.lechun.framework.common.utils.log;

import cc.lechun.framework.common.utils.http.HttpUtil;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AccessLogDBConfig {
    @Value("${accessLog.error:1}")
    private String accessLogError;//错误日志记录，1为记录，其他不记录
    @Value("${accessLog.Sql:1}")
    private String accesslogsql;//sql日志记录，1为记录，其他不记录
    @Value("${accessLog.access:1}")
    private String accessLog;//sql日志记录，1为记录，其他不记录
    @Value("${accessLog.SqlExecTime:1000}")
    private Integer accessLogSqlExecTime;//超过多少毫秒才记录
    @Value("${accessLog.WriteLogUrl:https://scmapi.lechun.cc/lechun-bi/accessLog/saveAccessLog}")
    private String accessLogWriteLogUrl;//记录的远程URL
    @Value("${spring.application.name:unknown}")
    private String sys;
    public void writeErrorDBLog(AccessLogEntity logEntity){
        if(logEntity==null){
            return;
        }
        if(StringUtils.isEmpty(accessLogWriteLogUrl)){
            return;
        }
        if("1".equals(accessLogError)){
            logEntity.setOperator(sys);
            logEntity.setLogType("error");
            HttpUtil.doPost(accessLogWriteLogUrl,ObjectConvert.objectConvertToMap(logEntity));
        }
    }
    public void writeAccessDBLog(AccessLogEntity logEntity){
        if(logEntity==null){
            return;
        }
        if(StringUtils.isEmpty(accessLogWriteLogUrl)){
            return;
        }
        if("1".equals(accessLog)){
            logEntity.setOperator(sys);
            logEntity.setLogType("access");
            HttpUtil.doPost(accessLogWriteLogUrl,ObjectConvert.objectConvertToMap(logEntity));
        }
    }
    public void writeSqlDBLog(SqlLogEntity logEntity){
        if(logEntity==null){
            return;
        }
        if(StringUtils.isEmpty(accessLogWriteLogUrl)){
            return;
        }
        if("1".equals(accesslogsql)){
            long s=logEntity.getRunTimes();
            if(accessLogSqlExecTime!=null&&s>=accessLogSqlExecTime.intValue()) {
                logEntity.setOperator(sys);
                logEntity.setLogType("sql");
                HttpUtil.doPost(accessLogWriteLogUrl, ObjectConvert.objectConvertToMap(logEntity));
            }
        }
    }
}
