package cc.lechun.framework.common.utils.log;


import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.web.CookieUtils;
import cc.lechun.framework.common.utils.web.IpUtil;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.net.URLDecoder;

/**
 * Created by liqun on 2017/11/1.
 */
public class LoggerUtil {

    private static final Logger logger = LoggerFactory.getLogger(LoggerUtil.class);

    public LoggerUtil() {

    }

    public static AccessLogEntity getAccessLog(HttpServletRequest request) {
        AccessLogEntity log = new AccessLogEntity();
        try {
            //1.依次获取每个属性信息 userId,operator,action,remark,ip,targetType
            String api = request.getRequestURI();
            String referer = request.getHeader("referer");
            String url = request.getRequestURL().toString();
            String userAgent = request.getHeader("User-Agent");
            String params = JsonUtils.toJson(request.getParameterMap(), false);
            String sign=request.getParameter("userTicket");
            String page= request.getHeader("Pagerouterurl");
            log.setIp(IpUtil.getCliectIp(request));
            log.setOperator("operator");
            log.setUserId("");
            log.setAction(api);
            String customerId="";
            if(request!=null) {
                Cookie cookie = CookieUtils.getCookie(request, "user");
                if (cookie != null) {
                    customerId = URLDecoder.decode( cookie.getValue(),"utf-8");
                }
            }
            log.setCustomerId(customerId);
            log.setMessage("接口监控");
            log.setReferer(referer);
            log.setBeginTime(System.currentTimeMillis());
            log.setUrl(page);
            log.setUserAgent(userAgent);
            log.setParams(params);
            log.setSign(sign);
        } catch (Exception e) {
            logger.error("", e);
        }
        return log;
    }

    public static SqlLogEntity WriteSqlLog(String isTrans, String rw, String customerId, String service, long beginTime, long endTime, long runTimes, String sql, String db,String sign) {
        SqlLogEntity log = new SqlLogEntity();
        log.setRunTimes(runTimes);
        log.setBeginTime(beginTime);
        log.setTrans(isTrans);
        log.setRw(rw);
        log.setCustomerId(customerId);
        log.setDb(db);
        log.setEndTime(endTime);
        log.setService(service);
        log.setSqls(sql);
        log.setSign(sign);
        return log;
    }

}
