package cc.lechun.framework.common.enums.dingding;

import java.util.Arrays;
import java.util.List;
public enum DingRemindTypeEnum {
    //1 营销类，2 提醒类
    APP(1,"应用内DING"),
    SHORTMESSAGE(2, "短信DING"),
    PHONE(3, "电话DING"),;
    private int value;
    private String name;

    /**
     * 获取列表
     */
    public static List<DingRemindTypeEnum> getList() {
        return Arrays.asList(DingRemindTypeEnum.values());
    }

    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        DingRemindTypeEnum[] ls = DingRemindTypeEnum.values();
        for (DingRemindTypeEnum rs : ls) {
            if (rs.getValue()==value) {
                return rs.getName();
            }
        }
        return "";
    }
    /**
     * 通过value获取名称
     */
    public static int getValue(String name) {
        DingRemindTypeEnum[] ls = DingRemindTypeEnum.values();
        for (DingRemindTypeEnum rs : ls) {
            if (rs.getName().equals(name)) {
                return rs.getValue();
            }
        }
        return 0;
    }
    DingRemindTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "DingRemindTypeEnum{" +
                "value='" + value + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
