package cc.lechun.framework.common.enums.portal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public enum PushTypeEnum {
    //1 营销类，2 提醒类
    PORTAL(0,"推送PORTAL"),
    DING_MESSAGE(1, "钉钉消息"),
    DING_REMIND(2, "钉钉待办"),
    DING_APP(3, "应用内ding"),
    DING_SMS(4, "钉钉短信ding(暂不支持)"),
    DING_PHONE(5, "钉钉电话ding(暂不支持)"),
    DING_WORK(6, "工作通知"),
    SHORTMESSAGE(7, "普通短信");





    private int value;
    private String name;

    /**
     * 获取列表
     */
    public static List<PushTypeEnum> getList() {
        return Arrays.asList(PushTypeEnum.values());
    }
    public static List<Map<String, Object>> getMapList() {
        List<Map<String, Object>> list = new ArrayList<>();
        for (PushTypeEnum rs : PushTypeEnum.values()) {
            Map<String, Object> map = new java.util.HashMap<>();
            map.put("id",rs.getValue());
            map.put("name", rs.getName());
            list.add(map);
        }
        return list;
    }
    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        PushTypeEnum[] ls = PushTypeEnum.values();
        for (PushTypeEnum rs : ls) {
            if (rs.getValue()==value) {
                return rs.getName();
            }
        }
        return "";
    }
    /**
     * 通过value获取名称
     */
    public static int getValue(String name) {
        PushTypeEnum[] ls = PushTypeEnum.values();
        for (PushTypeEnum rs : ls) {
            if (rs.getName().equals(name)) {
                return rs.getValue();
            }
        }
        return 0;
    }
    PushTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "DingRemindTypeEnum{" +
                "value='" + value + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
