package cc.lechun.framework.common.vo;


import cc.lechun.framework.common.utils.SpringUtil;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.cache.RedisConfig;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.login.LoginUtils;
import cc.lechun.framework.common.utils.login.MallUserEntity;
import cc.lechun.framework.common.utils.string.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;
import javax.servlet.http.HttpServletRequest;
import java.util.Iterator;
import java.util.Set;

/**
 *@ClassNameJedisUtils
 *@Description TODO：此服务主要用于页面调用兼容erp获取用户信息使用
 *@Author
 *@Date
 *@Version 1.0
 **/
@RefreshScope
@Component
public class JedisUtils{


    protected static Logger logger = LoggerFactory.getLogger(JedisUtils.class);
    private static String  redisKey="JedisUtils-userId-";
    public static RedisCacheUtil<BaseUser> redisCacheUtil;
    @Autowired
    public  void setRedisCacheUtil(RedisCacheUtil<BaseUser> redisCacheUtil) {
        this.redisCacheUtil = redisCacheUtil;
    }


    public static BaseUser getBaseUser(HttpServletRequest request) {
        String id=request.getHeader("id");
        logger.info("=============0 获取userid:{}", id);
        BaseUser user = null;
        if(StringUtils.isNotBlank(id)){
            user =getBaseUser(id);
        }
        user =getBaseUser( user);
        logger.info("=============1 获取user  :{}", JSONObject.toJSONString(user));
        return  user;
    }
    public static BaseUser getBaseUser(String  id) {
        BaseUser user = getRedisBaseUser(id);
        return  getBaseUser( user);
    }
    private static BaseUser getBaseUser(BaseUser user) {
        if(null == user) {

                MallUserEntity v = null;
                try {
                    v =SpringUtil.getBean(LoginUtils.class).getUser();
                } catch (AuthorizeException e) {
                    logger.error("获取用户信息失败");
                    logger.info("=============3 获取用户信息失败");
                }
                user = new BaseUser();
                if(null != v) {
                    user.setId(v.getUserId());
                    user.setUserName(v.getUserName());
                    user.setEmployeeName(v.getUserNick());
                    redisCacheUtil.set(redisKey+user.getId(),user,60*60*2l);
                    logger.info("=============4 获取cookes:{}", JSONObject.toJSONString(user));
                }else{//主要是兼容定时任务调用接口记录操作人
                    user.setId("SYS-系统");
                    user.setUserName("SYS-系统");
                    user.setEmployeeName("SYS-系统");
                }
        }
        return user;
    }


    private static BaseUser getRedisBaseUser(String  id) {
        if(StringUtils.isNotBlank(id)) {
            Object baseUser = redisCacheUtil.get(redisKey + id);
            if (null != baseUser) {
                return (BaseUser) baseUser;
            }
        }
        return null;
    }
}
