/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.cache;

import com.google.code.ssm.CacheFactory;
import com.google.code.ssm.api.format.SerializationType;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MemcachedService {
    private static final Logger log = LoggerFactory.getLogger(MemcachedService.class);
    @Autowired
    private CacheFactory cacheFactory;

    public Object get(String key) {
        if (StringUtils.isEmpty((String)key)) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef\uff01");
        }
        try {
            return this.cacheFactory.getCache().get(key, SerializationType.JAVA);
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public Object get(String nameSpace, String key) {
        if (StringUtils.isEmpty((String)key)) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef\uff01");
        }
        try {
            return this.get(this.joinNameSpaceKey(nameSpace, key));
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public Object get(String nameSpace, String ... keys) {
        String key = null;
        if (keys != null && keys.length > 0) {
            key = org.apache.commons.lang3.StringUtils.join((Object[])keys, (String)"/");
        }
        return this.get(nameSpace, key);
    }

    public boolean set(String key, Object obj) {
        try {
            this.cacheFactory.getCache().set(key, 2592000, obj, SerializationType.JAVA);
            return true;
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public boolean set(String key, Object obj, int exp) {
        try {
            this.cacheFactory.getCache().set(key, exp, obj, SerializationType.JAVA);
            return true;
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public boolean set(String nameSpace, String key, Object obj) {
        try {
            this.cacheFactory.getCache().set(this.joinNameSpaceKey(nameSpace, key), 2592000, obj, SerializationType.JAVA);
            return true;
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public boolean set(String nameSpace, String key, Object obj, int exp) {
        try {
            this.cacheFactory.getCache().set(this.joinNameSpaceKey(nameSpace, key), exp, obj, SerializationType.JAVA);
            return true;
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public boolean delete(String key) {
        try {
            return this.cacheFactory.getCache().delete(key);
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public boolean delete(String nameSpace, String key) {
        try {
            return this.delete(this.joinNameSpaceKey(nameSpace, key));
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public boolean delete(String nameSpace, String ... keys) {
        String key = null;
        if (keys != null && keys.length > 0) {
            key = org.apache.commons.lang3.StringUtils.join((Object[])keys, (String)"/");
        }
        return this.delete(nameSpace, key);
    }

    public Long incr(String nameSpace, String key, int count, long def) {
        try {
            return this.cacheFactory.getCache().incr(this.joinNameSpaceKey(nameSpace, key), count, def);
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public Long incr(String nameSpace, String key, int count, long def, int exp) {
        try {
            return this.cacheFactory.getCache().incr(this.joinNameSpaceKey(nameSpace, key), count, def, exp);
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public Long decr(String nameSpace, String key, int count) {
        try {
            return this.cacheFactory.getCache().decr(this.joinNameSpaceKey(nameSpace, key), count);
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public boolean isExceedCount(String nameSpace, String key, int count, int times) {
        long old_count = this.incr(nameSpace, key, 0, 0L, times);
        if (old_count >= (long)count) {
            return true;
        }
        this.incr(nameSpace, key, 1, 1L);
        return false;
    }

    private String joinNameSpaceKey(String nameSpace, String key) {
        return nameSpace + ":" + key;
    }
}

