/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.http;

import cc.lechun.framework.common.utils.http.HttpRequest;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpComponentUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpComponentUtil.class);
    private static PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
    private static CloseableHttpClient httpClient;

    public static String execute(HttpRequest httpRequest) {
        try {
            RequestBuilder requestBuilder = null;
            if ("POST".equals(httpRequest.getMethod())) {
                requestBuilder = RequestBuilder.post().setUri(httpRequest.getUrl());
            } else if ("GET".equals(httpRequest.getMethod())) {
                requestBuilder = RequestBuilder.get().setUri(httpRequest.getUrl());
            }
            if (httpRequest.getParams() != null && httpRequest.getParams().size() > 0) {
                requestBuilder.addParameters(httpRequest.generatNameValuePair());
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(httpRequest.getConnectTimeout()).setSocketTimeout(httpRequest.getSocketTimeout()).setConnectionRequestTimeout(httpRequest.getConnectionRequestTimeout()).build();
            requestBuilder.setConfig(requestConfig);
            requestBuilder.setHeader("referer", "http://wechat.lechun.cc");
            HttpUriRequest httpUriRequest = requestBuilder.build();
            CloseableHttpResponse response = httpClient.execute(httpUriRequest);
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (Exception ex) {
            log.error("HTTP \u8bf7\u6c42\u5f02\u5e38", (Throwable)ex);
            return null;
        }
    }

    private static CloseableHttpClient createSSLInsecureClient() throws GeneralSecurityException {
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        }).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new X509HostnameVerifier(){

            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }

            public void verify(String host, SSLSocket ssl) throws IOException {
            }

            public void verify(String host, X509Certificate cert) throws SSLException {
            }

            public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
            }
        });
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
    }

    static {
        connManager.setMaxTotal(200);
        connManager.setDefaultMaxPerRoute(20);
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
    }
}

