/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final SimpleDateFormat longSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat shortSdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat longHourSdf = new SimpleDateFormat("yyyy-MM-dd HH");
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);

    public static String now(String format) {
        if (StringUtils.isEmpty((String)format)) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat f = new SimpleDateFormat(format);
        return f.format(new Date());
    }

    public static String date() {
        String format = "yyyy-MM-dd";
        SimpleDateFormat f = new SimpleDateFormat(format);
        return f.format(new Date());
    }

    public static Date currentDate() {
        String format = "yyyy-MM-dd";
        SimpleDateFormat f = new SimpleDateFormat(format);
        String d = f.format(new Date());
        return DateUtils.getDateFromString(d, format);
    }

    public static Date now() {
        return new Date();
    }

    public static long nowMillis() {
        return System.currentTimeMillis();
    }

    public static Date StrToDate(String str) {
        Date result = DateUtils.StrToDate(str, "yyyy-MM-dd HH:mm:ss");
        if (result == null) {
            return DateUtils.StrToDate(str, "yyyy-MM-dd");
        }
        return result;
    }

    public static Date StrToDate(String str, String fm) {
        if (StringUtils.isEmpty((String)fm)) {
            fm = "yyyy-MM-dd HH:mm:ss";
        }
        if (str != null) {
            SimpleDateFormat format = new SimpleDateFormat(fm);
            Date date = null;
            try {
                date = format.parse(str);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return date;
        }
        return null;
    }

    public static String taskDateToString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("s m H d M ? yyyy");
        Date now = new Date();
        String cron = null;
        cron = now.getTime() > date.getTime() ? sdf.format(new Date(now.getTime() + 5000L)) : sdf.format(date);
        return cron;
    }

    public static String formatDate(Date sourceDate, String format) {
        if (sourceDate == null) {
            return "";
        }
        if (format.isEmpty()) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sourceDate);
        return dateFormat.format(calendar.getTime());
    }

    public static Date getAddDate(Date sourceDate, int type, int count) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sourceDate);
        calendar.add(type, count);
        return calendar.getTime();
    }

    public static Date getAddDateByDay(Date sourceDate, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sourceDate);
        calendar.add(5, day);
        return calendar.getTime();
    }

    public static Date getAddDateByMonth(Date sourceDate, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sourceDate);
        calendar.add(2, month);
        return calendar.getTime();
    }

    public static Date getAddDateByYear(Date sourceDate, int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sourceDate);
        calendar.add(1, year);
        return calendar.getTime();
    }

    public static Date getAddDateBySecond(Date sourceDate, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sourceDate);
        calendar.add(13, second);
        return calendar.getTime();
    }

    public static String getAddDateBySecond(Date sourceDate, int second, String format) {
        if (format.isEmpty()) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(DateUtils.getAddDateBySecond(sourceDate, second));
    }

    public static Date getDateFromString(String k, String dateformat) {
        if (dateformat.isEmpty()) {
            dateformat = "yyyy-MM-dd HH:mm:ss";
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat(dateformat);
            format.setLenient(false);
            return format.parse(k);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getDateFromString(String k) {
        Date s = DateUtils.getDateFromString(k, "yyyy-MM-dd HH:mm:ss");
        if (s == null) {
            s = DateUtils.getDateFromString(k, "yyyy-MM-dd HH:mm");
        }
        if (s == null) {
            return DateUtils.getDateFromString(k, "yyyy-MM-dd");
        }
        return s;
    }

    public static boolean checkDate(String k, String dateformat) {
        return DateUtils.getDateFromString(k, dateformat) != null;
    }

    public static long dateTimeCompare(String sdate, String edate) {
        long day = 0L;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date begin_date = format.parse(sdate);
            Date end_date = format.parse(edate);
            day = (end_date.getTime() - begin_date.getTime()) / 1000L;
        }
        catch (Exception e) {
            return -1L;
        }
        return day;
    }

    public static long dateCompare(String sdate, String edate) {
        long day = 0L;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date begin_date = format.parse(sdate);
            Date end_date = format.parse(edate);
            day = (end_date.getTime() - begin_date.getTime()) / 86400000L;
        }
        catch (Exception e) {
            return -1L;
        }
        return day;
    }

    public static long dateTimeCompare(Date sdate, Date edate) {
        long day = (edate.getTime() - sdate.getTime()) / 1000L;
        return day;
    }

    public static long getDateDiffSecond(String sdate, String edate) {
        long day = 0L;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date begin_date = format.parse(sdate);
            Date end_date = format.parse(edate);
            day = (end_date.getTime() - begin_date.getTime()) / 1000L;
        }
        catch (Exception e) {
            return -1L;
        }
        return day;
    }

    public static long getDateDiffSecond(Date sdate, Date edate) {
        long day = 0L;
        try {
            day = (edate.getTime() - sdate.getTime()) / 1000L;
        }
        catch (Exception e) {
            return -1L;
        }
        return day;
    }

    public static String getWeekOfDate(Date date) {
        int w;
        String[] weekOfDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        if ((w = calendar.get(7) - 1) < 0) {
            w = 0;
        }
        return weekOfDays[w];
    }

    public static int getWeekIndexOfDate(Date date) {
        int w;
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        if ((w = calendar.get(7) - 1) < 0) {
            w = 0;
        }
        return w;
    }

    public static String getWeekOfDate(int weekIndex) {
        String[] weekOfDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        if (weekIndex >= 0 && weekIndex <= 6) {
            return weekOfDays[weekIndex];
        }
        return "";
    }

    public static String getShortWeekOfDate(int weekIndex) {
        String s = DateUtils.getWeekOfDate(weekIndex);
        return s.replace("\u661f\u671f", "\u5468");
    }

    public static String getShortWeekOfDate(Date date) {
        String s = DateUtils.getWeekOfDate(date);
        return s.replace("\u661f\u671f", "\u5468");
    }

    public static String formatDateChina(String SourceDate, String format) {
        Date d = new Date(DateUtils.dateToTimestamp(SourceDate) * 1000L);
        if (format.isEmpty()) {
            format = "MM\u6708dd\u65e5";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        return dateFormat.format(calendar.getTime());
    }

    public static long dateToTimestamp(String dateString) {
        return DateUtils.dateToTimestamp(dateString, "yyyy-MM-dd HH:mm:ss");
    }

    public static long dateToTimestamp(String dateString, String format) {
        try {
            Date date;
            SimpleDateFormat df = new SimpleDateFormat(format);
            try {
                date = df.parse(dateString);
            }
            catch (ParseException e) {
                df = new SimpleDateFormat("yyyy-MM-dd");
                date = df.parse(dateString);
            }
            long s = date.getTime();
            return s / 1000L;
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            return 0L;
        }
    }

    public static String getDateName(String date) {
        if (date == null || date.isEmpty()) {
            return "7\u65e5\u540e";
        }
        int l = (int)DateUtils.getDateDiff(DateUtils.date(), date);
        if (l == 0) {
            return "\u4eca\u65e5";
        }
        if (l == 1) {
            return "\u660e\u65e5";
        }
        if (l == 2) {
            return "\u540e\u65e5";
        }
        return DateUtils.formatDateChina(date, "M\u6708d\u65e5");
    }

    public static long getDateDiff(String sdate, String edate) {
        long day = 0L;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date begin_date = format.parse(sdate);
            Date end_date = format.parse(edate);
            day = (end_date.getTime() - begin_date.getTime()) / 86400000L;
        }
        catch (Exception e) {
            return -1L;
        }
        return day;
    }

    public static long getDateDiff(Date sdate, Date edate) {
        long day = 0L;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            String startDate = format.format(sdate);
            String endDate = format.format(edate);
            return DateUtils.getDateDiff(startDate, endDate);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static Date getDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String s = sdf.format(date);
        try {
            return sdf.parse(s);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getTime(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        String s = sdf.format(date);
        return s;
    }

    public static int getQuarter(Date date) {
        Calendar cal = Calendar.getInstance();
        int m = cal.get(2) + 1;
        Integer quarter = 0;
        if (m >= 1 && m <= 3) {
            quarter = 1;
        }
        if (m >= 4 && m <= 6) {
            quarter = 2;
        }
        if (m >= 7 && m <= 9) {
            quarter = 3;
        }
        if (m >= 10 && m <= 12) {
            quarter = 4;
        }
        return quarter;
    }

    public static Set<Integer> getWeekOfQuarter(Date date) {
        HashSet<Integer> r = new HashSet<Integer>();
        Date sdate = DateUtils.getCurrentQuarterStartTime(date);
        Date edate = DateUtils.getCurrentQuarterEndTime(date);
        Integer sweek = DateUtils.getWeekOfYear(sdate);
        Integer eweek = DateUtils.getWeekOfYear(edate);
        for (int i = sweek.intValue(); i <= eweek; ++i) {
            r.add(i);
        }
        return r;
    }

    public static Integer getWeekOfYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.setFirstDayOfWeek(2);
        return c.get(3);
    }

    public static Integer getYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(1);
    }

    public static Integer getMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(2);
    }

    public static Integer getDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(5);
    }

    public static Integer getWeekOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.setFirstDayOfWeek(2);
        return c.get(4);
    }

    public static boolean isMonthLastWeek(Date weekFirstDate) {
        if (weekFirstDate.compareTo(DateUtils.StrToDate("2021-02-01", "yyyy-MM-dd")) == 0) {
            return true;
        }
        if (weekFirstDate.compareTo(DateUtils.StrToDate("2021-01-25", "yyyy-MM-dd")) == 0) {
            return false;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(weekFirstDate);
        int day1 = c.get(5) + 1;
        int lastDay = c.getActualMaximum(5);
        Date s = DateUtils.getAddDateByDay(weekFirstDate, 6);
        c.setTime(s);
        int day2 = c.get(5);
        if (day1 < day2) {
            if (day2 + 3 >= lastDay) {
                System.out.println("=========================================" + String.valueOf(weekFirstDate) + " -true ");
                return true;
            }
            return false;
        }
        if (day2 - 3 < 1) {
            System.out.println("=========================================" + String.valueOf(weekFirstDate) + " -true ");
            return true;
        }
        return day2 < 4;
    }

    public static Date getCurrentQuarterStartTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int currentMonth = c.get(2) + 1;
        Date now = null;
        try {
            if (currentMonth >= 1 && currentMonth <= 3) {
                c.set(2, 0);
            } else if (currentMonth >= 4 && currentMonth <= 6) {
                c.set(2, 3);
            } else if (currentMonth >= 7 && currentMonth <= 9) {
                c.set(2, 4);
            } else if (currentMonth >= 10 && currentMonth <= 12) {
                c.set(2, 9);
            }
            c.set(5, 1);
            now = longSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static Date getCurrentQuarterEndTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int currentMonth = c.get(2) + 1;
        Date now = null;
        try {
            if (currentMonth >= 1 && currentMonth <= 3) {
                c.set(2, 2);
                c.set(5, 31);
            } else if (currentMonth >= 4 && currentMonth <= 6) {
                c.set(2, 5);
                c.set(5, 30);
            } else if (currentMonth >= 7 && currentMonth <= 9) {
                c.set(2, 8);
                c.set(5, 30);
            } else if (currentMonth >= 10 && currentMonth <= 12) {
                c.set(2, 11);
                c.set(5, 31);
            }
            now = longSdf.parse(shortSdf.format(c.getTime()) + " 23:59:59");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static long getRemainSecondsOneDay(Date currentDate) {
        LocalDateTime midnight = LocalDateTime.ofInstant(currentDate.toInstant(), ZoneId.systemDefault()).plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
        LocalDateTime currentDateTime = LocalDateTime.ofInstant(currentDate.toInstant(), ZoneId.systemDefault());
        long seconds = ChronoUnit.SECONDS.between(currentDateTime, midnight);
        return seconds;
    }

    public static Integer dayForWeek(Date pTime) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        Integer[] weekDays = new Integer[]{7, 1, 2, 3, 4, 5, 6};
        try {
            cal.setTime(pTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static Integer getCurrentHour() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(11);
    }

    public static Integer getCurrentMinute() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(12);
    }

    public static Date getCurrentMonthFirstDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getCurrentMonthFirstDay() {
        return DateUtils.getCurrentMonthFirstDay(null);
    }

    public static Date getCurrentMonthLastDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.set(5, 1);
        return DateUtils.getAddDateByDay(calendar.getTime(), -1);
    }

    public static Date getCurrentMonthLastDay() {
        return DateUtils.getCurrentMonthLastDay(null);
    }

    public static Date getDateByISOString(String dateStr) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'+08:00'");
        Date date = null;
        try {
            date = format.parse(dateStr);
            return date;
        }
        catch (ParseException e) {
            format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            try {
                date = format.parse(dateStr);
                return date;
            }
            catch (ParseException e1) {
                format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
                date = format.parse(dateStr);
                return date;
            }
        }
    }

    public static String getISOStringByDate(Date date) throws ParseException {
        SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        return s.format(date);
    }
}

