/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.file;

import cc.lechun.framework.common.utils.ReflectUtil;
import cc.lechun.framework.common.utils.date.DateFormatUtil;
import cc.lechun.framework.common.vo.ExportVo;
import jakarta.servlet.ServletOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportExcelUtil {
    public static <T> boolean export(ExportVo<T> exportVO, ServletOutputStream out) {
        HSSFWorkbook workbook = null;
        if (exportVO.getFileName().endsWith(".xls")) {
            workbook = new HSSFWorkbook();
        } else if (exportVO.getFileName().endsWith(".xlsx")) {
            workbook = new XSSFWorkbook();
        } else {
            return false;
        }
        Sheet sheet = workbook.createSheet(exportVO.getSheetName());
        sheet.setDefaultColumnWidth(15);
        Row row = sheet.createRow(0);
        Cell cell = null;
        CellStyle cellStyle = ExportExcelUtil.setCellStyle((Workbook)workbook);
        String[] headers = exportVO.getHeaders();
        for (int i = 0; i < headers.length; ++i) {
            cell = row.createCell(i);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(headers[i]);
        }
        Class<?> cls = null;
        Object t = null;
        try {
            int index = 0;
            for (T params : exportVO.getDataset()) {
                int i;
                row = sheet.createRow(++index);
                String[] fieldNames = exportVO.getFieldNames();
                if (params instanceof HashMap) {
                    for (i = 0; i < fieldNames.length; ++i) {
                        Object value = ((HashMap)params).get(fieldNames[i]);
                        if (null != value && value instanceof Double) {
                            b = new BigDecimal((Double)value);
                            value = b.setScale(3, 6).doubleValue();
                        } else if (null != value && value instanceof BigDecimal) {
                            b = new BigDecimal(value.toString());
                            value = b.setScale(3, 6).doubleValue();
                        }
                        cell = row.createCell(i);
                        cell.setCellValue(ExportExcelUtil.handleValue(value, exportVO.getDatePattern()));
                    }
                    continue;
                }
                cls = params.getClass();
                for (i = 0; i < fieldNames.length; ++i) {
                    String fieldName = fieldNames[i];
                    String getMethodName = ReflectUtil.getMethodName(fieldName, "get");
                    Method method = cls.getMethod(getMethodName, new Class[0]);
                    Object value = method.invoke(params, new Object[0]);
                    if (null != value && value instanceof Double) {
                        b = new BigDecimal((Double)value);
                        value = b.setScale(3, 6).doubleValue();
                    } else if (null != value && value instanceof BigDecimal) {
                        b = new BigDecimal(value.toString());
                        value = b.setScale(3, 6).doubleValue();
                    }
                    cell = row.createCell(i);
                    cell.setCellValue(ExportExcelUtil.handleValue(value, exportVO.getDatePattern()));
                }
            }
            workbook.write((OutputStream)out);
            IOUtils.closeQuietly((OutputStream)out);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static CellStyle setCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setBorderTop((short)1);
        cellStyle.setBorderRight((short)1);
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBorderLeft((short)1);
        cellStyle.setAlignment((short)2);
        Font font = ExportExcelUtil.setCellFont(workbook);
        cellStyle.setFont(font);
        return cellStyle;
    }

    private static Font setCellFont(Workbook workbook) {
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)12);
        font.setBoldweight((short)700);
        return font;
    }

    private static String handleValue(Object value, String datePattern) {
        String textValue = "";
        if (value instanceof Date) {
            Date date = (Date)value;
            textValue = DateFormatUtil.date2Str(date, datePattern);
        } else {
            textValue = value == null ? "" : value.toString();
        }
        return textValue;
    }
}

