/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.validate;

import cc.lechun.framework.common.utils.string.StringUtils;
import org.apache.commons.validator.GenericValidator;

public class DateValidatorUsingCommonsValidator {
    private static final String[] dateFormat = new String[]{"yyyy-MM-dd", "yyyy-M-d", "yyyy-MM-d", "yyyy-M-dd", "yyyyMMdd"};
    private static final String[] dateTimeFormat = new String[]{"HH:mm:ss", "HH:mm:s", "HH:m:s", "H:mm:ss", "H:mm:s", "H:m:s", "HHmmss"};

    public static boolean isDate(String dateStr) {
        if (StringUtils.isEmpty(dateStr)) {
            return true;
        }
        dateStr = dateStr.replace("/", "-");
        for (String f : dateFormat) {
            if (!GenericValidator.isDate((String)dateStr, (String)f, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDateTime(String dateStr) {
        if (StringUtils.isEmpty(dateStr)) {
            return true;
        }
        if (dateStr.indexOf(" ") < 0) {
            return false;
        }
        dateStr = dateStr.replace("/", "-");
        String date = dateStr.split(" ")[0];
        String time = dateStr.split(" ")[1];
        if (DateValidatorUsingCommonsValidator.isDate(date)) {
            for (String f : dateTimeFormat) {
                if (!GenericValidator.isDate((String)time, (String)f, (boolean)true)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isTime(String dateStr) {
        if (StringUtils.isEmpty(dateStr)) {
            return true;
        }
        for (String f : dateTimeFormat) {
            if (!GenericValidator.isDate((String)dateStr, (String)f, (boolean)true)) continue;
            return true;
        }
        return false;
    }
}

