/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.eurekaServer;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Service;

@Service
public class LimitRegisterFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LimitRegisterFilter.class);
    private String allowIps;
    @Value(value="${refresh.time.ms:60000}")
    private long refreshTimeInMs;
    private String allowIps0 = "127.0.0.1,0:0:0:0:0:0:0:1,";
    private static AtomicLong accessCount = new AtomicLong();
    private static AtomicLong registerCount = new AtomicLong();
    private static AtomicLong rejectRegisterCount = new AtomicLong();
    private static AtomicLong noNeedRegisterCount = new AtomicLong();
    private static AtomicLong nullProjectNameAndServiceNameRegisterCount = new AtomicLong();
    private static Map<String, Long> lastRegisterTimeMap = new ConcurrentHashMap();
    private Config config = null;

    @PostConstruct
    public void init() {
        this.config = ConfigService.getAppConfig();
        this.allowIps = this.config.getProperty("allow.ips", "*");
        this.allowIps = this.allowIps0 + this.allowIps;
        LOGGER.info("\u521d\u59cb\u5316\u8fc7\u6ee4\u5668, \u5141\u8bb8\u7684IP\u5730\u5740: {}", (Object)this.allowIps);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        LOGGER.info("\u521d\u59cb\u5316\u8fc7\u6ee4\u5668");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.config == null) {
            this.config = ConfigService.getAppConfig();
        }
        this.allowIps = this.config.getProperty("allow.ips", "*");
        this.allowIps = this.allowIps0 + this.allowIps;
        accessCount.incrementAndGet();
        HttpServletRequest req = (HttpServletRequest)request;
        String uri = req.getRequestURI();
        String method = req.getMethod();
        String ip = request.getRemoteAddr();
        LOGGER.info("\u6ce8\u518cIP:{}\u5141\u8bb8\u7684IP\u5730\u5740: {}", (Object)ip, (Object)this.allowIps);
        if ("PUT".equals(method.toUpperCase()) && uri.contains("/eureka/apps/")) {
            LOGGER.info("\u653e\u884c\uff1a" + uri);
        } else {
            LOGGER.info("\u8bbf\u95ee\u4fe1\u606f, ip: {}, method: {}, uri: {}", new Object[]{ip, method, uri});
            if (!"GET".equals(method.toUpperCase()) && (uri.contains("eureka/apps") || uri.contains("eureka/v2/apps"))) {
                LOGGER.info("\u6ce8\u518c\u670d\u52a1, ip: {}, method: {}, uri: {}", new Object[]{ip, method, uri});
                if (this.allowIps == null || !this.allowIps.contains(ip) && !this.allowIps.contains("*")) {
                    LOGGER.info("\u4e0d\u5141\u8bb8\u7684IP\u6ce8\u518c: {}, \u603b\u7684\u8bbf\u95ee\u6b21\u6570: {}, \u6ce8\u518c\u6b21\u6570: {}, \u65e0\u9700\u6ce8\u518c\u6b21\u6570: {}, \u62d2\u7edd\u6ce8\u518c\u6b21\u6570: {}, \u83b7\u53d6\u4e0d\u5230\u9879\u76ee\u540d\u79f0\u548c\u670d\u52a1\u540d\u79f0\u6570: {}", new Object[]{ip, accessCount.get(), registerCount.get(), noNeedRegisterCount.get(), rejectRegisterCount.get(), nullProjectNameAndServiceNameRegisterCount.get()});
                    rejectRegisterCount.incrementAndGet();
                    return;
                }
            }
        }
        filterChain.doFilter(request, response);
    }

    public void destroy() {
        LOGGER.info("\u9500\u6bc1\u8fc7\u6ee4\u5668");
    }

    @Bean
    public FilterRegistrationBean filterRegistrationBean() {
        LimitRegisterFilter limitRegisterFilter = new LimitRegisterFilter();
        limitRegisterFilter.allowIps = this.allowIps;
        limitRegisterFilter.refreshTimeInMs = this.refreshTimeInMs;
        LOGGER.info("\u6ce8\u518c\u8fc7\u6ee4\u5668ServerRequestAuthFilter, \u5141\u8bb8\u7684IP\u5730\u5740: {}", (Object)this.allowIps);
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)limitRegisterFilter, new ServletRegistrationBean[0]);
        registration.addUrlPatterns(new String[]{"/*"});
        return registration;
    }
}

