<#import "/spring.ftl" as spring />
<!doctype html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js"> <!--<![endif]-->
  <head>
    <base href="<@spring.url basePath/>">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Eureka</title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width">

    <link rel="stylesheet" href="eureka/css/wro.css">

  </head>

  <body id="one">
    <#include "header.ftl">
    <div class="container-fluid xd-container">
      <#include "navbar.ftl">
      <h1>Instances currently registered with Eureka</h1>
      <table id='instances' class="table table-striped table-hover">
        <thead>
          <tr><th>Application</th><th>AMIs</th><th>Availability Zones</th><th>Status(点击实例可下线或上线服务)</th></tr>
        </thead>
        <tbody>
          <#if apps?has_content>
            <#list apps as app>
              <tr>
                <td><b>${app.name}</b></td>
                <td>
                  <#list app.amiCounts as amiCount>
                    <b>${amiCount.key}</b> (${amiCount.value})<#if amiCount_has_next>,</#if>
                  </#list>
                </td>
                <td>
                  <#list app.zoneCounts as zoneCount>
                    <b>${zoneCount.key}</b> (${zoneCount.value})<#if zoneCount_has_next>,</#if>
                  </#list>
                </td>
                <td>
                  <#list app.instanceInfos as instanceInfo>
                    <#if instanceInfo.isNotUp>
                      <font color=red size=+1><b>
                    </#if>
                    <b>${instanceInfo.status}</b> (${instanceInfo.instances?size}) -
                    <#if instanceInfo.isNotUp>
                      </b></font>
                    </#if>
                    <#list instanceInfo.instances as instance>
                      <#if instance.isHref>
                        <!--href="${instance.url}"-->
                        <a name="serverId"  title="${instance.id}" onclick="onclick1('${instanceInfo.status}','${instance.id}','${app.name}');" target="_blank" >${instance.id}
                        </a>
                      <#else>
                        ${instance.id}
                      </#if><#if instance_has_next>,</#if>
                    </#list>
                  </#list>
                </td>
              </tr>
            </#list>
          <#else>
            <tr><td colspan="4">No instances available</td></tr>
          </#if>

        </tbody>
      </table>

      <h1>General Info</h1>

      <table id='generalInfo' class="table table-striped table-hover">
        <thead>
          <tr><th>Name</th><th>Value</th></tr>
        </thead>
        <tbody>
          <#list statusInfo.generalStats?keys as stat>
            <tr>
              <td>${stat}</td><td>${statusInfo.generalStats[stat]!""}</td>
            </tr>
          </#list>
          <#list statusInfo.applicationStats?keys as stat>
            <tr>
              <td>${stat}</td><td>${statusInfo.applicationStats[stat]!""}</td>
            </tr>
          </#list>
        </tbody>
      </table>

      <h1>Instance Info</h1>

      <table id='instanceInfo' class="table table-striped table-hover">
        <thead>
          <tr><th>Name</th><th>Value</th></tr>
        <thead>
        <tbody>
          <#list instanceInfo?keys as key>
            <tr>
              <td>${key}</td><td>${instanceInfo[key]!""}</td>
            </tr>
          </#list>
        </tbody>
      </table>
    </div>
    <script type="text/javascript" src="eureka/js/wro.js" ></script>
    <script type="text/javascript">
       $(document).ready(function() {
         $('table.stripeable tr:odd').addClass('odd');
         $('table.stripeable tr:even').addClass('even');

            onclick1=function(status,instanceId,appName) {
                var url="";
                var isOk=0;
                if(status=="UP"){//window.location.href
                    if(confirm("警告！下线服务将导致系统无法访问，确定要下线服务吗？")){
                        isOk=1;
                    }
                    url=window.location.href+"eureka/apps/"+appName+"/"+instanceId+"/status?value=DOWN";

                }
                if(status!="UP"){//window.location.href
                    if(confirm("警告！确定要上线服务吗？")){
                        isOk=1;
                    }
                    url=window.location.href+"eureka/apps/"+appName+"/"+instanceId+"/status?value=UP";
                }
                //alert(url);
                // $.post(url,"",function(ret){
                //     alert("服务已下线");
                // });
                if(isOk==1){
                    $.ajax({
                        type: 'POST',
                        data: "&_method=put",
                        url: url,
                        success: function (msg) {
                            if(status=="UP"){
                                alert("服务已下线，刷新页面查看");
                            }else{
                                alert("服务已上线，刷新页面查看");
                            }

                        }
                    });
                }
            }
            fullServerName=function(){
                console.log($("[name=serverId]"));
                $("[name=serverId]").each(function(index,element) {
                    var serverId=$(this).attr("title");
                    var server=getServerName(serverId);
                    //console.log(server);//
                    $(this).text(server);
                });
            }

            getServerName=function(instanceId) {
                var instance=instanceId.split(":");
                var port=instance[instance.length-1];
                port=":"+port;
                var server=instance[0];
                switch (server){
                    case '172.17.3.51':
                        return 'staging1'+port;
                    case '172.17.3.50':
                        return 'staging3'+port;
                    case '172.17.3.52':
                        return 'staging2'+port;
                    case '172.17.16.4':
                        return 'web4'+port;
                    case '172.17.3.65':
                        return 'test2'+port;
                    case '172.17.3.56':
                        return 'erp2'+port;
                    case '172.17.3.71':
                        return 'web2'+port;
                    case '172.17.3.70':
                        return 'user2'+port;
                    case '172.17.3.66':
                        return 'user1'+port;
                    case '172.17.3.68':
                        return 'web3'+port;
                    case '172.17.3.69':
                        return 'web1'+port;
                    case '172.17.3.64':
                        return 'test1'+port;
                    case '172.17.3.67':
                        return 'erp1';
                    case 'iZ2ze394y9tahekkwsohacZ':
                        return 'staging1'+port;
                }
                // if(server.indexOf("192.168.")>=0){
                //     return 'local';
                // }
                return instanceId;
            }
           fullServerName();
       });

    </script>
  </body>
</html>
