/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.gatewaynewserver.filter;

import cc.lechun.framework.gatewaynewserver.apiInvoke.BaseServiceInvoke;
import cc.lechun.framework.gatewaynewserver.config.shiro.MallUserEntity;
import cc.lechun.framework.gatewaynewserver.util.BaseJsonVoGate;
import cc.lechun.framework.gatewaynewserver.util.DateUtils;
import cc.lechun.framework.gatewaynewserver.util.IpUtilGate;
import cc.lechun.framework.gatewaynewserver.util.JsonUtilsGate;
import cc.lechun.framework.gatewaynewserver.util.LoginUtilsGate;
import cc.lechun.framework.gatewaynewserver.util.RedisCacheUtilGate;
import com.aliyun.openservices.aliyun.log.producer.Producer;
import com.aliyun.openservices.log.common.LogItem;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.support.MvcFoundOnClasspathException;
import org.springframework.cloud.gateway.support.NotFoundException;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.gateway.support.ServiceUnavailableException;
import org.springframework.cloud.gateway.support.TimeoutException;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
@Order(value=99)
public class RightControlFilter
implements GlobalFilter {
    @Value(value="${serverHosts:*}")
    private String serverHosts;
    private static final Logger logger = LoggerFactory.getLogger(RightControlFilter.class);
    @Value(value="${whiteList}")
    private String writeList;
    @Value(value="${ipWriteList}")
    private String ipWriteList;
    @Value(value="${lechun.environment}")
    private String environment;
    @Autowired
    private BaseServiceInvoke baseServiceInvoke;
    @Value(value="${ipBlackList}")
    private String ipBlackList;
    @Value(value="${aliyun.sls.project}")
    private String project;
    @Value(value="${aliyun.sls.logStore}")
    private String logStore;
    @Value(value="${allowOrigin}")
    private String allowOrigin;
    @Autowired
    private RedisCacheUtilGate redisCacheUtil;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private LoginUtilsGate loginUtils;
    @Autowired
    private Producer producer;

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        Integer control;
        exchange.getAttributes().put("BEGIN_VISIT_TIME", System.currentTimeMillis());
        ServerHttpRequest req = exchange.getRequest();
        ServerHttpResponse res = exchange.getResponse();
        res.getHeaders().add("gateway", this.getServerName(req.getLocalAddress().getAddress().getHostAddress()));
        if (req.getMethod().equals((Object)HttpMethod.OPTIONS)) {
            return chain.filter(exchange);
        }
        String path = (String)exchange.getAttribute("sysPath");
        if (path == null) {
            path = req.getPath().value().toLowerCase();
        }
        String ref = req.getHeaders().getFirst("Referer");
        String ip = IpUtilGate.getCliectIp((ServerHttpRequest)req);
        logger.info("ref:" + ref + ",ip:" + ip + ",path:" + path);
        BaseJsonVoGate jsonVo = this.loginUserId(req, path);
        Object pageRouterUrl = (String)req.getQueryParams().getFirst((Object)"pageRouterUrl");
        if (StringUtils.isEmpty((Object)pageRouterUrl) && (pageRouterUrl = req.getHeaders().getFirst("Pagerouterurl")) == null) {
            pageRouterUrl = "";
        }
        LogItem logItem = this.saveLogBefore(exchange, jsonVo, (String)pageRouterUrl);
        String[] urlArr = ((String)pageRouterUrl).split("/");
        pageRouterUrl = "";
        for (String url : urlArr) {
            Pattern pattern;
            boolean b;
            if (url == "" || (b = (pattern = Pattern.compile("[0-9]*")).matcher(url).matches())) continue;
            pageRouterUrl = (String)pageRouterUrl + "/" + url;
        }
        String testAuthor = (String)req.getQueryParams().getFirst((Object)"testAuthor");
        if (StringUtils.isEmpty((Object)testAuthor)) {
            testAuthor = req.getHeaders().getFirst("testAuthor");
        }
        if ((control = this.isControl(path, (String)pageRouterUrl)) == 1 || control == 2) {
            if (this.isIpBlackList(req)) {
                logger.info("\u9ed1\u540d\u5355\u62e6\u622a\uff0c\u91cd\u5b9a\u5411\u5230\u65e0\u6743\u9650\u9875\u9762" + path);
                return this.updateResponse(exchange, chain, new BaseJsonVoGate(403, "\u65e0\u6743\u9650\uff01"), logItem);
            }
            if (this.isIpWriteList(req)) {
                logger.info("ip\u767d\u540d\u5355\u653e\u884c" + path);
                return this.getVoidMono(exchange, chain, logItem);
            }
            if (this.isWriteList(path)) {
                logger.info("\u767d\u540d\u5355\u653e\u884c" + path);
                return this.getVoidMono(exchange, chain, logItem);
            }
            if (this.isTestAuthor(req, path, testAuthor)) {
                logger.info("\u6d4b\u8bd5\u653e\u884c" + path);
                return this.getVoidMono(exchange, chain, logItem);
            }
            if (!jsonVo.isSuccess()) {
                logger.info("\u6ca1\u6709\u767b\u5f55\u91cd\u5b9a\u5411\u5230\u767b\u5f55" + path);
                return this.updateResponse(exchange, chain, new BaseJsonVoGate(20112, "\u5ba2\u6237\u7aef\u672a\u767b\u5f55\uff01"), logItem);
            }
            if (control == 2) {
                logger.info("\u6743\u9650\u5224\u65ad\uff1auser:" + String.valueOf(jsonVo.getValue()) + "_pageUrl:" + (String)pageRouterUrl);
                String userId = ((MallUserEntity)jsonVo.getValue()).getUserId();
                try {
                    jsonVo = this.baseServiceInvoke.getUserRoleRight(userId, (String)pageRouterUrl, Integer.valueOf(1));
                }
                catch (Exception e) {
                    jsonVo = BaseJsonVoGate.error((String)("\u6743\u9650\u670d\u52a1\u8c03\u4e0d\u901a\u4e86" + path));
                }
                if (!jsonVo.isSuccess()) {
                    logger.info("\u6ca1\u6709\u6743\u9650\uff0c\u62e6\u622a\uff0c\u91cd\u5b9a\u5411\u5230\u65e0\u6743\u9650\u9875\u9762" + path);
                    return this.updateResponse(exchange, chain, new BaseJsonVoGate(403, "\u65e0\u6743\u9650\uff01"), logItem);
                }
                String referer = req.getHeaders().getFirst("Referer");
                logger.info("path:" + path + "\u5f97\u5230referer\uff1a" + referer);
                if (referer == null || !referer.contains("lechun.cc")) {
                    return this.updateResponse(exchange, chain, new BaseJsonVoGate(403, "\u65e0\u6743\u9650\uff01"), logItem);
                }
            }
            logger.info("\u6240\u6709\u89c4\u5219\u901a\u8fc7\uff0c\u653e\u884c" + path);
        } else {
            logger.info("\u4e0d\u62e6\u622a\u653e\u884c" + path);
        }
        return this.getVoidMono(exchange, chain, logItem);
    }

    public Mono<Void> updateResponse(ServerWebExchange exchange, GatewayFilterChain chain, BaseJsonVoGate jsonVo, LogItem logItem) {
        ServerHttpResponse response = exchange.getResponse();
        response.setStatusCode((HttpStatusCode)HttpStatus.OK);
        String ref = exchange.getRequest().getHeaders().getFirst("Referer");
        if (ref == null) {
            ref = "";
        }
        if (ref.endsWith("/")) {
            ref = ref.substring(0, ref.length() - 1);
        }
        boolean isAllowOrigin = false;
        for (String origin : this.allowOrigin.split(",")) {
            if (!ref.contains(origin)) continue;
            isAllowOrigin = true;
        }
        if (!isAllowOrigin) {
            ref = "https://lechun.cc";
        }
        String allowOrigin = ref;
        return exchange.getRequest().getBody().collectList().flatMap(list -> {
            StringBuffer str = new StringBuffer();
            for (DataBuffer buf : list) {
                byte[] bytes = new byte[buf.readableByteCount()];
                buf.read(bytes);
                str.append(new String(bytes));
            }
            byte[] bytes = JsonUtilsGate.toJson((Object)jsonVo, (boolean)false).getBytes();
            response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
            response.getHeaders().setAcceptCharset(Collections.singletonList(StandardCharsets.UTF_8));
            response.getHeaders().set("Content-Length", "" + bytes.length);
            if (allowOrigin != null) {
                response.getHeaders().add("Access-Control-Allow-Origin", allowOrigin);
            }
            response.getHeaders().add("Access-Control-Allow-Methods", "*");
            response.getHeaders().add("Access-Control-Allow-Credentials", "true");
            response.getHeaders().add("Access-Control-Allow-Headers", "*");
            DataBuffer buff = response.bufferFactory().wrap(bytes);
            this.saveLogAfter(exchange, logItem, "200");
            return response.writeWith((Publisher)Mono.just((Object)buff));
        });
    }

    public ServerWebExchange responseHeader(ServerWebExchange exchange) {
        ServerHttpResponse response = exchange.getResponse();
        response.setStatusCode((HttpStatusCode)HttpStatus.OK);
        response.getHeaders().add("Content-Type", "application/json;charset=UTF-8");
        response.getHeaders().add("Access-Control-Allow-Origin", "*");
        response.getHeaders().add("Access-Control-Allow-Methods", "*");
        response.getHeaders().add("Access-Control-Allow-Credentials", "true");
        response.getHeaders().add("Access-Control-Allow-Headers", "*");
        return exchange.mutate().response(response).build();
    }

    private Integer isControl(String path, String pageRouterUrl) {
        String[] curArr = path.split("/");
        String curSys = "";
        if (curArr.length > 0) {
            String string = curSys = curArr.length > 1 ? curArr[1] : curArr[0];
        }
        if (pageRouterUrl.startsWith("/csms")) {
            curSys = "lechun-csms";
        }
        if (pageRouterUrl.startsWith("/admin")) {
            curSys = "lechun-ams";
        }
        if (pageRouterUrl.startsWith("/oa")) {
            curSys = "lechun-oa";
        }
        if (pageRouterUrl.startsWith("/scrm")) {
            curSys = "lechun-cms";
        }
        if (pageRouterUrl.endsWith("dashboard") || pageRouterUrl.equals("/oa/formplayground")) {
            return 0;
        }
        List lst = this.getEnableSystemList(1);
        for (String p : lst) {
            if (!curSys.toLowerCase().equals(p.toLowerCase())) continue;
            return 1;
        }
        lst = this.getEnableSystemList(2);
        for (String p : lst) {
            if (!curSys.toLowerCase().equals(p.toLowerCase())) continue;
            return 2;
        }
        return 0;
    }

    private List<String> getEnableSystemList(int type) {
        BaseJsonVoGate jsonVo;
        String key = "gateway.enableSystemList" + type;
        Object obj = this.redisCacheUtil.get(key);
        if (obj != null) {
            return (List)obj;
        }
        try {
            jsonVo = this.baseServiceInvoke.getEnableSystemList(Integer.valueOf(type));
        }
        catch (Exception e) {
            jsonVo = BaseJsonVoGate.error((String)"\u6743\u9650\u670d\u52a1\u8c03\u4e0d\u901a\u4e86");
        }
        if (jsonVo.isSuccess()) {
            List list = (List)jsonVo.getValue();
            this.redisCacheUtil.set(key, (Object)list, Long.valueOf(300L));
            return list;
        }
        return new ArrayList<String>();
    }

    private boolean isWriteList(String path) {
        for (String p : this.writeList.split("\\n")) {
            if (!path.contains(p.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private boolean isIpWriteList(ServerHttpRequest req) {
        if (!StringUtils.isEmpty((Object)this.ipWriteList)) {
            String ip = IpUtilGate.getCliectIp((ServerHttpRequest)req);
            String[] arr = this.ipWriteList.split("\\n");
            logger.info("ipWriteList:" + ip);
            for (String p : arr) {
                if (!p.contains(ip)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isTestAuthor(ServerHttpRequest req, String path, String testAuthor) {
        if (StringUtils.isEmpty((Object)testAuthor)) {
            return false;
        }
        BaseJsonVoGate jsonVo = this.loginUtils.checkTestAuthor(req, testAuthor);
        logger.info("isTestAuthor:" + jsonVo.isSuccess() + "\uff0cmessage\uff1a" + jsonVo.getMessage());
        return jsonVo.isSuccess();
    }

    private boolean isServiceInvoke(ServerHttpRequest req) {
        return true;
    }

    private boolean isIpBlackList(ServerHttpRequest req) {
        if (!StringUtils.isEmpty((Object)this.ipBlackList)) {
            String[] arr;
            String ip = IpUtilGate.getCliectIp((ServerHttpRequest)req);
            for (String p : arr = this.ipBlackList.split("\\n")) {
                if (!p.contains(ip)) continue;
                return true;
            }
        }
        return false;
    }

    private BaseJsonVoGate<MallUserEntity> loginUserId(ServerHttpRequest req, String path) {
        try {
            if (path.contains("/lechun-mall/")) {
                return BaseJsonVoGate.error((String)"mall\u6ca1\u6709\u767b\u5f55\u5440");
            }
            MallUserEntity user = this.loginUtils.getUser(req);
            return BaseJsonVoGate.success((Object)user);
        }
        catch (Exception e) {
            return BaseJsonVoGate.error((String)"\u6ca1\u6709\u767b\u5f55\u5440");
        }
    }

    public Mono<Void> getVoidMono(ServerWebExchange exchange, GatewayFilterChain chain, LogItem logItem) {
        return chain.filter(exchange).then(Mono.fromRunnable(() -> {
            if (exchange.getResponse().getStatusCode() != HttpStatus.OK) {
                this.saveLogAfter(exchange, logItem, String.valueOf(exchange.getResponse().getStatusCode().value()));
                logger.error("\u7f51\u5173\u8bf7\u6c42\u5fae\u670d\u52a1\u5f02\u5e38\uff1a{}", (Object)logItem.ToJsonString());
            } else {
                this.saveLogAfter(exchange, logItem, "200");
            }
        })).doOnError(e -> {
            if (e instanceof MvcFoundOnClasspathException) {
                this.saveLogAfter(exchange, logItem, "100");
            } else if (e instanceof NotFoundException) {
                this.saveLogAfter(exchange, logItem, String.valueOf(((NotFoundException)e).getStatusCode().value()));
            } else if (e instanceof ServiceUnavailableException) {
                this.saveLogAfter(exchange, logItem, String.valueOf(((NotFoundException)e).getStatusCode().value()));
            } else if (e instanceof TimeoutException) {
                this.saveLogAfter(exchange, logItem, String.valueOf(HttpStatus.GATEWAY_TIMEOUT.value()));
            } else if (e instanceof ResponseStatusException) {
                this.saveLogAfter(exchange, logItem, String.valueOf(((ResponseStatusException)e).getStatusCode().value()));
            }
            logger.error("\u7f51\u5173\u5f02\u5e38\uff1a{}\uff0c{}", (Object)logItem.ToJsonString(), e);
        }).then();
    }

    private LogItem saveLogBefore(ServerWebExchange exchange, BaseJsonVoGate<MallUserEntity> jsonVo, String pageRouterUrl) {
        ServerHttpRequest req = exchange.getRequest();
        try {
            String action = (String)exchange.getAttribute("sysPath");
            if (action == null) {
                action = req.getPath().value().toLowerCase();
            }
            if (!(StringUtils.isEmpty((Object)action) || action.contains("/health") || action.contains("/saveaccesslog"))) {
                String[] split;
                String method = req.getMethod().name();
                LogItem logItem = new LogItem();
                if (HttpMethod.POST.matches(method.toUpperCase())) {
                    Object body = exchange.getAttributes().get("POST_BODY");
                    MultiValueMap m = req.getQueryParams();
                    logItem.PushBack("\u53c2\u6570", body != null ? body.toString() : (m != null ? m.toString() : ""));
                } else if (HttpMethod.GET.matches(method)) {
                    MultiValueMap m = req.getQueryParams();
                    logItem.PushBack("\u53c2\u6570", m != null ? m.toString() : "");
                }
                logItem.PushBack("\u552f\u4e00ID", exchange.getRequest().getId());
                logItem.PushBack("\u5458\u5de5ID", jsonVo.isSuccess() ? ((MallUserEntity)jsonVo.getValue()).getUserId() : "");
                logItem.PushBack("\u5458\u5de5\u59d3\u540d", jsonVo.isSuccess() ? ((MallUserEntity)jsonVo.getValue()).getUserNick() : "");
                logItem.PushBack("IP", IpUtilGate.getCliectIp((ServerHttpRequest)req));
                String sys = "";
                if (!StringUtils.isEmpty((Object)action) && (split = action.split("/")).length > 1) {
                    sys = split[1];
                }
                logItem.PushBack("\u7cfb\u7edf", sys);
                logItem.PushBack("\u63a5\u53e3", action);
                logItem.PushBack("\u8bbf\u95ee\u65f6\u95f4", DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                logItem.PushBack("\u8bbf\u95ee\u65b9\u5f0f", method);
                logItem.PushBack("\u9875\u9762", pageRouterUrl);
                logItem.PushBack("\u7f51\u5173", this.getServerName(req.getLocalAddress().getAddress().getHostAddress()));
                logItem.PushBack("\u7f51\u5173\u7aef\u53e3", String.valueOf(req.getLocalAddress().getPort()));
                logItem.PushBack("userTicket", (String)req.getQueryParams().getFirst((Object)"userTicket"));
                logItem.PushBack("\u73af\u5883", this.environment);
                return logItem;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void saveLogAfter(ServerWebExchange exchange, LogItem logItem, String status) {
        if (logItem != null) {
            try {
                Long beginVisitTime = (Long)exchange.getAttribute("BEGIN_VISIT_TIME");
                if (logItem != null) {
                    URI requestUrl = (URI)exchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
                    if (requestUrl != null) {
                        String name = this.getServerName(requestUrl.getHost());
                        logItem.PushBack("\u76ee\u6807\u673a\u5668", name);
                        logItem.PushBack("\u76ee\u6807\u7aef\u53e3", String.valueOf(requestUrl.getPort()));
                        exchange.getResponse().getHeaders().add("host", name);
                    } else {
                        logItem.PushBack("\u76ee\u6807\u673a\u5668", "none");
                    }
                    logItem.PushBack("\u8bbf\u95ee\u72b6\u6001", status);
                    logItem.PushBack("\u8017\u65f6", String.valueOf(System.currentTimeMillis() - (beginVisitTime == null ? System.currentTimeMillis() : beginVisitTime)));
                    this.producer.send(this.project, this.logStore, logItem);
                }
            }
            catch (Exception e) {
                logger.error("saveLogAfter error", (Throwable)e);
            }
        }
    }

    private String getServerName(String host) {
        try {
            if (host == null || host.equals("localhost") || host.equals("127.0.0.1") || host == "") {
                return host;
            }
            String[] servers = this.serverHosts.split(",");
            String h1 = Arrays.stream(servers).filter(s -> s.contains(host)).findFirst().orElse(null);
            if (h1 != null) {
                String[] s1 = h1.split("\\:");
                return s1.length > 1 ? s1[1] : "unnown";
            }
        }
        catch (Exception servers) {
            // empty catch block
        }
        if (host.contains(".")) {
            String[] split = host.split("\\.");
            return split[split.length - 1];
        }
        return "";
    }
}

