/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.gatewaynewserver.util;

import cc.lechun.framework.gatewaynewserver.config.shiro.MallUserEntity;
import cc.lechun.framework.gatewaynewserver.util.AuthorizeExceptionGate;
import cc.lechun.framework.gatewaynewserver.util.BaseJsonVoGate;
import cc.lechun.framework.gatewaynewserver.util.CookieUtilsGate;
import cc.lechun.framework.gatewaynewserver.util.MemcachedServiceGate;
import cc.lechun.framework.gatewaynewserver.util.ObjectConvertGate;
import cc.lechun.framework.gatewaynewserver.util.RedisCacheUtilGate;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpCookie;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;

@Component
public class LoginUtilsGate {
    @Autowired
    private RedisCacheUtilGate redisCacheUtil;
    @Autowired
    private MemcachedServiceGate memcachedService;
    @Value(value="${app.id:#{NULL}}")
    private String appId;
    private static final Logger log = LoggerFactory.getLogger(LoginUtilsGate.class);

    public Map<String, String> getUserMap(ServerHttpRequest req) throws AuthorizeExceptionGate {
        BaseJsonVoGate jsonVo;
        if (req == null) {
            throw new AuthorizeExceptionGate("\u7528\u6237\u672a\u767b\u9646");
        }
        String testAuthor = (String)req.getQueryParams().getFirst((Object)"testAuthor");
        if (StringUtils.isEmpty((CharSequence)testAuthor)) {
            testAuthor = req.getHeaders().getFirst("testAuthor");
        }
        if ((jsonVo = this.checkTestAuthor(req, testAuthor)).isSuccess()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userId", testAuthor.split("_")[0]);
            map.put("userName", "test");
            map.put("userNick", "test");
            return map;
        }
        String key = "JSESSIONID";
        HttpCookie cookie = CookieUtilsGate.getCookie((ServerHttpRequest)req, (String)"JSESSIONID");
        if (cookie == null) {
            throw new AuthorizeExceptionGate("\u7528\u6237\u672a\u767b\u9646");
        }
        String jsessionid = cookie.getValue();
        if (StringUtils.isEmpty((CharSequence)jsessionid)) {
            throw new AuthorizeExceptionGate("\u7528\u6237\u672a\u767b\u9646");
        }
        Object user = null;
        try {
            user = this.redisCacheUtil.get(key + jsessionid);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (user == null) {
            try {
                user = this.memcachedService.get(key + jsessionid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (user == null) {
            throw new AuthorizeExceptionGate("\u7528\u6237\u672a\u767b\u9646");
        }
        return (Map)user;
    }

    public Boolean isLogin(ServerHttpRequest req) {
        try {
            Map map = this.getUserMap(req);
            if (map != null) {
                return true;
            }
        }
        catch (AuthorizeExceptionGate authorizeExceptionGate) {
            // empty catch block
        }
        return false;
    }

    public MallUserEntity getLoginUser(ServerHttpRequest req) {
        try {
            return this.getUser(req);
        }
        catch (AuthorizeExceptionGate authorizeExceptionGate) {
            return null;
        }
    }

    public String getLoginUserId(ServerHttpRequest req) {
        try {
            return this.getUser(req).getUserId();
        }
        catch (AuthorizeExceptionGate authorizeExceptionGate) {
            return null;
        }
    }

    public MallUserEntity getUser(ServerHttpRequest req) throws AuthorizeExceptionGate {
        try {
            Map map = this.getUserMap(req);
            return (MallUserEntity)ObjectConvertGate.mapConvertToObject((Map)map, MallUserEntity.class);
        }
        catch (Exception e) {
            throw new AuthorizeExceptionGate("\u7528\u6237\u672a\u767b\u9646");
        }
    }

    public static void main(String[] args) {
        String path = "https://gatewaytest.lechun.cc/lechun-tools/app/getAppList?pageSize=20&pageNum=1&pageRouterUrl=%2Fdashboard";
        String[] paths = path.split("/");
        if (paths.length < 4) {
            System.out.println("\u9519\u8bef");
        }
        System.out.println(paths[3]);
    }

    public BaseJsonVoGate checkTestAuthor(ServerHttpRequest req, String author) {
        if (req == null) {
            return BaseJsonVoGate.error((String)"\u7528\u6237\u672a\u767b\u9646");
        }
        String path = req.getPath().value().toLowerCase(Locale.ROOT);
        if (StringUtils.isEmpty((CharSequence)path) || StringUtils.isEmpty((CharSequence)author)) {
            return BaseJsonVoGate.error((String)"\u8ba4\u8bc1\u4e3a\u7a7a");
        }
        log.info("\u8bf7\u6c42\u8def\u5f84\uff1a" + path);
        String[] paths = path.split("/");
        if (paths.length >= 4) {
            this.appId = paths[3];
        }
        log.info("\u8bf7\u6c42appID1\uff1a" + this.appId);
        String sys = this.appId;
        String key = sys + "_" + author.split("_")[0];
        Object value = this.redisCacheUtil.get(key.toLowerCase(Locale.ROOT));
        if (value != null) {
            if (author.equals(value.toString())) {
                return BaseJsonVoGate.success((Object)"");
            }
        } else {
            String[] arr = sys.split("-");
            if (arr.length > 1) {
                sys = arr[1];
            }
            if ((value = this.redisCacheUtil.get((key = sys + "_" + author.split("_")[0]).toLowerCase(Locale.ROOT))) != null && author.equals(value.toString())) {
                return BaseJsonVoGate.success((Object)"");
            }
        }
        return BaseJsonVoGate.error((String)"\u8ba4\u8bc1\u9519\u8bef");
    }
}

