/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.gateway.config.shiro;

import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.codec.binary.Hex;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.eis.AbstractSessionDAO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.SerializationUtils;

@Service
public class RedisSessionDao
extends AbstractSessionDAO {
    private long expireTime = 2592000L;
    @Autowired
    private RedisCacheUtil redisCacheUtil;

    public RedisSessionDao() {
    }

    public RedisSessionDao(long expireTime) {
        this.expireTime = expireTime;
    }

    public void update(Session session) throws UnknownSessionException {
        System.out.println("===============update================");
        if (session == null || session.getId() == null) {
            return;
        }
        session.setTimeout(this.expireTime);
        this.saveSession(session);
    }

    public void delete(Session session) {
        System.out.println("===============delete================");
        if (session == null) {
            return;
        }
        this.redisCacheUtil.remove(this.getKey(session.getId().toString()));
    }

    public Collection<Session> getActiveSessions() {
        ArrayList<Session> results = new ArrayList<Session>();
        return results;
    }

    private String getKey(String sessionId) {
        return "shiro_redis_session_" + sessionId;
    }

    protected Serializable doCreate(Session session) {
        System.out.println("===============doCreate================");
        Serializable sessionId = this.generateSessionId(session);
        this.assignSessionId(session, sessionId);
        this.saveSession(session);
        return sessionId;
    }

    private void saveSession(Session session) {
        if (session != null && session.getId() != null) {
            System.out.println("===============doCreate================");
            byte[] value = SerializationUtils.serialize((Object)session);
            String str = Hex.encodeHexString((byte[])value);
            System.out.println("===============doCreate================" + str);
            this.redisCacheUtil.set(this.getKey(session.getId().toString()), (Object)str, Long.valueOf(this.expireTime));
        }
    }

    protected Session doReadSession(Serializable sessionId) {
        System.out.println("==============doReadSession=================");
        if (sessionId == null) {
            return null;
        }
        String value = (String)this.redisCacheUtil.get(this.getKey(sessionId.toString()));
        System.out.println("\u53cd\u5e8f\u5217\u5316sessionID: " + String.valueOf(sessionId) + "=================" + value);
        if (value == null) {
            return null;
        }
        try {
            Session session;
            byte[] b = Hex.decodeHex((char[])value.toCharArray());
            System.out.println("\u53cd\u5e8f\u5217\u5316session: " + b.length + "=================" + b.toString());
            Object obj = SerializationUtils.deserialize((byte[])b);
            System.out.println("\u53cd\u5e8f\u5217\u5316session: " + obj.toString());
            Session session2 = session = obj instanceof Session ? (Session)obj : null;
            if (session == null) {
                System.out.println("\u53cd\u5e8f\u5217\u5316sessionID: " + String.valueOf(sessionId) + " \u4e3a\u7a7a");
            } else {
                System.out.println("\u53cd\u5e8f\u5217\u5316sessionID: " + String.valueOf(sessionId) + " \u4e0d\u4e3a\u7a7a");
            }
            return session;
        }
        catch (Exception e) {
            System.out.println("\u53cd\u5e8f\u5217\u5316sessionID: " + String.valueOf(sessionId) + " \u5f02\u5e38" + e.getMessage());
            return null;
        }
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }
}

