/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.gateway.api;

import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.gateway.config.shiro.AuthBaseService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.jwt.Jwt;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.security.jwt.crypto.sign.MacSigner;
import org.springframework.security.jwt.crypto.sign.Signer;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"bi"})
public class DashboardApi {
    @Value(value="${METABASE_SITE_URL:http://bi.lechun.cc}")
    private String METABASE_SITE_URL;
    @Value(value="${METABASE_SECRET_KEY:93a2a31bb3ecb37239946c31fecae35761eb6f898f4bd8725a437bb29bd5d4eb}")
    private String METABASE_SECRET_KEY;
    @Autowired
    private AuthBaseService authBaseService;

    @RequestMapping(value={"dashboard"})
    public BaseJsonVo getDashboardUrl(String id) {
        return BaseJsonVo.success((Object)this.getBIUrl("dashboard", id));
    }

    @RequestMapping(value={"question"})
    public BaseJsonVo getQuestiondUrl(String id) {
        return BaseJsonVo.success((Object)this.getBIUrl("question", id));
    }

    private String getBIUrl(String q, String Id) {
        String json = "{\"resource\": {\"" + q + "\": " + Id + "}, \"params\": {},\"exp\":" + Math.round(new Date().getTime() / 1000L) + "600}";
        Jwt token = JwtHelper.encode((CharSequence)json, (Signer)new MacSigner(this.METABASE_SECRET_KEY));
        String url = this.METABASE_SITE_URL + "/embed/" + q + "/" + token.getEncoded() + "#bordered=true&titled=true";
        return url;
    }

    @RequestMapping(value={"getUser"})
    public BaseJsonVo getUser() throws AuthorizeException {
        return BaseJsonVo.success((Object)this.authBaseService.getUser());
    }
}

