/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.omsv2.entity.order.process.vo;

import cc.lechun.framework.common.vo.BaseUser;
import cc.lechun.omsv2.entity.order.dispatch.vo.DispatchOrderProductVO;
import cc.lechun.omsv2.entity.order.dispatch.vo.DispatchOrderVO;
import cc.lechun.omsv2.entity.order.process.ProcessOrderEntity;
import cc.lechun.omsv2.entity.order.process.vo.ProcessOrderProductVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessOrderVO
extends ProcessOrderEntity {
    private String storeName;
    private String logisticsName;
    private String customerName;
    private String deptName;
    private String empName;
    private String orderSonTypeName;
    private String typeTobOrToc;

    public String getDeptName() {
        return this.deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getEmpName() {
        return this.empName;
    }

    public void setEmpName(String empName) {
        this.empName = empName;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public String getLogisticsName() {
        return this.logisticsName;
    }

    public void setLogisticsName(String logisticsName) {
        this.logisticsName = logisticsName;
    }

    public static DispatchOrderVO buildDeliverGoodsOrder(ProcessOrderEntity order, BaseUser user) {
        DispatchOrderVO v = new DispatchOrderVO();
        v.setOrderNo(order.getOrderNo());
        v.setOaid(order.getOaid());
        v.setOrderType(order.getOrderType());
        v.setOrderStatus(0);
        v.setOrderPush(1);
        v.setOrderSonType(order.getOrderSonType());
        v.setPlatformType(order.getPlatformType());
        v.setExternalOrderNo(order.getExternalOrderNo());
        v.setOrderIsCw(order.getOrderIsCw());
        v.setDiscountFee(order.getDiscountFee());
        v.setOrderFlowSign(null);
        v.setProductAmount(order.getProductAmount());
        v.setOrderAmount(order.getOrderAmount());
        v.setShopId(order.getShopId());
        v.setShopCode(order.getShopCode());
        v.setShopName(order.getShopName());
        v.setConsigneeMobile(order.getConsigneeMobile());
        v.setConsigneeProvince(order.getConsigneeProvince());
        v.setConsigneeCity(order.getConsigneeCity());
        v.setConsigneeArea(order.getConsigneeArea());
        v.setConsigneeAddress(order.getConsigneeAddress());
        v.setLogisticsId(order.getLogisticsId());
        v.setLogisticsNo(order.getLogisticsNo());
        v.setPostAmount(order.getPostAmount());
        v.setStoreId(order.getStoreId());
        v.setCustomerId(order.getCustomerId());
        v.setPickupTime(order.getPickupTime());
        v.setDeliveryTime(order.getDeliveryTime());
        v.setPayTime(order.getPayTime());
        v.setPayAmount(order.getPayAmount());
        v.setPayAlipayPerAmount(order.getPayAlipayPerAmount());
        v.setPayCouponPerAmount(order.getPayCouponPerAmount());
        v.setPayBalancePerAmount(order.getPayBalancePerAmount());
        v.setPayBalanceChargePerAmount(order.getPayBalanceChargePerAmount());
        v.setPayBalanceFreePerAmount(order.getPayBalanceFreePerAmount());
        v.setPayBalanceGiftPerAmount(order.getPayBalanceGiftPerAmount());
        v.setPayUnionpayPerAmount(order.getPayUnionpayPerAmount());
        v.setPayWechatPerAmount(order.getPayWechatPerAmount());
        v.setExternalCreateTime(order.getExternalCreateTime());
        v.setCreateTime(new Date());
        if (user != null) {
            v.setCreateEmpName(user.getEmployeeName());
        } else {
            v.setCreateEmpName("admin(SYS\u7cfb\u7edf\u751f\u6210)");
        }
        v.setUpdateTime(new Date());
        v.setUpdateEmpName(order.getUpdateEmpName());
        v.setErroType(0);
        v.setAuditNotes(order.getAuditNotes());
        v.setKfNotes(order.getKfNotes());
        v.setBuyernotes(order.getBuyernotes());
        v.setBuyerNickname(order.getBuyerNickname());
        v.setIsPickDate(order.getIsPickDate());
        v.setLogisticsType(order.getLogisticsType());
        v.setHangUpEmpName(null);
        v.setIfHangUp(1);
        v.setConsigneeName(order.getConsigneeName());
        v.setErroMessage(null);
        v.setEncryptionName(order.getEncryptionName());
        v.setEncryptionMobile(order.getEncryptionMobile());
        v.setEncryptionAddress(order.getEncryptionAddress());
        return v;
    }

    public static DispatchOrderProductVO buildDeliverGoodsOrder(ProcessOrderProductVO v) {
        DispatchOrderProductVO sv = new DispatchOrderProductVO();
        sv.setOrderNo(v.getOrderNo());
        sv.setSourceId(v.getCguid());
        sv.setDispatchNo(null);
        sv.setExternalOrderNo(v.getExternalOrderNo());
        sv.setDeliveryTime(v.getDeliveryTime());
        sv.setPartMjzDiscount(v.getPartMjzDiscount());
        sv.setDiscountFee(v.getDiscountFee());
        sv.setPostFee(v.getPostFee());
        sv.setProductId(v.getProductId());
        sv.setProductIsGift(v.getProductIsGift());
        sv.setProductCode(v.getProductCode());
        sv.setProductCbarcode(v.getProductCbarcode());
        sv.setProductName(v.getProductName());
        sv.setProductSpecifications(v.getProductSpecifications());
        sv.setProductNum(v.getProductNum());
        sv.setProductPrice(v.getProductPrice());
        sv.setProductSellPrice(v.getProductSellPrice());
        sv.setIsPromotion(v.getIsPromotion());
        sv.setPromotionId(v.getPromotionId());
        sv.setPromotionName(v.getPromotionName());
        sv.setPayTime(v.getPayTime());
        sv.setErroType(0);
        sv.setFreshnessEnd(v.getFreshnessEnd());
        sv.setFreshnessStart(v.getFreshnessStart());
        sv.setInventory(null);
        sv.setOrderIsCw(v.getOrderIsCw());
        sv.setSuitId(v.getSuitId());
        sv.setSuitName(v.getSuitName());
        sv.setSuitCode(v.getSuitCode());
        sv.setBatch(v.getBatch());
        sv.setBatchType(null);
        sv.setPackingMaterialsId(v.getPackingMaterialsId());
        sv.setPackingQuantity(v.getPackingQuantity());
        sv.setOid(v.getOid());
        sv.setUnitPrice(v.getUnitPrice());
        sv.setProductSellAmount(v.getProductSellAmount().multiply(sv.getProductNum()).setScale(6, 4));
        sv.setProductAmount(v.getProductAmount().multiply(sv.getProductNum()).setScale(6, 4));
        return sv;
    }

    public static List<DispatchOrderProductVO> buildDeliverGoodsOrders(List<ProcessOrderProductVO> products) {
        ArrayList<DispatchOrderProductVO> list = new ArrayList<DispatchOrderProductVO>();
        if (products != null && products.size() > 0) {
            for (ProcessOrderProductVO v : products) {
                list.add(ProcessOrderVO.buildDeliverGoodsOrder(v));
            }
        }
        return list;
    }

    public String getOrderSonTypeName() {
        return this.orderSonTypeName;
    }

    public void setOrderSonTypeName(String orderSonTypeName) {
        this.orderSonTypeName = orderSonTypeName;
    }

    public String getTypeTobOrToc() {
        return this.typeTobOrToc;
    }

    public void setTypeTobOrToc(String typeTobOrToc) {
        this.typeTobOrToc = typeTobOrToc;
    }
}

