/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.oms.entity.importFile;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.oms.entity.dispatch.vo.DispatchDetailVO;
import cc.lechun.oms.entity.dispatch.vo.DispatchVO;
import cc.lechun.oms.entity.importFile.ImportDispatchOrder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ImportToDispatchOrder {
    private ImportDispatchOrder importDispatchOrderEntity;
    private List<ImportDispatchOrder> importDispatchOrderDetails;
    private DispatchVO dispatchOrderEntity;
    private List<DispatchDetailVO> dispatchOrderDetails = new ArrayList<DispatchDetailVO>();

    public void importDispatchOrderEntityToDispatchOrderEntity() {
        if (this.importDispatchOrderEntity != null) {
            DispatchVO dispatchOrderEntity = new DispatchVO();
            String id = IDGenerate.getUniqueIdStr();
            dispatchOrderEntity.setCguid(id);
            dispatchOrderEntity.setPickupdate(DateUtils.StrToDate((String)this.importDispatchOrderEntity.getPickupdate(), (String)"yyyy-MM-dd"));
            dispatchOrderEntity.setCcontacts(this.importDispatchOrderEntity.getCcontacts());
            dispatchOrderEntity.setCcontactnumber(this.importDispatchOrderEntity.getCcontactnumber());
            dispatchOrderEntity.setCdeliveryaddresses(this.importDispatchOrderEntity.getCdeliveryaddresses());
            dispatchOrderEntity.setCcustomerid(this.importDispatchOrderEntity.getCustomerid());
            dispatchOrderEntity.setCwarehouseid(this.importDispatchOrderEntity.getCwarehouseid());
            dispatchOrderEntity.setStoreName(this.importDispatchOrderEntity.getCwarehouseName());
            dispatchOrderEntity.setCremark(this.importDispatchOrderEntity.getCremark());
            dispatchOrderEntity.setcCreatorName(this.importDispatchOrderEntity.getcCreatorName());
            dispatchOrderEntity.setDcreatetime(this.importDispatchOrderEntity.getDcreatetime());
            dispatchOrderEntity.setOuterorderno(this.importDispatchOrderEntity.getOuterOrderNo());
            dispatchOrderEntity.setProvincename(this.importDispatchOrderEntity.getProvincename());
            dispatchOrderEntity.setCityname(this.importDispatchOrderEntity.getCityname());
            dispatchOrderEntity.setAreaname(this.importDispatchOrderEntity.getAreaname());
            dispatchOrderEntity.setBuyermessage(this.importDispatchOrderEntity.getBuyerMessage());
            dispatchOrderEntity.setSalestype(this.importDispatchOrderEntity.getSalesType());
            dispatchOrderEntity.setSalestypecode(this.importDispatchOrderEntity.getSalestypecode());
            dispatchOrderEntity.setCtenantid(this.importDispatchOrderEntity.getCtenantid());
            dispatchOrderEntity.setCcreator(this.importDispatchOrderEntity.getCcreator());
            dispatchOrderEntity.setcCreatorName(this.importDispatchOrderEntity.getcCreatorName());
            dispatchOrderEntity.setDcreatetime(this.importDispatchOrderEntity.getDcreatetime());
            dispatchOrderEntity.setDdate(this.importDispatchOrderEntity.getDdate());
            dispatchOrderEntity.setDdeliverydate(dispatchOrderEntity.getPickupdate());
            dispatchOrderEntity.setEmpName(this.importDispatchOrderEntity.getEmpName());
            dispatchOrderEntity.setCemployeeid(this.importDispatchOrderEntity.getCemployeeid());
            dispatchOrderEntity.setLogisticstypecode(this.importDispatchOrderEntity.getLogisticsTypeCode());
            dispatchOrderEntity.setLogisticstypename(this.importDispatchOrderEntity.getLogisticsTypeName());
            dispatchOrderEntity.setFromtype(1);
            dispatchOrderEntity.setOrdertype(1);
            dispatchOrderEntity.setItotal(new BigDecimal(this.importDispatchOrderDetailsToDispatchOrderDetailEntity(id)));
            this.dispatchOrderEntity = dispatchOrderEntity;
        }
    }

    private Double importDispatchOrderDetailsToDispatchOrderDetailEntity(String headId) {
        ArrayList<DispatchDetailVO> newList = new ArrayList<DispatchDetailVO>();
        Double itotal = 0.0;
        if (this.importDispatchOrderDetails != null && this.importDispatchOrderDetails.size() > 0) {
            for (ImportDispatchOrder importDispatchOrder : this.importDispatchOrderDetails) {
                DispatchDetailVO dde = new DispatchDetailVO();
                dde.setCguid(IDGenerate.getUniqueIdStr());
                dde.setFreshness(Integer.valueOf(importDispatchOrder.getFreshness()));
                dde.setIqty(new BigDecimal(importDispatchOrder.getIqty()));
                if (StringUtils.isNotBlank((CharSequence)importDispatchOrder.getItotal())) {
                    dde.setItotal(new BigDecimal(importDispatchOrder.getItotal()));
                }
                if (StringUtils.isNotBlank((CharSequence)importDispatchOrder.getIquotedtaxprice())) {
                    dde.setIquotedtaxprice(new BigDecimal(importDispatchOrder.getIquotedtaxprice()));
                }
                dde.setCmatid(importDispatchOrder.getCmatid());
                dde.setCmatname(importDispatchOrder.getMatname());
                dde.setCshipmentid(headId);
                if (StringUtils.isNotBlank((CharSequence)importDispatchOrder.getItotal())) {
                    Double sum = Double.valueOf(importDispatchOrder.getItotal()) / (1.0 + Double.valueOf(importDispatchOrder.getItaxrate()) / 100.0);
                    dde.setIamt(new BigDecimal(sum));
                }
                dde.setIdiscount(100.0);
                dde.setIdeductions(new BigDecimal(0));
                dde.setItaxrate(Integer.parseInt(importDispatchOrder.getItaxrate()));
                dde.setIgiveaway(importDispatchOrder.getIgiveaway());
                dde.setCunitid(importDispatchOrder.getCunitid());
                if (importDispatchOrder.getIgiveaway().equals("\u662f")) {
                    dde.setIquotedtaxprice(new BigDecimal(0.0));
                    dde.setItotal(new BigDecimal(0.0));
                    dde.setItaxprice(new BigDecimal(0.0));
                    dde.setIamt(new BigDecimal(0.0));
                    dde.setIdeductions(new BigDecimal(0.0));
                }
                if (StringUtils.isNotBlank((CharSequence)importDispatchOrder.getItotal())) {
                    itotal = itotal + Double.valueOf(importDispatchOrder.getItotal());
                }
                newList.add(dde);
            }
        }
        this.dispatchOrderDetails = newList;
        return itotal;
    }

    public ImportDispatchOrder getImportDispatchOrderEntity() {
        return this.importDispatchOrderEntity;
    }

    public void setImportDispatchOrderEntity(ImportDispatchOrder importDispatchOrderEntity) {
        this.importDispatchOrderEntity = importDispatchOrderEntity;
    }

    public List<ImportDispatchOrder> getImportDispatchOrderDetails() {
        return this.importDispatchOrderDetails;
    }

    public void setImportDispatchOrderDetails(List<ImportDispatchOrder> importDispatchOrderDetails) {
        this.importDispatchOrderDetails = importDispatchOrderDetails;
    }

    public DispatchVO getDispatchOrderEntity() {
        return this.dispatchOrderEntity;
    }

    public void setDispatchOrderEntity(DispatchVO dispatchOrderEntity) {
        this.dispatchOrderEntity = dispatchOrderEntity;
    }

    public List<DispatchDetailVO> getDispatchOrderDetails() {
        return this.dispatchOrderDetails;
    }

    public void setDispatchOrderDetails(List<DispatchDetailVO> dispatchOrderDetails) {
        this.dispatchOrderDetails = dispatchOrderDetails;
    }
}

