/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.apiinvoke.backService;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class FeignConfiguration
implements RequestInterceptor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void apply(RequestTemplate template) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                String values = request.getHeader(name);
                template.header(name, new String[]{values});
            }
            this.logger.info("feign interceptor header:{}", (Object)template);
        }
    }
}

