/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.control;

import cc.lechun.framework.common.utils.jqgridData.JqGridData;
import cc.lechun.framework.common.utils.serviceresult.Message;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.BaseUser;
import cc.lechun.framework.common.vo.JedisUtils;
import cc.lechun.pro.entity.MaterialProdEntity;
import cc.lechun.pro.entity.bo.MaterialProdForm;
import cc.lechun.pro.service.MaterialProdService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
public class MaterialProdControl {
    @Autowired
    private MaterialProdService materialProdService;

    @RequestMapping(value={"/materialprod/saveOrUpdate"})
    public Message saveOrUpdate(HttpServletRequest request, @RequestBody MaterialProdForm mpForm) {
        BaseUser user = null;
        try {
            user = JedisUtils.getBaseUser((HttpServletRequest)request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Message message = new Message(true, "\u4fdd\u5b58\u6210\u529f");
        List materialProds = this.getMaterialProds(mpForm, user);
        try {
            this.materialProdService.saveOrUpdateMaterialProd(materialProds);
        }
        catch (Exception e) {
            message = new Message(false, "\u4fdd\u5b58\u5931\u8d25");
            return message;
        }
        return message;
    }

    @RequestMapping(value={"/materialprod/findpage"})
    public Object findpage(Integer page, Integer rows, String search, String factoryid) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)search) && !search.equals("null")) {
                params.put("search", search);
            }
            if (StringUtils.isNotBlank((CharSequence)factoryid) && !factoryid.equals("null")) {
                params.put("factoryid", factoryid);
            }
            BaseJsonVo baseJsonVo = this.materialProdService.findPage(page, rows, params);
            List list = null;
            if (baseJsonVo.getStatus() == 200) {
                list = (List)baseJsonVo.getValue();
            }
            JqGridData gridData = new JqGridData(list);
            return gridData;
        }
        catch (Exception e) {
            Message message = new Message(false, "\u67e5\u8be2\u5931\u8d25");
            return message;
        }
    }

    private List<MaterialProdEntity> getMaterialProds(MaterialProdForm materialProdForm, BaseUser user) {
        Date date = new Date();
        ArrayList<MaterialProdEntity> list = new ArrayList<MaterialProdEntity>();
        if (null != materialProdForm.getAdd() && materialProdForm.getAdd().size() > 0) {
            for (MaterialProdEntity materialProd : materialProdForm.getAdd()) {
                if (user != null) {
                    materialProd.setModifier(user.getEmployeeName());
                }
                materialProd.setModifytime(date);
                list.add(materialProd);
            }
        }
        if (null != materialProdForm.getModify() && materialProdForm.getModify().size() > 0) {
            for (MaterialProdEntity materialProd : materialProdForm.getModify()) {
                materialProd.setModifytime(date);
                if (user != null) {
                    materialProd.setModifier(user.getEmployeeName());
                }
                list.add(materialProd);
            }
        }
        return list;
    }
}

