/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.control;

import cc.lechun.framework.common.utils.jqgridData.JqGridData;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.pro.dao.ProFactoryCalendarMapper;
import cc.lechun.pro.entity.ProFactoryCalendarEntity;
import cc.lechun.pro.entity.bo.FactoryCalendarForm;
import cc.lechun.pro.entity.vo.CreateProCalendarParametersV;
import cc.lechun.pro.service.ProFactoryCalendarService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
public class ProFactoryCalendarControl {
    @Autowired
    private ProFactoryCalendarService proFactoryCalendarService;
    @Autowired
    private ProFactoryCalendarMapper proFactoryCalendarMapper;

    @RequestMapping(value={"/ProFactoryCalendar/saveOrUpdate"})
    public BaseJsonVo upDateList(HttpServletRequest request, @RequestBody FactoryCalendarForm mpForm) {
        ArrayList deleteIds = new ArrayList();
        List proFactoryCalendars = this.getProFactoryCalendarEntitys(mpForm, deleteIds);
        return this.proFactoryCalendarService.saveOrUpDate(proFactoryCalendars, deleteIds);
    }

    @RequestMapping(value={"/ProFactoryCalendar/findPage"})
    public Object findPage(Integer page, Integer rows, String podMatClassId, String proDayS, String deptid, String proDayE) {
        JqGridData gridData = null;
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)podMatClassId)) {
                param.put("podMatClassId", podMatClassId);
            }
            if (StringUtils.isNotBlank((CharSequence)proDayS)) {
                param.put("proDayS", proDayS.replace("-", ""));
            }
            if (StringUtils.isNotBlank((CharSequence)proDayE)) {
                param.put("proDayE", proDayE.replace("-", ""));
            }
            if (StringUtils.isNotBlank((CharSequence)deptid)) {
                param.put("deptid", deptid);
            }
            baseJsonVo = this.proFactoryCalendarService.findPage(page, rows, param);
            List list = null;
            if (baseJsonVo.getStatus() == 200) {
                list = (List)baseJsonVo.getValue();
            }
            gridData = new JqGridData(list);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage(e.getMessage());
            return baseJsonVo;
        }
        return gridData;
    }

    @RequestMapping(value={"/ProFactoryCalendar/createProCalendar"})
    public BaseJsonVo createProCalendar(@RequestBody CreateProCalendarParametersV createProCalendarParametersV) {
        createProCalendarParametersV.toGetProFactoryCalendars();
        return this.proFactoryCalendarService.createProCalendar(createProCalendarParametersV.getList());
    }

    private List<ProFactoryCalendarEntity> getProFactoryCalendarEntitys(FactoryCalendarForm mpForm, List<String> deleteIds) {
        ArrayList<ProFactoryCalendarEntity> proFactoryCalendarEntitys = new ArrayList<ProFactoryCalendarEntity>();
        for (ProFactoryCalendarEntity proFactoryCalendar : mpForm.getAdd()) {
            proFactoryCalendar.setProDay(proFactoryCalendar.getProDay().replace("-", ""));
            proFactoryCalendarEntitys.add(proFactoryCalendar);
        }
        for (ProFactoryCalendarEntity proFactoryCalendar : mpForm.getModify()) {
            proFactoryCalendar.setProDay(proFactoryCalendar.getProDay().replace("-", ""));
            proFactoryCalendarEntitys.add(proFactoryCalendar);
        }
        for (String id : mpForm.getDel()) {
            if (!StringUtils.isNotBlank((CharSequence)id) || id.equals(false) && id.equals("false")) continue;
            deleteIds.add(id);
        }
        return proFactoryCalendarEntitys;
    }

    @RequestMapping(value={"/ProFactoryCalendar/deleteByIds"})
    public BaseJsonVo deleteById(@RequestBody List<String> ids) {
        return this.proFactoryCalendarService.deletes(ids);
    }
}

