/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.control;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.jqgridData.JqGridData;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.BaseUser;
import cc.lechun.framework.common.vo.JedisUtils;
import cc.lechun.pro.api.ProPredictMatService;
import cc.lechun.pro.api.ProPredictMatSumService;
import cc.lechun.pro.entity.ProPredictDetailEntity;
import cc.lechun.pro.entity.bo.ProPredictDetailForm;
import cc.lechun.pro.entity.vo.ProPredictSumV;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RefreshScope
public class ProPredictControl {
    @Autowired
    private ProPredictMatService proPredictMatService;
    @Autowired
    private ProPredictMatSumService proPredictMatSumService;

    @RequestMapping(value={"/predict/details"})
    public JqGridData<ProPredictDetailEntity> details(Integer page, Integer rows, String preordercode, String storeid, String matid, String matNameSearch, String bctid, String bctNameSearch, String startDate, String endDate, String pickupDate) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("preordercode", preordercode);
        param.put("storeid", storeid);
        param.put("matid", matid);
        param.put("bctid", bctid);
        param.put("matNameSearch", matNameSearch);
        param.put("bctNameSearch", bctNameSearch);
        if (StringUtils.isNotBlank((CharSequence)startDate)) {
            param.put("startDate", startDate.replace("-", ""));
        } else {
            param.put("startDate", DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)new Date(), (int)-10), (String)"yyyyMMdd"));
        }
        if (StringUtils.isNotBlank((CharSequence)endDate)) {
            param.put("endDate", endDate.replace("-", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)pickupDate)) {
            param.put("pickupDate", pickupDate.replace("-", ""));
        }
        BaseJsonVo baseJsonVo = this.proPredictMatService.details(page, rows, param);
        JqGridData jqGridData = new JqGridData();
        if (baseJsonVo.getStatus() == 200) {
            jqGridData.setRows((List)baseJsonVo.getValue());
        }
        return jqGridData;
    }

    @RequestMapping(value={"/predict/predictMatSum"})
    public BaseJsonVo predictMatSum() {
        return this.proPredictMatService.predictMatSum();
    }

    @RequestMapping(value={"/predict/sum"})
    public JqGridData<ProPredictSumV> sum(Integer page, Integer rows, String storeid, String matid, String matNameSearch, String ipurchasename, Integer freshness, String startDate, String endDate, String planningtypename) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("storeid", storeid);
        param.put("matid", matid);
        param.put("matNameSearch", matNameSearch);
        param.put("freshness", freshness);
        if (StringUtils.isNotBlank((CharSequence)startDate)) {
            param.put("startDate", startDate.replace("-", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)endDate)) {
            param.put("endDate", endDate.replace("-", ""));
        }
        param.put("ipurchasename", ipurchasename);
        param.put("planningtypename", planningtypename);
        BaseJsonVo baseJsonVo = this.proPredictMatSumService.findList(page, rows, param);
        JqGridData jqGridData = new JqGridData();
        if (baseJsonVo.getStatus() == 200) {
            jqGridData.setRows((List)baseJsonVo.getValue());
        }
        return jqGridData;
    }

    @RequestMapping(value={"/predict/sumDetails"})
    public JqGridData<ProPredictDetailEntity> sumDetails(Integer page, Integer rows, String preordercode, String storeid, String matid, String bctid, String pickupDate, String sumdatetime, Integer freshness) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("preordercode", preordercode);
        param.put("storeid", storeid);
        param.put("matid", matid);
        param.put("bctid", bctid);
        if (StringUtils.isNotBlank((CharSequence)pickupDate)) {
            param.put("pickupDate", pickupDate.replace("-", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)sumdatetime)) {
            param.put("sumdatetime", sumdatetime.replace("-", ""));
        }
        if (freshness != null) {
            param.put("freshness", freshness);
        }
        BaseJsonVo baseJsonVo = this.proPredictMatService.sumDetails(page, rows, param);
        JqGridData jqGridData = new JqGridData();
        if (baseJsonVo.getStatus() == 200) {
            jqGridData.setRows((List)baseJsonVo.getValue());
        }
        return jqGridData;
    }

    @RequestMapping(value={"/predict/saveOrUpdate"})
    public BaseJsonVo saveOrUpdate(HttpServletRequest request, @RequestBody ProPredictDetailForm mpForm) {
        BaseUser user = null;
        try {
            user = JedisUtils.getBaseUser((HttpServletRequest)request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List proPredictDetails = this.getProPredictDetailEntitys(mpForm, user);
        return this.proPredictMatService.saveOrUpdateDatas(proPredictDetails, user);
    }

    private List<ProPredictDetailEntity> getProPredictDetailEntitys(ProPredictDetailForm mpForm, BaseUser user) {
        ArrayList<ProPredictDetailEntity> proPredictDetails = new ArrayList<ProPredictDetailEntity>();
        for (ProPredictDetailEntity proPredictDetail : mpForm.getAdd()) {
            proPredictDetail.setModifier(user.getEmployeeName());
            proPredictDetails.add(proPredictDetail);
        }
        for (ProPredictDetailEntity proPredictDetail : mpForm.getModify()) {
            proPredictDetail.setModifier(user.getEmployeeName());
            proPredictDetails.add(proPredictDetail);
        }
        return proPredictDetails;
    }
}

