/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.dao.impl;

import cc.lechun.bd.entity.vo.EdbMaterialRelationEntityV;
import cc.lechun.bd.entity.vo.EdbWarehouseRelationEntityV;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.pro.apiinvoke.EdbClient;
import cc.lechun.pro.apiinvoke.EdbMaterialRelationClient;
import cc.lechun.pro.apiinvoke.EdbWarehouseRelationClient;
import cc.lechun.pro.apiinvoke.getdata.pro.edbstoredatas.Edbstoredatas;
import cc.lechun.pro.dao.FormEdianBaoGetStoreMateralMapper;
import cc.lechun.pro.entity.FormEdianBaoGetStoreMateral;
import cc.lechun.pro.entity.vo.ProStoreMaterialV;
import cc.lechun.pro.util.BatchAddOrUpdate;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetEdbDatasDao {
    @Autowired
    private EdbClient edbClient;
    @Autowired
    private EdbMaterialRelationClient edbMaterialRelationClient;
    @Autowired
    private EdbWarehouseRelationClient edbWarehouseRelationClient;
    @Autowired
    private FormEdianBaoGetStoreMateralMapper formEdianBaoGetStoreMateralMapper;
    private Logger log = LoggerFactory.getLogger(GetEdbDatasDao.class);

    public List<FormEdianBaoGetStoreMateral> getEDBstoreDatas() {
        List formEdianBaoGetStoreMaterals = null;
        try {
            String jsonstr = null;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("format", "json");
            long time5 = System.currentTimeMillis();
            jsonstr = this.edbClient.edbRequstPost("edbProductGet_LC", map);
            long time7 = System.currentTimeMillis();
            Edbstoredatas Edbstoredatas2 = (Edbstoredatas)JSONObject.parseObject((String)jsonstr, Edbstoredatas.class);
            formEdianBaoGetStoreMaterals = Edbstoredatas2.getSuccess().getItems().getItem();
            long time8 = System.currentTimeMillis();
            this.log.info("==========\u83b7\u53d6edb\u539f\u59cb\u6570\u636e==\u300b" + (time7 - time5) + "\u6beb\u79d2  \u8f6c\u6362\u4e3a\u672c\u5730\u5b58\u50a8\u6240\u9700\u6570\u636e(" + (formEdianBaoGetStoreMaterals != null ? formEdianBaoGetStoreMaterals.size() : 0) + ")  " + (time8 - time7) + "\u6beb\u79d2");
        }
        catch (Exception e) {
            this.log.error("\u83b7\u53d6Edb \u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        return formEdianBaoGetStoreMaterals;
    }

    public List<EdbWarehouseRelationEntityV> getWarehouseRelations() {
        long time7 = System.currentTimeMillis();
        List list = null;
        try {
            BaseJsonVo basejson = this.edbWarehouseRelationClient.findAll();
            if (basejson.getStatus() == 200 && basejson.getValue() != null) {
                list = (List)basejson.getValue();
            }
        }
        catch (Exception e) {
            this.log.error("\u83b7\u53d6\u4ed3\u5e93\u6620\u5c04\u5173\u7cfb\u5f02\u5e38", (Throwable)e);
        }
        long time8 = System.currentTimeMillis();
        this.log.info("==========\u83b7\u53d6\u4ed3\u5e93\u6620\u5c04\u6570\u636e==\u300b" + (time8 - time7) + "\u6beb\u79d2");
        return list;
    }

    public List<EdbMaterialRelationEntityV> getMaterialRelations() {
        long time7 = System.currentTimeMillis();
        List list = null;
        try {
            BaseJsonVo basejson = this.edbMaterialRelationClient.findAll();
            if (basejson.getStatus() == 200 && basejson.getValue() != null) {
                list = (List)basejson.getValue();
            }
        }
        catch (Exception e) {
            this.log.error("\u83b7\u53d6\u7269\u54c1\u6620\u5c04\u5173\u7cfb\u5f02\u5e38", (Throwable)e);
        }
        long time8 = System.currentTimeMillis();
        this.log.info("==========\u83b7\u53d6\u7269\u54c1\u6620\u5c04\u6570\u636e==\u300b" + (time8 - time7) + "\u6beb\u79d2");
        return list;
    }

    public void deleteEdbDatasAll() {
        long time7 = System.currentTimeMillis();
        this.formEdianBaoGetStoreMateralMapper.deleteAll();
        long time8 = System.currentTimeMillis();
        this.log.info("==========\u5220\u9664\u6613\u5e97\u5b9d\u6240\u6709\u6570\u636e==\u300b" + (time8 - time7) + "\u6beb\u79d2");
    }

    public List<FormEdianBaoGetStoreMateral> gropSumEdbDatas() {
        long time7 = System.currentTimeMillis();
        List list = this.formEdianBaoGetStoreMateralMapper.findGropSum();
        long time8 = System.currentTimeMillis();
        this.log.info("==========\u5206\u7ec4\u6c42\u548c\u6240\u6709\u6613\u5e97\u5b9d\u6570\u636e==\u300b" + (time8 - time7) + "\u6beb\u79d2");
        return list;
    }

    public List<FormEdianBaoGetStoreMateral> gropSumEdbDatas(List<FormEdianBaoGetStoreMateral> edBstoreDatas) {
        long time7 = System.currentTimeMillis();
        HashMap<String, FormEdianBaoGetStoreMateral> map = new HashMap<String, FormEdianBaoGetStoreMateral>();
        ArrayList<FormEdianBaoGetStoreMateral> list = new ArrayList<FormEdianBaoGetStoreMateral>();
        if (edBstoreDatas != null && edBstoreDatas.size() > 0) {
            for (FormEdianBaoGetStoreMateral formEdianBaoGetStoreMateral : edBstoreDatas) {
                if (map.containsKey(formEdianBaoGetStoreMateral.tonOly())) {
                    int Entity_stock = StringUtils.isNotBlank((CharSequence)((FormEdianBaoGetStoreMateral)map.get(formEdianBaoGetStoreMateral.tonOly())).getEntity_stock()) ? Integer.valueOf(((FormEdianBaoGetStoreMateral)map.get(formEdianBaoGetStoreMateral.tonOly())).getEntity_stock()) : 0;
                    ((FormEdianBaoGetStoreMateral)map.get(formEdianBaoGetStoreMateral.tonOly())).setEntity_stock((Entity_stock += StringUtils.isNotBlank((CharSequence)formEdianBaoGetStoreMateral.getEntity_stock()) ? Integer.valueOf(formEdianBaoGetStoreMateral.getEntity_stock()) : 0) + "");
                    int Sell_stock = StringUtils.isNotBlank((CharSequence)((FormEdianBaoGetStoreMateral)map.get(formEdianBaoGetStoreMateral.tonOly())).getSell_stock()) ? Integer.valueOf(((FormEdianBaoGetStoreMateral)map.get(formEdianBaoGetStoreMateral.tonOly())).getSell_stock()) : 0;
                    ((FormEdianBaoGetStoreMateral)map.get(formEdianBaoGetStoreMateral.tonOly())).setSell_stock((Sell_stock += StringUtils.isNotBlank((CharSequence)formEdianBaoGetStoreMateral.getSell_stock()) ? Integer.valueOf(formEdianBaoGetStoreMateral.getSell_stock()) : 0) + "");
                    int Standbook_stock = StringUtils.isNotBlank((CharSequence)((FormEdianBaoGetStoreMateral)map.get(formEdianBaoGetStoreMateral.tonOly())).getStandbook_stock()) ? Integer.valueOf(((FormEdianBaoGetStoreMateral)map.get(formEdianBaoGetStoreMateral.tonOly())).getStandbook_stock()) : 0;
                    ((FormEdianBaoGetStoreMateral)map.get(formEdianBaoGetStoreMateral.tonOly())).setStandbook_stock((Standbook_stock += StringUtils.isNotBlank((CharSequence)formEdianBaoGetStoreMateral.getStandbook_stock()) ? Integer.valueOf(formEdianBaoGetStoreMateral.getStandbook_stock()) : 0) + "");
                    int Transport_stock = StringUtils.isNotBlank((CharSequence)((FormEdianBaoGetStoreMateral)map.get(formEdianBaoGetStoreMateral.tonOly())).getTransport_stock()) ? Integer.valueOf(((FormEdianBaoGetStoreMateral)map.get(formEdianBaoGetStoreMateral.tonOly())).getTransport_stock()) : 0;
                    ((FormEdianBaoGetStoreMateral)map.get(formEdianBaoGetStoreMateral.tonOly())).setTransport_stock((Transport_stock += StringUtils.isNotBlank((CharSequence)formEdianBaoGetStoreMateral.getTransport_stock()) ? Integer.valueOf(formEdianBaoGetStoreMateral.getTransport_stock()) : 0) + "");
                    int Transfer_stock = StringUtils.isNotBlank((CharSequence)((FormEdianBaoGetStoreMateral)map.get(formEdianBaoGetStoreMateral.tonOly())).getTransfer_stock()) ? Integer.valueOf(((FormEdianBaoGetStoreMateral)map.get(formEdianBaoGetStoreMateral.tonOly())).getTransfer_stock()) : 0;
                    ((FormEdianBaoGetStoreMateral)map.get(formEdianBaoGetStoreMateral.tonOly())).setTransfer_stock((Transfer_stock += StringUtils.isNotBlank((CharSequence)formEdianBaoGetStoreMateral.getTransfer_stock()) ? Integer.valueOf(formEdianBaoGetStoreMateral.getTransfer_stock()) : 0) + "");
                    int Use_num = StringUtils.isNotBlank((CharSequence)((FormEdianBaoGetStoreMateral)map.get(formEdianBaoGetStoreMateral.tonOly())).getUse_num()) ? Integer.valueOf(((FormEdianBaoGetStoreMateral)map.get(formEdianBaoGetStoreMateral.tonOly())).getUse_num()) : 0;
                    ((FormEdianBaoGetStoreMateral)map.get(formEdianBaoGetStoreMateral.tonOly())).setUse_num((Use_num += StringUtils.isNotBlank((CharSequence)formEdianBaoGetStoreMateral.getUse_num()) ? Integer.valueOf(formEdianBaoGetStoreMateral.getUse_num()) : 0) + "");
                    continue;
                }
                map.put(formEdianBaoGetStoreMateral.tonOly(), formEdianBaoGetStoreMateral);
            }
            for (Map.Entry entry : map.entrySet()) {
                list.add((FormEdianBaoGetStoreMateral)entry.getValue());
            }
        }
        long time8 = System.currentTimeMillis();
        this.log.info("==========\u5206\u7ec4\u6c42\u548c\u6240\u6709\u6613\u5e97\u5b9d\u6570\u636e==\u300b" + (time8 - time7) + "\u6beb\u79d2");
        return list;
    }

    public void addRecordsBatch(List<FormEdianBaoGetStoreMateral> formEdianBaoGetStoreMaterals) throws Exception {
        this.formEdianBaoGetStoreMateralMapper.deleteAll();
        long time7 = System.currentTimeMillis();
        ArrayList<FormEdianBaoGetStoreMateral> listnew = new ArrayList<FormEdianBaoGetStoreMateral>();
        if (formEdianBaoGetStoreMaterals != null && formEdianBaoGetStoreMaterals.size() > 0) {
            Date date = new Date();
            for (FormEdianBaoGetStoreMateral formEdianBaoGetStoreMateral : formEdianBaoGetStoreMaterals) {
                if (formEdianBaoGetStoreMateral == null || !StringUtils.isNotBlank((CharSequence)formEdianBaoGetStoreMateral.getWarehouse_id())) continue;
                formEdianBaoGetStoreMateral.setId(IDGenerate.getUniqueIdStr());
                formEdianBaoGetStoreMateral.setUpdateTime(date);
                listnew.add(formEdianBaoGetStoreMateral);
            }
            new BatchAddOrUpdate(37).batch(listnew, (BatchAddOrUpdate.ToRunMethod)new /* Unavailable Anonymous Inner Class!! */);
            long time8 = System.currentTimeMillis();
            this.log.info("=========\u6613\u5e97\u5b9d\u539f\u59cb\u6570\u636e\uff08" + formEdianBaoGetStoreMaterals.size() + "\uff09\u63d2\u5165\u6570\u636e\u5e93==\u300b" + (time8 - time7) + "\u6beb\u79d2");
        }
    }

    public List<ProStoreMaterialV> edbToloclDatas(List<FormEdianBaoGetStoreMateral> formEdianBaoGetStoreMaterals, List<EdbWarehouseRelationEntityV> edbWarehouseRelatios, List<EdbMaterialRelationEntityV> edbMaterialRelations) {
        if (formEdianBaoGetStoreMaterals != null && formEdianBaoGetStoreMaterals.size() > 0) {
            long time7 = System.currentTimeMillis();
            ArrayList<ProStoreMaterialV> proStoreMaterials = new ArrayList<ProStoreMaterialV>();
            for (FormEdianBaoGetStoreMateral pebgsm : formEdianBaoGetStoreMaterals) {
                ProStoreMaterialV psm;
                block11: {
                    psm = null;
                    if (pebgsm == null) {
                        this.log.info("\u83b7\u53d6\u4ed3\u5e93\u4fe1\u606f\u4e3a\u7a7a pebgsm" + pebgsm.getBar_code());
                        continue;
                    }
                    try {
                        block10: {
                            try {
                                psm = pebgsm.myToProStoreMaterialEntity(pebgsm);
                                if (psm == null) {
                                    this.log.info("\u83b7\u53d6\u4ed3\u5e93\u4fe1\u606f\u4e3a\u7a7a " + pebgsm.getBar_code());
                                }
                                break block10;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                this.log.info("\u8f6c\u6362\u4ed3\u5e93\u4fe1\u606f\u5f02\u5e38  pebgsm.myToProStoreMaterialEntity" + e.getMessage());
                            }
                            continue;
                        }
                        EdbMaterialRelationEntityV edbMaterialRelation = this.getMaterialRelationByEdbCode(pebgsm, edbMaterialRelations);
                        if (edbMaterialRelation == null) {
                            this.log.info("\u7269\u54c1\u6c92\u6709\u5339\u914d\u4e0a code " + pebgsm.getBar_code());
                            continue;
                        }
                        psm.setMatid(edbMaterialRelation.getCmatid());
                        psm.setMatcode(edbMaterialRelation.getCmatcode());
                        psm.setMatname(edbMaterialRelation.getCmatname());
                        EdbWarehouseRelationEntityV warehouseRelation = this.getWarehouseRelationByEdbCode(pebgsm, edbWarehouseRelatios);
                        if (warehouseRelation != null) {
                            psm.setStoreid(warehouseRelation.getCwarehouseid());
                            psm.setStorecode(warehouseRelation.getCwarehousecode());
                            psm.setStorename(warehouseRelation.getCwarehousename());
                            break block11;
                        }
                        this.log.info("\u4ed3\u5e93\u6c92\u6709\u5339\u914d\u4e0a code " + pebgsm.getWarehouse_id());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.log.info("======\u83b7\u53d6\u6613\u5e97\u5b9d\u6570\u636e\u7ec4\u5408\u6210erp\u5e93\u5b58\u6240\u9700\u6570\u636e \u5f02\u5e38 " + e.getMessage());
                    }
                    continue;
                }
                proStoreMaterials.add(psm);
            }
            long time8 = System.currentTimeMillis();
            this.log.info("=========\u6613\u5e97\u5b9d\u6570\u636e\u6784\u5efa\u4f4derp \u5e93\u5b58\u6570\u636e\uff08" + formEdianBaoGetStoreMaterals.size() + "\uff09\u8017\u65f6==\u300b" + (time8 - time7) + "\u6beb\u79d2");
            return proStoreMaterials;
        }
        return null;
    }

    private EdbWarehouseRelationEntityV getWarehouseRelationByEdbCode(FormEdianBaoGetStoreMateral pebgsm, List<EdbWarehouseRelationEntityV> list) {
        EdbWarehouseRelationEntityV relation = null;
        if (list != null && list.size() > 0) {
            for (EdbWarehouseRelationEntityV relationV : list) {
                if (null == relationV.getEdbwarehousecode()) {
                    this.log.info("\u4ed3\u5e93\u83b7\u53d6 \u5f02\u5e38 \u5b58\u5728\u7a7a\u6307\u9488 getEdbwarehousecode()" + JSONObject.toJSONString((Object)relationV));
                    continue;
                }
                if (null == pebgsm.getWarehouse_id()) {
                    this.log.info("\u4ed3\u5e93\u83b7\u53d6 \u5f02\u5e38 \u5b58\u5728\u7a7a\u6307\u9488(pebgsm.getWarehouse_id()) " + JSONObject.toJSONString((Object)pebgsm));
                    continue;
                }
                if (null == relationV.getType()) {
                    this.log.info("\u4ed3\u5e93\u83b7\u53d6 \u5f02\u5e38 \u5b58\u5728\u7a7a\u6307\u9488  relationV.getType()  " + JSONObject.toJSONString((Object)relationV));
                    continue;
                }
                if (!relationV.getEdbwarehousecode().equals(pebgsm.getWarehouse_id()) || relationV.getType() != 1 && !(relationV.getType() + "").equals("1")) continue;
                relation = relationV;
                break;
            }
        }
        return relation;
    }

    private EdbMaterialRelationEntityV getMaterialRelationByEdbCode(FormEdianBaoGetStoreMateral pebgsm, List<EdbMaterialRelationEntityV> list) {
        EdbMaterialRelationEntityV relation = null;
        if (list != null && list.size() > 0) {
            for (EdbMaterialRelationEntityV relationV : list) {
                if (null == relationV.getEdbmatcode()) {
                    this.log.info("\u7269\u54c1\u83b7\u53d6 \u5f02\u5e38 \u5b58\u5728\u7a7a\u6307\u9488 (relationV.getEdbmatcode())" + JSONObject.toJSONString((Object)relationV));
                    continue;
                }
                if (null == pebgsm.getBar_code()) {
                    this.log.info("\u7269\u54c1\u83b7\u53d6 \u5f02\u5e38 \u5b58\u5728\u7a7a\u6307\u9488(pebgsm.getBar_code()) " + JSONObject.toJSONString((Object)pebgsm));
                    continue;
                }
                if (!relationV.getEdbmatcode().equals(pebgsm.getBar_code())) continue;
                relation = relationV;
                break;
            }
        }
        return relation;
    }

    static /* synthetic */ FormEdianBaoGetStoreMateralMapper access$000(GetEdbDatasDao x0) {
        return x0.formEdianBaoGetStoreMateralMapper;
    }
}

