/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.dao.impl;

import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.pro.dao.ProFactoryAllotCalendarMapper;
import cc.lechun.pro.entity.ProFactoryAllotCalendarEntity;
import cc.lechun.pro.entity.vo.ProFactoryAllotCalendarV;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProFactoryAllotCalendarDao {
    private Logger log = LoggerFactory.getLogger(ProFactoryAllotCalendarDao.class);
    @Autowired
    private ProFactoryAllotCalendarMapper proFactoryAllotCalendarMapper;

    public void saveProFactoryAllotCalendar(List<ProFactoryAllotCalendarEntity> list) throws Exception {
        Date today = new Date();
        HashMap<String, Date> param = new HashMap<String, Date>();
        param.put("today", today);
        this.proFactoryAllotCalendarMapper.deleteAllotCalendar(param);
        if (null != list && list.size() > 0) {
            for (ProFactoryAllotCalendarEntity proFactoryAllotCalendarEntity : list) {
                proFactoryAllotCalendarEntity.setId(IDGenerate.getUniqueIdStr());
                proFactoryAllotCalendarEntity.setCreatetime(today);
                this.proFactoryAllotCalendarMapper.insert((Object)proFactoryAllotCalendarEntity);
            }
        }
    }

    public List<ProFactoryAllotCalendarV> findList(Map<String, Object> param) throws Exception {
        return this.proFactoryAllotCalendarMapper.findAllotCalendar(param);
    }

    public List<ProFactoryAllotCalendarV> findListByleadTime() throws Exception {
        HashMap<String, Date> param = new HashMap<String, Date>();
        param.put("todayInLeadTime", new Date());
        return this.proFactoryAllotCalendarMapper.findAllotCalendar(param);
    }

    public ProFactoryAllotCalendarV findProFactoryAllotCalendarVByBalancEinventory(String storeid, String proclassid) {
        ProFactoryAllotCalendarV proFactoryAllotCalendarV = null;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("storeinid", storeid);
        param.put("proclassid", proclassid);
        param.put("today", new Date());
        List list = this.proFactoryAllotCalendarMapper.findProFactoryAllotCalendarVByBalancEinventory(param);
        if (list.size() > 0) {
            proFactoryAllotCalendarV = (ProFactoryAllotCalendarV)list.get(0);
        }
        return proFactoryAllotCalendarV;
    }

    public ProFactoryAllotCalendarV findProFactoryAllotCalendarVByeqtoday(String storeid, String proclassid) {
        ProFactoryAllotCalendarV proFactoryAllotCalendarV = null;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("storeinid", storeid);
        param.put("proclassid", proclassid);
        param.put("eqtoday", new Date());
        List list = this.proFactoryAllotCalendarMapper.findProFactoryAllotCalendarVByBalancEinventory(param);
        if (list.size() > 0) {
            proFactoryAllotCalendarV = (ProFactoryAllotCalendarV)list.get(0);
        }
        return proFactoryAllotCalendarV;
    }

    public ProFactoryAllotCalendarV findMaxProFactoryAllotCalendarVByEqToday(String storeid, String proclassid) {
        ProFactoryAllotCalendarV proFactoryAllotCalendarV = null;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("storeinid", storeid);
        param.put("proclassid", proclassid);
        param.put("today", new Date());
        List list = this.proFactoryAllotCalendarMapper.findProFactoryAllotCalendarVByBalancEinventory(param);
        if (list.size() > 0) {
            proFactoryAllotCalendarV = (ProFactoryAllotCalendarV)list.get(0);
        }
        return proFactoryAllotCalendarV;
    }

    public ProFactoryAllotCalendarV findMaxProFactoryAllotCalendarVByBlanceEqToday(String storeoutid, String proclassid) {
        ProFactoryAllotCalendarV proFactoryAllotCalendarV = null;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("storeoutid", storeoutid);
        param.put("proclassid", proclassid);
        param.put("startToday", new Date());
        List list = this.proFactoryAllotCalendarMapper.findProFactoryAllotCalendarVByBalancEinventory(param);
        if (list.size() > 0) {
            proFactoryAllotCalendarV = (ProFactoryAllotCalendarV)list.get(0);
        }
        return proFactoryAllotCalendarV;
    }
}

