/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.domain;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.pro.apiinvoke.WmsServiceClient;
import cc.lechun.pro.dao.ProBalancEinventoryRelationMapper;
import cc.lechun.pro.dao.ProStoreMaterialMapper;
import cc.lechun.pro.dao.impl.FreshnessStatisticsNewVDao;
import cc.lechun.pro.dao.impl.ProFactoryAllotCalendarDao;
import cc.lechun.pro.dao.impl.ProFactoryCalendarBuilDao;
import cc.lechun.pro.dao.impl.ProMaterialPlanHistoryOccupyDao;
import cc.lechun.pro.dao.impl.ProPredictDetailDao;
import cc.lechun.pro.entity.ProMaterialPlanHistoryOccupyEntity;
import cc.lechun.pro.entity.ProStoreMaterialEntity;
import cc.lechun.pro.entity.vo.EinventoryRelationV;
import cc.lechun.pro.entity.vo.FreshnessStatisticsNewV;
import cc.lechun.pro.entity.vo.ProFactoryAllotCalendarV;
import cc.lechun.pro.entity.vo.ProFactoryCalendarBuildV;
import cc.lechun.pro.entity.vo.ProPredictDetailV;
import cc.lechun.pro.entity.vo.ProStoreMaterialV;
import cc.lechun.wms.entity.vo.IcAllotDetailPro;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FreshnessStatisticsNewVService {
    private Logger log = LoggerFactory.getLogger(FreshnessStatisticsNewVService.class);
    @Autowired
    private FreshnessStatisticsNewVDao freshnessStatisticsNewVDao;
    @Autowired
    private ProStoreMaterialMapper proStoreMaterialMapper;
    @Autowired
    private ProBalancEinventoryRelationMapper proBalancEinventoryRelationMapper;
    @Autowired
    private WmsServiceClient wmsServiceClient;
    @Autowired
    private ProFactoryCalendarBuilDao proFactoryCalendarBuilDao;
    @Autowired
    private ProPredictDetailDao proPredictDetailDao;
    @Autowired
    private ProMaterialPlanHistoryOccupyDao proMaterialPlanHistoryOccupyDao;
    @Autowired
    private ProFactoryAllotCalendarDao proFactoryAllotCalendarDao;

    public BaseJsonVo<List<FreshnessStatisticsNewV>> freshnessStatisticsNewVs(Integer page, Integer rows, Map<String, Object> param) {
        BaseJsonVo bseJsonVo = new BaseJsonVo();
        bseJsonVo.setStatus(200);
        try {
            long startTime = System.currentTimeMillis();
            Date today = new Date();
            List freshnessStatistics = this.freshnessStatisticsNewVDao.getFreshnessStatisticsByProStoreMaterial(page, rows, param);
            List proStoreMaterias = this.proStoreMaterialMapper.findList(param);
            List balancEinventoryRelations = this.proBalancEinventoryRelationMapper.findRelationData(param);
            HashMap mapB_ = new HashMap();
            HashMap mapBAdd = new HashMap();
            HashMap mapMaxDay = new HashMap();
            HashMap mapbuld = new HashMap();
            List proPredictDetails = this.proPredictDetailDao.findPredictDetailsBeforTodayByAllot();
            List proMaterialPlanHistoryOccupys = this.proMaterialPlanHistoryOccupyDao.findTosupportAmount(DateUtils.formatDate((Date)today, (String)"yyyyMMdd"));
            BaseJsonVo baseJsonVo = this.wmsServiceClient.getProAllotDatasByFreshess();
            List icAllotDetailPros = null;
            if (baseJsonVo.getValue() != null && ((List)baseJsonVo.getValue()).size() > 0) {
                icAllotDetailPros = (List)baseJsonVo.getValue();
            }
            long endTime = System.currentTimeMillis();
            this.log.info("\u83b7\u53d6\u5e73\u8861\u6570\u636e\u6240\u9700\u8017\u65f6 : " + (endTime - startTime));
            if (freshnessStatistics.size() > 0) {
                for (FreshnessStatisticsNewV freshnessStatisticsNewV : freshnessStatistics) {
                    this.buildFreshnessStatisticsDatas(freshnessStatisticsNewV, proStoreMaterias, balancEinventoryRelations, today, mapB_, proPredictDetails, mapbuld, proMaterialPlanHistoryOccupys, icAllotDetailPros, mapMaxDay, mapBAdd);
                }
            }
            this.log.info("\u7ec4\u7ec7\u5e73\u8861\u6570\u636e\u6240\u9700\u8017\u65f6 : " + (System.currentTimeMillis() - endTime));
            bseJsonVo.setValue((Object)freshnessStatistics);
        }
        catch (Exception e) {
            this.log.error("\u5f02\u5e38", (Throwable)e);
            bseJsonVo.setStatus(500);
            bseJsonVo.setMessage(e.getMessage());
        }
        return bseJsonVo;
    }

    public void buildFreshnessStatisticsDatas(FreshnessStatisticsNewV freshnessStatisticsNewV, List<ProStoreMaterialV> proStoreMaterias, List<EinventoryRelationV> balancEinventoryRelations, Date today, Map<String, ProFactoryAllotCalendarV> mapB_, List<ProPredictDetailV> proPredictDetails, Map<String, ProFactoryCalendarBuildV> mapbuld, List<ProMaterialPlanHistoryOccupyEntity> proMaterialPlanHistoryOccupys, List<IcAllotDetailPro> IcAllotDetailPros, Map<String, ProFactoryAllotCalendarV> mapMaxDay, Map<String, ProFactoryAllotCalendarV> mapBAdd) throws Exception {
        freshnessStatisticsNewV.setSiltcargoNum(this.countSiltcargoNum(freshnessStatisticsNewV, proStoreMaterias, today));
        freshnessStatisticsNewV.setOccupyPredictNum(this.countOccupyPredictNum(freshnessStatisticsNewV, balancEinventoryRelations, today, mapB_));
        freshnessStatisticsNewV.setSellPredictNum(this.countSellPredictNum(freshnessStatisticsNewV, today, mapB_, proPredictDetails));
        freshnessStatisticsNewV.setOccupyreleasenum(this.countOccupyreleasenum(freshnessStatisticsNewV, today, balancEinventoryRelations, mapbuld, mapBAdd));
        freshnessStatisticsNewV.setAllocationInTransitNum(this.countAllocationInTransitNum(freshnessStatisticsNewV, IcAllotDetailPros, today));
        freshnessStatisticsNewV.setInTransitPredictNum(this.countInTransitPredictNum(freshnessStatisticsNewV, today, mapMaxDay, proPredictDetails));
        freshnessStatisticsNewV.setPlanNum(this.countPlanNum(freshnessStatisticsNewV, proMaterialPlanHistoryOccupys, today));
        freshnessStatisticsNewV.setPlanAddNum(this.countPlanAddNum(freshnessStatisticsNewV, proMaterialPlanHistoryOccupys, today));
        freshnessStatisticsNewV.setTotal(this.countTotal(freshnessStatisticsNewV));
    }

    private Integer countSiltcargoNum(FreshnessStatisticsNewV freshness, List<ProStoreMaterialV> proStoreMaterias, Date today) {
        int sum = 0;
        if (proStoreMaterias == null) {
            return sum;
        }
        long satrtTime = Long.valueOf(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)today, (int)(-freshness.getFreshness().intValue())), (String)"yyyyMMdd"));
        long endTime = Long.valueOf(DateUtils.formatDate((Date)today, (String)"yyyyMMdd"));
        for (ProStoreMaterialEntity proStoreMaterialEntity : proStoreMaterias) {
            long dateTime;
            if (proStoreMaterialEntity.getDatatpye() != 2 || !this.sumIf(satrtTime, endTime, dateTime = Long.valueOf(DateUtils.formatDate((Date)proStoreMaterialEntity.getProdtime(), (String)"yyyyMMdd")).longValue(), freshness.getMatId(), proStoreMaterialEntity.getMatid(), freshness.getStoreId(), proStoreMaterialEntity.getStoreid())) continue;
            sum += proStoreMaterialEntity.getSiltcargonum().intValue();
        }
        return sum;
    }

    private boolean sumIf(long satrtTime, long endTime, long dateTime, String oldMatid, String newMatid, String oldtoreId, String newStoreId) {
        if (this.sumIfSatrtTime(satrtTime, dateTime) && this.sumIfSatrtTime(dateTime, endTime)) {
            return this.sumIfMatidStoreId(oldMatid, newMatid, oldtoreId, newStoreId);
        }
        return false;
    }

    private boolean sumIfSatrtTime(long satrtTime, long dateTime) {
        return satrtTime <= dateTime;
    }

    private boolean sumIfMatidStoreId(String oldMatid, String newMatid, String oldtoreId, String newStoreId) {
        return oldMatid.equals(newMatid) && oldtoreId.equals(newStoreId);
    }

    private Date todayIfAllocationDate(FreshnessStatisticsNewV freshness, Date today, Map<String, ProFactoryAllotCalendarV> map) {
        String key = DateUtils.formatDate((Date)today, (String)"yyyyMMdd") + freshness.getProdMatClassId() + freshness.getStoreId();
        ProFactoryAllotCalendarV proFactoryAllot = null;
        if (map.keySet().contains(key)) {
            proFactoryAllot = map.get(key);
        } else {
            proFactoryAllot = this.proFactoryAllotCalendarDao.findProFactoryAllotCalendarVByeqtoday(freshness.getStoreId(), freshness.getProdMatClassId());
            map.put(key, proFactoryAllot);
        }
        if (proFactoryAllot != null) {
            return DateUtils.getAddDateByDay((Date)today, (int)1);
        }
        return today;
    }

    private Date todayBAddIfAllocationDate(FreshnessStatisticsNewV freshness, Date today, Map<String, ProFactoryAllotCalendarV> mapBadd) {
        String key = DateUtils.formatDate((Date)today, (String)"yyyyMMdd") + freshness.getProdMatClassId() + freshness.getStoreId();
        ProFactoryAllotCalendarV proFactoryAllot = null;
        if (mapBadd.keySet().contains(key)) {
            proFactoryAllot = mapBadd.get(key);
        } else {
            proFactoryAllot = this.proFactoryAllotCalendarDao.findProFactoryAllotCalendarVByeqtoday(freshness.getStoreId(), freshness.getProdMatClassId());
            mapBadd.put(key, proFactoryAllot);
        }
        if (proFactoryAllot != null) {
            return DateUtils.getAddDateByDay((Date)today, (int)2);
        }
        return DateUtils.getAddDateByDay((Date)today, (int)1);
    }

    private Date getProFactoryCalendarBuilEnDate(FreshnessStatisticsNewV freshness, Date today, Map<String, ProFactoryCalendarBuildV> mapbuld) throws Exception {
        String key = today + freshness.getProdMatClassId() + freshness.getStoreId();
        ProFactoryCalendarBuildV proFactoryCalendarBuilsNew = null;
        if (mapbuld.keySet().contains(key)) {
            proFactoryCalendarBuilsNew = mapbuld.get(key);
        } else {
            proFactoryCalendarBuilsNew = this.proFactoryCalendarBuilDao.findMaxProFactoryCalendarBuilsByToday(DateUtils.formatDate((Date)today, (String)"yyyyMMdd"), freshness.getProdMatClassId(), freshness.getStoreId());
            mapbuld.put(key, proFactoryCalendarBuilsNew);
        }
        if (proFactoryCalendarBuilsNew != null) {
            return DateUtils.getAddDateByDay((Date)DateUtils.StrToDate((String)proFactoryCalendarBuilsNew.getEnddate(), (String)"yyyyMMdd"), (int)1);
        }
        return null;
    }

    private ProFactoryAllotCalendarV getTodayProFactoryAllot(FreshnessStatisticsNewV freshness, Date today, Map<String, ProFactoryAllotCalendarV> mapMaxDay) {
        String key = DateUtils.formatDate((Date)today, (String)"yyyyMMdd") + freshness.getProdMatClassId() + freshness.getStoreId();
        ProFactoryAllotCalendarV proFactoryAllot = null;
        if (mapMaxDay.keySet().contains(key)) {
            proFactoryAllot = mapMaxDay.get(key);
        } else {
            proFactoryAllot = this.proFactoryAllotCalendarDao.findMaxProFactoryAllotCalendarVByEqToday(freshness.getStoreId(), freshness.getProdMatClassId());
            mapMaxDay.put(key, proFactoryAllot);
        }
        return proFactoryAllot;
    }

    private Integer countOccupyPredictNum(FreshnessStatisticsNewV freshness, List<EinventoryRelationV> balancEinventoryRelations, Date today, Map<String, ProFactoryAllotCalendarV> mapB_) {
        int sum = 0;
        if (!freshness.getStoreId().equals("1069807551659380736")) {
            return sum;
        }
        if (balancEinventoryRelations == null) {
            return sum;
        }
        long satrtTime = Long.valueOf(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)today, (int)(-freshness.getFreshness().intValue())), (String)"yyyyMMdd"));
        long endTime = Long.valueOf(DateUtils.formatDate((Date)today, (String)"yyyyMMdd"));
        long todayNew = Long.valueOf(DateUtils.formatDate((Date)today, (String)"yyyyMMdd"));
        long endPicupdate = Long.valueOf(DateUtils.formatDate((Date)this.todayIfAllocationDate(freshness, today, mapB_), (String)"yyyyMMdd"));
        for (EinventoryRelationV balanc : balancEinventoryRelations) {
            long picupdate;
            long dateTime;
            if (balanc.getDatatpye() != 2 || !this.sumIf(satrtTime, endTime, dateTime = Long.valueOf(balanc.getProDate()).longValue(), freshness.getMatId(), balanc.getMatid(), freshness.getStoreId(), balanc.getStoreid()) || !this.sumIfSatrtTime(todayNew, picupdate = Long.valueOf(balanc.getPickupdate()).longValue()) || !this.sumIfSatrtTime(picupdate, endPicupdate)) continue;
            this.log.info("todayNew : " + todayNew + "  picupdate  : " + picupdate + "  endPicupdate :" + endPicupdate);
            sum += balanc.getOccupynum().intValue();
        }
        return sum;
    }

    private Integer countSellPredictNum(FreshnessStatisticsNewV freshness, Date today, Map<String, ProFactoryAllotCalendarV> map, List<ProPredictDetailV> proPredictDetails) {
        int sum = 0;
        if (proPredictDetails == null) {
            return sum;
        }
        if (!freshness.getStoreId().equals("1069807551659380736")) {
            return sum;
        }
        long satrtTime = Long.valueOf(DateUtils.formatDate((Date)today, (String)"yyyyMMdd"));
        long endTime = Long.valueOf(DateUtils.formatDate((Date)this.todayIfAllocationDate(freshness, today, map), (String)"yyyyMMdd"));
        for (ProPredictDetailV proPredict : proPredictDetails) {
            long pickupdate = Long.valueOf(proPredict.getPickupdate());
            if (!this.sumIf(satrtTime, endTime, pickupdate, freshness.getMatId(), proPredict.getMatid(), freshness.getStoreId(), proPredict.getStoreid()) || freshness.getFreshness() < proPredict.getFreshness()) continue;
            sum += proPredict.getShipments().intValue();
        }
        return sum;
    }

    private Integer countOccupyreleasenum(FreshnessStatisticsNewV freshness, Date today, List<EinventoryRelationV> balancEinventoryRelations, Map<String, ProFactoryCalendarBuildV> mapbuld, Map<String, ProFactoryAllotCalendarV> mapBadd) throws Exception {
        int sum = 0;
        if (balancEinventoryRelations == null) {
            return sum;
        }
        if (freshness.getStoreId().equals("1037595826996514816")) {
            return this.sumBEinventoryRelationVBeijing(freshness, today, balancEinventoryRelations, mapbuld);
        }
        if (freshness.getStoreId().equals("1069807551659380736")) {
            return this.sumBEinventoryRelationVShanghai(freshness, today, balancEinventoryRelations, mapBadd);
        }
        return sum;
    }

    private Integer sumBEinventoryRelationVBeijing(FreshnessStatisticsNewV freshness, Date today, List<EinventoryRelationV> balancEinventoryRelations, Map<String, ProFactoryCalendarBuildV> mapbuld) throws Exception {
        int sum = 0;
        long satrtTime = Long.valueOf(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)today, (int)(-freshness.getFreshness().intValue())), (String)"yyyyMMdd"));
        long endTime = Long.valueOf(DateUtils.formatDate((Date)today, (String)"yyyyMMdd"));
        long todaynew = Long.valueOf(DateUtils.formatDate((Date)today, (String)"yyyyMMdd"));
        Date date = this.getProFactoryCalendarBuilEnDate(freshness, today, mapbuld);
        if (date != null) {
            for (EinventoryRelationV balanc : balancEinventoryRelations) {
                long picupdate;
                long dateTime;
                if (balanc.getType() != 2 || balanc.getDatatpye() != 2 || !this.sumIf(satrtTime, endTime, dateTime = Long.valueOf(balanc.getProDate()).longValue(), freshness.getMatId(), balanc.getMatid(), freshness.getStoreId(), balanc.getStoreid()) || !this.sumIfSatrtTime(todaynew, picupdate = Long.valueOf(balanc.getPickupdate()).longValue())) continue;
                sum += balanc.getOccupynum().intValue();
            }
            return sum;
        }
        return 0;
    }

    private Integer sumBEinventoryRelationVShanghai(FreshnessStatisticsNewV freshness, Date today, List<EinventoryRelationV> balancEinventoryRelations, Map<String, ProFactoryAllotCalendarV> mapBadd) throws Exception {
        int sum = 0;
        long satrtTime = Long.valueOf(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)today, (int)(-freshness.getFreshness().intValue())), (String)"yyyyMMdd"));
        long endTime = Long.valueOf(DateUtils.formatDate((Date)today, (String)"yyyyMMdd"));
        StringBuffer sb = new StringBuffer();
        sb.append("satrtTime  : " + satrtTime).append(" | ").append("endTime  : " + endTime);
        long endPicupdate = Long.valueOf(DateUtils.formatDate((Date)this.todayBAddIfAllocationDate(freshness, today, mapBadd), (String)"yyyyMMdd"));
        sb.append("endPicupdate :" + endPicupdate);
        for (EinventoryRelationV balanc : balancEinventoryRelations) {
            long picupdate;
            long dateTime;
            if (balanc.getDatatpye() != 2 || !this.sumIf(satrtTime, endTime, dateTime = Long.valueOf(balanc.getProDate()).longValue(), freshness.getMatId(), balanc.getMatid(), freshness.getStoreId(), balanc.getStoreid()) || !this.sumIfSatrtTime(endPicupdate, picupdate = Long.valueOf(balanc.getPickupdate()).longValue())) continue;
            sb.append("\ndateTime  : " + dateTime).append(" | ").append("picupdate  : " + picupdate).append(" json " + JSONObject.toJSONString((Object)balanc));
            sum += balanc.getOccupynum().intValue();
        }
        return sum;
    }

    private Integer countAllocationInTransitNum(FreshnessStatisticsNewV freshness, List<IcAllotDetailPro> IcAllotDetailPros, Date today) {
        int sum = 0;
        if (IcAllotDetailPros == null) {
            return sum;
        }
        long satrtTime = Long.valueOf(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)today, (int)(-freshness.getFreshness().intValue())), (String)"yyyyMMdd"));
        long endTime = Long.valueOf(DateUtils.formatDate((Date)today, (String)"yyyyMMdd"));
        for (IcAllotDetailPro icAllotDetailPro : IcAllotDetailPros) {
            long dateTime = Long.valueOf(DateUtils.formatDate((Date)icAllotDetailPro.getProdTime(), (String)"yyyyMMdd"));
            if (!this.sumIf(satrtTime, endTime, dateTime, freshness.getMatId(), icAllotDetailPro.getCmatId(), freshness.getStoreId(), icAllotDetailPro.getStoreInId())) continue;
            sum += icAllotDetailPro.getIqty().intValue();
        }
        return sum;
    }

    private Integer countInTransitPredictNum(FreshnessStatisticsNewV freshness, Date today, Map<String, ProFactoryAllotCalendarV> mapMaxDay, List<ProPredictDetailV> proPredictDetails) {
        int sum = 0;
        if (proPredictDetails == null) {
            return sum;
        }
        ProFactoryAllotCalendarV proFactoryAllotCalendarV = this.getTodayProFactoryAllot(freshness, today, mapMaxDay);
        if (proFactoryAllotCalendarV != null) {
            if (!freshness.getProdMatClassId().equals(proFactoryAllotCalendarV.getMatclassid())) {
                return sum;
            }
            if (proPredictDetails.size() > 0) {
                for (ProPredictDetailV proPredictDetailV : proPredictDetails) {
                    long dateTime = Long.valueOf(proPredictDetailV.getPickupdate());
                    if (!this.sumIf(Long.valueOf(DateUtils.formatDate((Date)proFactoryAllotCalendarV.getPlanstarttime(), (String)"yyyyMMdd")).longValue(), Long.valueOf(DateUtils.formatDate((Date)proFactoryAllotCalendarV.getPlanendtime(), (String)"yyyyMMdd")).longValue(), dateTime, freshness.getMatId(), proPredictDetailV.getMatid(), freshness.getStoreId(), proPredictDetailV.getStoreid()) || freshness.getFreshness() < proPredictDetailV.getFreshness()) continue;
                    sum += proPredictDetailV.getShipments().intValue();
                }
            }
        }
        return sum;
    }

    private Integer countTotal(FreshnessStatisticsNewV freshnes) {
        int A = freshnes.getSiltcargoNum();
        int B = freshnes.getOccupyPredictNum() - freshnes.getSellPredictNum() > 0 ? 0 : freshnes.getOccupyPredictNum() - freshnes.getSellPredictNum();
        int B1 = B + freshnes.getOccupyreleasenum();
        int C = freshnes.getAllocationInTransitNum() - freshnes.getInTransitPredictNum() >= 0 ? 0 : freshnes.getAllocationInTransitNum() - freshnes.getInTransitPredictNum();
        return A + B1 + C;
    }

    private Integer countPlanNum(FreshnessStatisticsNewV freshness, List<ProMaterialPlanHistoryOccupyEntity> proMaterialPlanHistoryOccupys, Date today) {
        int sum = 0;
        if (proMaterialPlanHistoryOccupys == null) {
            return sum;
        }
        if (freshness.getStoreId().equals("1037595826996514816")) {
            return this.countPlanNumByBeijing(freshness, proMaterialPlanHistoryOccupys, today);
        }
        return sum;
    }

    private Integer countPlanNumByBeijing(FreshnessStatisticsNewV freshness, List<ProMaterialPlanHistoryOccupyEntity> proMaterialPlanHistoryOccupys, Date today) {
        int sum = 0;
        Integer freshnes = freshness.getFreshness();
        if (proMaterialPlanHistoryOccupys != null && proMaterialPlanHistoryOccupys.size() > 0) {
            for (ProMaterialPlanHistoryOccupyEntity proMaterialPlanHistoryOccupy : proMaterialPlanHistoryOccupys) {
                if (!this.checklanHistoryOccupy(freshness, proMaterialPlanHistoryOccupy, today, freshnes)) continue;
                sum = sum + (freshness.getPlanNum() != null ? freshness.getPlanNum() : 0) + proMaterialPlanHistoryOccupy.getOccupynum();
            }
        }
        return sum;
    }

    private Integer countPlanAddNum(FreshnessStatisticsNewV freshness, List<ProMaterialPlanHistoryOccupyEntity> proMaterialPlanHistoryOccupys, Date today) {
        int sum = 0;
        if (proMaterialPlanHistoryOccupys == null) {
            return sum;
        }
        if (freshness.getStoreId().equals("1037595826996514816")) {
            return this.countPlanAddNumByBeijing(freshness, proMaterialPlanHistoryOccupys, today);
        }
        return sum;
    }

    private Integer countPlanAddNumByBeijing(FreshnessStatisticsNewV freshness, List<ProMaterialPlanHistoryOccupyEntity> proMaterialPlanHistoryOccupys, Date today) {
        int sum = 0;
        Integer freshnes = freshness.getFreshness();
        if (proMaterialPlanHistoryOccupys != null && proMaterialPlanHistoryOccupys.size() > 0) {
            for (ProMaterialPlanHistoryOccupyEntity proMaterialPlanHistoryOccupy : proMaterialPlanHistoryOccupys) {
                if (!this.checklanHistoryOccupy(freshness, proMaterialPlanHistoryOccupy, today, freshnes)) continue;
                sum = sum + (freshness.getPlanAddNum() != null ? freshness.getPlanAddNum() : 0) + (proMaterialPlanHistoryOccupy.getPlanaddnum() != null ? proMaterialPlanHistoryOccupy.getPlanaddnum() : 0);
            }
        }
        return sum;
    }

    private boolean checklanHistoryOccupy(FreshnessStatisticsNewV freshness, ProMaterialPlanHistoryOccupyEntity proMaterialPlanHistoryOccupy, Date today, Integer freshnes) {
        if (!proMaterialPlanHistoryOccupy.getMatid().equals(freshness.getMatId())) {
            return false;
        }
        if (!proMaterialPlanHistoryOccupy.getStoreid().equals(freshness.getStoreId())) {
            return false;
        }
        return this.checkTimePlanHistoryOccupy(freshnes, proMaterialPlanHistoryOccupy.getCbatchname(), today);
    }

    private boolean checkTimePlanHistoryOccupy(Integer freshness, String cbatchname, Date today) {
        long startTimeString = Long.valueOf(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)today, (int)(-freshness.intValue())), (String)"yyyyMMdd"));
        long endTimeString = Long.valueOf(DateUtils.formatDate((Date)today, (String)"yyyyMMdd"));
        long timeString = Long.valueOf(cbatchname);
        return startTimeString <= timeString && timeString <= endTimeString;
    }
}

