/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.service.impl;

import cc.lechun.bd.entity.vo.EdbMaterialRelationEntityV;
import cc.lechun.bd.entity.vo.EdbWarehouseRelationEntityV;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.pro.dao.impl.GetEdbDatasDao;
import cc.lechun.pro.dao.impl.ProStoreMaterialDao;
import cc.lechun.pro.entity.FormEdianBaoGetStoreMateral;
import cc.lechun.pro.entity.vo.ProStoreMaterialV;
import cc.lechun.pro.service.GetEdbDataService;
import cc.lechun.pro.util.mythread.ThreadUtil;
import cc.lechun.pro.util.mythread.myclass.ToRunMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GetEdbDataServiceImpl
implements GetEdbDataService {
    @Autowired
    private GetEdbDatasDao getEdbDatasDao;
    @Autowired
    private ProStoreMaterialDao proStoreMaterialDao;
    private Logger log = LoggerFactory.getLogger(GetEdbDataServiceImpl.class);

    public synchronized BaseJsonVo saveEdbAndloclStoreData() {
        long time3 = System.currentTimeMillis();
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        List edBstoreDatas = this.getEdbDatasDao.getEDBstoreDatas();
        if (edBstoreDatas == null || edBstoreDatas.size() < 1) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage("\u672a\u83b7\u53d6\u5230\u6613\u5e97\u5b9d\u7684\u6570\u636e");
            return baseJsonVo;
        }
        List warehouseRelations = this.getEdbDatasDao.getWarehouseRelations();
        if (warehouseRelations == null || warehouseRelations.size() < 1) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage("\u4e3a\u83b7\u53d6\u5230\u4ed3\u5e93\u6620\u5c04\u6570\u636e");
            return baseJsonVo;
        }
        List materialRelations = this.getEdbDatasDao.getMaterialRelations();
        if (warehouseRelations == null || warehouseRelations.size() < 1) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage("\u672a\u83b7\u53d6\u5230\u7269\u54c1\u6620\u5c04\u6570\u636e");
            return baseJsonVo;
        }
        try {
            this.updateDatas(edBstoreDatas, warehouseRelations, materialRelations);
        }
        catch (Exception e) {
            this.log.error("\u540e\u53f0\u5f02\u5e38 \uff1a", (Throwable)e);
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage("\u540e\u53f0\u5f02\u5e38 \uff1a" + e.getMessage());
        }
        long time4 = System.currentTimeMillis();
        this.log.info("=====saveEdbAndloclStoreData=====edb\u6570\u636e\u8f6c\u6362\u4e3a\u672c\u5730\u6570\u636e\u5e76\u5165\u5e93  ==\u300b" + (time4 - time3) + "\u6beb\u79d2");
        return baseJsonVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public synchronized void updateDatas(List<FormEdianBaoGetStoreMateral> edBstoreDatas, List<EdbWarehouseRelationEntityV> warehouseRelations, List<EdbMaterialRelationEntityV> materialRelations) throws Exception {
        List list;
        List proStoreMaterialsmerge;
        if (edBstoreDatas != null && edBstoreDatas.size() > 0) {
            long time3 = System.currentTimeMillis();
            ThreadUtil t = new ThreadUtil();
            t.toRun("\u63d2\u5165EDB\u539f\u59cb\u5e93\u5b58\u6570\u636e", (ToRunMethod)new /* Unavailable Anonymous Inner Class!! */);
            this.log.error("\u5f02\u6b65\u6267\u884c\u63d2\u5165EDB\u539f\u59cb\u5e93\u5b58\u6570\u636e\u8017\u65f6:" + (System.currentTimeMillis() - time3));
        }
        if ((proStoreMaterialsmerge = this.getEdbDatasDao.edbToloclDatas(list = this.getEdbDatasDao.gropSumEdbDatas(edBstoreDatas), warehouseRelations, materialRelations)) != null && proStoreMaterialsmerge.size() > 0) {
            long time3 = System.currentTimeMillis();
            this.proStoreMaterialDao.addRecordsBatch(proStoreMaterialsmerge);
            long time4 = System.currentTimeMillis();
            this.log.info("edb\u6570\u636e\u8f6c\u6362\u4e3a\u672c\u5730\u6570\u636e\u5e76\u5165\u5e93(" + proStoreMaterialsmerge.size() + ") proStoreMaterialDao.addRecordsBatch ======\u300b" + (time4 - time3) + "\u6beb\u79d2");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public synchronized BaseJsonVo addAllMatnAndProMat() {
        long time3 = System.currentTimeMillis();
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            this.proStoreMaterialDao.addAllMatnAndProMat();
        }
        catch (Exception e) {
            this.log.error("\u540e\u53f0\u5f02\u5e38 \uff1a", (Throwable)e);
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage("\u540e\u53f0\u5f02\u5e38 \uff1a" + e.getMessage());
        }
        long time4 = System.currentTimeMillis();
        this.log.info("=====addAllMatnAndProMat====\u83b7\u53d6\u5728\u9014\u5728\u4ea7\u6570\u636e\u5e76\u5165\u5e93  ==\u300b" + (time4 - time3) + "\u6beb\u79d2");
        return baseJsonVo;
    }

    public synchronized List<ProStoreMaterialV> mergeErpStoreDatas(List<ProStoreMaterialV> proStoreMaterials) throws Exception {
        ArrayList<ProStoreMaterialV> list = new ArrayList<ProStoreMaterialV>();
        HashMap<String, ProStoreMaterialV> map = new HashMap<String, ProStoreMaterialV>();
        if (proStoreMaterials != null && proStoreMaterials.size() > 0) {
            for (ProStoreMaterialV proStoreMaterial : proStoreMaterials) {
                if (map.containsKey(proStoreMaterial.toOnlyconditions())) {
                    if (((ProStoreMaterialV)map.get(proStoreMaterial.toOnlyconditions())).getEdbinitialnum() != null) {
                        if (proStoreMaterial.getEdbinitialnum() == null) continue;
                        ((ProStoreMaterialV)map.get(proStoreMaterial.toOnlyconditions())).setEdbinitialnum(Integer.valueOf(((ProStoreMaterialV)map.get(proStoreMaterial.toOnlyconditions())).getEdbinitialnum() + proStoreMaterial.getEdbinitialnum()));
                        continue;
                    }
                    if (proStoreMaterial.getEdbinitialnum() == null) continue;
                    ((ProStoreMaterialV)map.get(proStoreMaterial.toOnlyconditions())).setEdbinitialnum(proStoreMaterial.getEdbinitialnum());
                    continue;
                }
                map.put(proStoreMaterial.toOnlyconditions(), proStoreMaterial);
            }
        }
        for (Map.Entry value : map.entrySet()) {
            list.add((ProStoreMaterialV)value.getValue());
        }
        return list;
    }

    static /* synthetic */ GetEdbDatasDao access$000(GetEdbDataServiceImpl x0) {
        return x0.getEdbDatasDao;
    }

    static /* synthetic */ Logger access$100(GetEdbDataServiceImpl x0) {
        return x0.log;
    }
}

