/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.service.impl;

import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.pro.dao.MaterialProdMapper;
import cc.lechun.pro.entity.MaterialProdEntity;
import cc.lechun.pro.service.MaterialProdService;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

@Service
public class MaterialProdServiceImpl
implements MaterialProdService {
    @Autowired
    private MaterialProdMapper materialProdMapper;

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo<List<MaterialProdEntity>> saveOrUpdateMaterialProd(@RequestBody List<MaterialProdEntity> materialProds) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            ArrayList<MaterialProdEntity> listAdd = new ArrayList<MaterialProdEntity>();
            ArrayList<MaterialProdEntity> listUpdate = new ArrayList<MaterialProdEntity>();
            if (null != materialProds && materialProds.size() > 0) {
                for (MaterialProdEntity materialProd : materialProds) {
                    if (StringUtils.isNotBlank((String)materialProd.getBmpid())) {
                        listUpdate.add(materialProd);
                        continue;
                    }
                    materialProd.setMatid(materialProd.getCguid());
                    materialProd.setBmpid(IDGenerate.getUniqueIdStr());
                    listAdd.add(materialProd);
                }
            }
            if (listAdd.size() > 0) {
                this.materialProdMapper.addRecordsBatch(listAdd);
            }
            if (listUpdate.size() > 0) {
                for (MaterialProdEntity materialProd : listUpdate) {
                    this.materialProdMapper.updateByParam(materialProd);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    public BaseJsonVo<List<MaterialProdEntity>> findPage(@RequestHeader(value="pageNo") Integer pageNo, @RequestHeader(value="pageSize") Integer pageSize, @RequestBody Map<String, Object> map) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        if (pageNo == null) {
            pageNo = 0;
        }
        if (pageSize == null) {
            pageSize = 0;
        }
        try {
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            baseJsonVo.setValue((Object)this.materialProdMapper.loadList(map));
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }
}

