/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.service.impl;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.BaseUser;
import cc.lechun.pro.apiinvoke.WmsServiceClient;
import cc.lechun.pro.dao.ProAllocationSumMapper;
import cc.lechun.pro.dao.ProFactoryCalendarMapper;
import cc.lechun.pro.dao.ProPredictSumMapper;
import cc.lechun.pro.dao.ProStoreMaterialMapper;
import cc.lechun.pro.dao.ProTransportCalendarMapper;
import cc.lechun.pro.dao.ProductAllocationMapper;
import cc.lechun.pro.dao.impl.ProAllocationOccupyRelationNewDao;
import cc.lechun.pro.dao.impl.ProAllocationSumDao;
import cc.lechun.pro.dao.impl.ProFactoryAllotCalendarDao;
import cc.lechun.pro.dao.impl.ProPredictDetailDao;
import cc.lechun.pro.entity.ProAllocationOccupyRelationNewEntity;
import cc.lechun.pro.entity.ProAllocationSumEntity;
import cc.lechun.pro.entity.ProStoreMaterialEntity;
import cc.lechun.pro.entity.vo.ProAllocationOccupyRelationV;
import cc.lechun.pro.entity.vo.ProAllocationSumEntityVo;
import cc.lechun.pro.entity.vo.ProFactoryAllotCalendarV;
import cc.lechun.pro.entity.vo.ProPredictDetailV;
import cc.lechun.pro.entity.vo.ProStoreMaterialV;
import cc.lechun.pro.service.ProAllocationSumService;
import cc.lechun.pro.service.impl.ProAllocationSumHistoryOccupyServiceImpl;
import cc.lechun.pro.util.JsonUtils;
import cc.lechun.wms.entity.IcAllotDetailEntity;
import cc.lechun.wms.entity.IcAllotEntity;
import cc.lechun.wms.entity.vo.IcAllotVO;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

@Service
public class ProAllocationSumServiceImpl
implements ProAllocationSumService {
    private Logger log = LoggerFactory.getLogger((String)ProAllocationSumServiceImpl.class.getName());
    @Autowired
    private ProAllocationSumMapper proAllocationSumMapper;
    @Autowired
    private ProTransportCalendarMapper proTransportCalendarMapper;
    @Autowired
    private ProductAllocationMapper productAllocationMapper;
    @Autowired
    private ProPredictSumMapper proPredictSumMapper;
    @Autowired
    private ProStoreMaterialMapper proStoreMaterialMapper;
    @Autowired
    private ProFactoryCalendarMapper proFactoryCalendarMapper;
    @Autowired
    private WmsServiceClient wmsServiceClient;
    @Autowired
    private ProPredictDetailDao proPredictDetailDao;
    @Autowired
    private ProFactoryAllotCalendarDao proFactoryAllotCalendarDao;
    @Autowired
    private ProAllocationOccupyRelationNewDao proAllocationOccupyRelationNewDao;
    @Autowired
    private ProAllocationSumDao proAllocationSumDao;
    @Autowired
    private ProAllocationSumHistoryOccupyServiceImpl proAllocationSumHistoryOccupyServiceImpl;

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo saveOrUpdateList(@RequestBody List<ProAllocationSumEntity> proAllocationSumEntitys, List<String> deleteids) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            ArrayList<ProAllocationSumEntity> listAdd = new ArrayList<ProAllocationSumEntity>();
            ArrayList<ProAllocationSumEntity> listUpdate = new ArrayList<ProAllocationSumEntity>();
            if (null != proAllocationSumEntitys && proAllocationSumEntitys.size() > 0) {
                for (ProAllocationSumEntity proAllocationSum : proAllocationSumEntitys) {
                    if (StringUtils.isNotBlank((String)proAllocationSum.getId())) {
                        listUpdate.add(proAllocationSum);
                        continue;
                    }
                    proAllocationSum.setId(IDGenerate.getUniqueIdStr());
                    listAdd.add(proAllocationSum);
                }
            }
            if (listAdd.size() > 0) {
                this.proAllocationSumMapper.addRecordsBatch(listAdd);
            }
            if (listUpdate.size() > 0) {
                this.proAllocationSumMapper.updateBatch(listUpdate);
            }
            if (deleteids != null && deleteids.size() > 0) {
                this.proAllocationSumMapper.deleteByIds(deleteids);
            }
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage(e.getMessage());
        }
        return baseJsonVo;
    }

    public BaseJsonVo<List<ProAllocationSumEntity>> findList(@RequestHeader(value="pageNo") Integer pageNo, @RequestHeader(value="pageSize") Integer pageSize, @RequestBody Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (pageNo == null) {
                pageNo = 0;
            }
            if (pageSize == null) {
                pageSize = 0;
            }
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            param.put("status", 1);
            baseJsonVo.setValue((Object)this.proAllocationSumMapper.loadList(param));
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo deleteByIds(@RequestBody List<String> deleteIds) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (deleteIds != null && deleteIds.size() > 0) {
                this.proAllocationSumMapper.deleteByIds(deleteIds);
            } else {
                baseJsonVo.setStatus(500);
                baseJsonVo.setError_msg("deleteIds is null");
            }
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo countProMaterialAllocationPlanNew(BaseUser user) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            List proFactoryAllotCalendarVs = this.proFactoryAllotCalendarDao.findListByleadTime();
            List proPredictDetails = this.proPredictDetailDao.findPredictDetailsBeforTodayByAllot();
            Set checkPredictDetailFreshness = ProPredictDetailV.checkFreshnessV((List)proPredictDetails);
            if (checkPredictDetailFreshness.size() > 0) {
                baseJsonVo.setStatus(500);
                baseJsonVo.setMessage(JSONObject.toJSONString((Object)checkPredictDetailFreshness));
                return baseJsonVo;
            }
            List list = this.buildMaterialAllocationDatas(proFactoryAllotCalendarVs, proPredictDetails);
            List proStoreMaterialEntitysA = this.proStoreMaterialMapper.findAll();
            List proStoreMaterialEntits = this.filerDatas(proStoreMaterialEntitysA);
            List proAllocationOccupyRelations = this.buildAllocationSumpredictStore(proStoreMaterialEntits, list);
            this.proAllocationOccupyRelationNewDao.saveOrUpdate(proAllocationOccupyRelations);
            List addObjects = this.proAllocationOccupyRelationNewDao.findproAllocationSums();
            this.buildNetRequirementsAndOccupySum(addObjects, user);
            this.proAllocationSumDao.saveOrUpdate(addObjects);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage(e.getMessage());
        }
        return baseJsonVo;
    }

    public void buildNetRequirementsAndOccupySum(List<ProAllocationSumEntity> addObjects, BaseUser user) {
        if (addObjects != null && addObjects.size() > 0) {
            for (ProAllocationSumEntity proAllocationSum : addObjects) {
                if (proAllocationSum.getNeedSum() == null || proAllocationSum.getAllocationSum() == null) continue;
                proAllocationSum.setOccupySum(Integer.valueOf(proAllocationSum.getNeedSum() - proAllocationSum.getAllocationSum()));
                proAllocationSum.setNetRequirements(proAllocationSum.getAllocationSum());
                if (user == null || !StringUtils.isNotBlank((String)user.getEmployeeName())) continue;
                proAllocationSum.setModifier(user.getEmployeeName());
            }
        }
    }

    public boolean matchingStoreMateral(ProStoreMaterialEntity proStoreMaterialEntity, ProAllocationOccupyRelationNewEntity proAllocationOccupyRelation) {
        int feshness = proAllocationOccupyRelation.getFreshness();
        int startDate = Integer.valueOf(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)proAllocationOccupyRelation.getPickupdate(), (int)(-feshness)), (String)"yyyyMMdd"));
        int endDate = Integer.valueOf(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)proAllocationOccupyRelation.getPickupdate(), (int)-1), (String)"yyyyMMdd"));
        int prodtime = Integer.valueOf(DateUtils.formatDate((Date)proStoreMaterialEntity.getProdtime(), (String)"yyyyMMdd"));
        return proAllocationOccupyRelation.getStoreinid().equals(proStoreMaterialEntity.getStoreid()) && proAllocationOccupyRelation.getMatid().equals(proStoreMaterialEntity.getMatid()) && prodtime <= endDate && prodtime >= startDate;
    }

    public List<ProAllocationOccupyRelationV> buildAllocationSumpredictStore(List<ProStoreMaterialV> list, List<ProAllocationOccupyRelationV> proAllocationOccupyRelations) {
        ArrayList<ProAllocationOccupyRelationV> proAllocationOccupyRelationsnew = new ArrayList<ProAllocationOccupyRelationV>();
        for (ProStoreMaterialEntity proStoreMaterialEntity : list) {
            proStoreMaterialEntity.setOccupynum(Integer.valueOf(0));
            proStoreMaterialEntity.setSurplusnum(proStoreMaterialEntity.getSurplusnum());
        }
        for (ProAllocationOccupyRelationV proAllocationOccupyRelationV : proAllocationOccupyRelations) {
            if (proAllocationOccupyRelationV.getSumtype() == 2 || list.size() < 1) {
                ProAllocationOccupyRelationV pore = proAllocationOccupyRelationV.copy(proAllocationOccupyRelationV);
                pore.setNeedsumoccupynum(Integer.valueOf(0));
                pore.setNeedsurplusneednum(proAllocationOccupyRelationV.getNeedsum());
                pore.setStoresurplusneednum(Integer.valueOf(0));
                proAllocationOccupyRelationsnew.add(pore);
                continue;
            }
            boolean flag = true;
            Integer needsurplusneednum = proAllocationOccupyRelationV.getNeedsum();
            for (ProStoreMaterialV entity : list) {
                if (needsurplusneednum <= 0 || entity.getInitialnum() <= 0 || !this.matchingStoreMateral((ProStoreMaterialEntity)entity, (ProAllocationOccupyRelationNewEntity)proAllocationOccupyRelationV)) continue;
                ProAllocationOccupyRelationV pore = proAllocationOccupyRelationV.copy(proAllocationOccupyRelationV);
                Integer storesnum = entity.getInitialnum();
                if (needsurplusneednum > storesnum) {
                    needsurplusneednum = needsurplusneednum - storesnum;
                    pore.setNeedsumoccupynum(storesnum);
                    pore.setCbatchname(DateUtils.formatDate((Date)entity.getProdtime(), (String)"yyyyMMdd"));
                    pore.setNeedsurplusneednum(needsurplusneednum);
                    pore.setStoresurplusneednum(Integer.valueOf(0));
                    entity.setInitialnum(Integer.valueOf(0));
                } else if (needsurplusneednum == storesnum) {
                    needsurplusneednum = needsurplusneednum - storesnum;
                    pore.setNeedsumoccupynum(storesnum);
                    pore.setNeedsurplusneednum(Integer.valueOf(0));
                    pore.setCbatchname(DateUtils.formatDate((Date)entity.getProdtime(), (String)"yyyyMMdd"));
                    entity.setInitialnum(Integer.valueOf(0));
                    pore.setStoresurplusneednum(Integer.valueOf(0));
                } else if (needsurplusneednum < storesnum) {
                    pore.setNeedsumoccupynum(needsurplusneednum);
                    pore.setNeedsurplusneednum(Integer.valueOf(0));
                    entity.setInitialnum(Integer.valueOf(storesnum - needsurplusneednum));
                    pore.setCbatchname(DateUtils.formatDate((Date)entity.getProdtime(), (String)"yyyyMMdd"));
                    pore.setStoresurplusneednum(Integer.valueOf(storesnum - needsurplusneednum));
                    needsurplusneednum = 0;
                }
                flag = false;
                proAllocationOccupyRelationsnew.add(pore);
            }
            if (!flag) continue;
            ProAllocationOccupyRelationV pore = proAllocationOccupyRelationV.copy(proAllocationOccupyRelationV);
            pore.setNeedsumoccupynum(Integer.valueOf(0));
            pore.setNeedsurplusneednum(proAllocationOccupyRelationV.getNeedsum());
            pore.setStoresurplusneednum(Integer.valueOf(0));
            proAllocationOccupyRelationsnew.add(pore);
        }
        return proAllocationOccupyRelationsnew;
    }

    private List<ProAllocationOccupyRelationV> buildMaterialAllocationDatas(List<ProFactoryAllotCalendarV> proFactoryAllotCalendarVs, List<ProPredictDetailV> proPredictDetails) {
        ArrayList<ProAllocationOccupyRelationV> list = new ArrayList<ProAllocationOccupyRelationV>();
        if (proFactoryAllotCalendarVs.size() > 0) {
            for (ProFactoryAllotCalendarV proFactoryAllotCalendarV : proFactoryAllotCalendarVs) {
                List listnew = this.buildMaterialAllocationDatas(proFactoryAllotCalendarV, proPredictDetails);
                if (listnew.size() <= 0) continue;
                list.addAll(listnew);
            }
        }
        this.canSortsum(list);
        return list;
    }

    private void canSortsum(List<ProAllocationOccupyRelationV> list) {
        if (list.size() > 0) {
            Collections.sort(list, new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private List<ProAllocationOccupyRelationV> buildMaterialAllocationDatas(ProFactoryAllotCalendarV proFactoryAllotCalendarV, List<ProPredictDetailV> proPredictDetails) {
        ArrayList<ProAllocationOccupyRelationV> list = new ArrayList<ProAllocationOccupyRelationV>();
        if (proPredictDetails.size() > 0) {
            for (ProPredictDetailV proPredictDetailV : proPredictDetails) {
                ProAllocationOccupyRelationV proAllocationOccupyRelation = this.buildMaterialAllocationDatas(proFactoryAllotCalendarV, proPredictDetailV);
                if (proAllocationOccupyRelation == null) continue;
                list.add(proAllocationOccupyRelation);
            }
        }
        return list;
    }

    private ProAllocationOccupyRelationV buildMaterialAllocationDatas(ProFactoryAllotCalendarV proFactoryAllotCalendarV, ProPredictDetailV proPredictDetail) {
        ProAllocationOccupyRelationV proAllocationOccupyRelationV = new ProAllocationOccupyRelationV();
        if (!proFactoryAllotCalendarV.getStoreinid().equals(proPredictDetail.getStoreid())) {
            return null;
        }
        if (!proFactoryAllotCalendarV.getMatclassid().equals(proPredictDetail.getPromatclassid())) {
            return null;
        }
        Integer picupDate = Integer.valueOf(proPredictDetail.getPickupdate());
        Integer startDate = Integer.valueOf(DateUtils.formatDate((Date)proFactoryAllotCalendarV.getPlanstarttime(), (String)"yyyyMMdd"));
        Integer endDate = Integer.valueOf(DateUtils.formatDate((Date)proFactoryAllotCalendarV.getPlanendtime(), (String)"yyyyMMdd"));
        if (startDate > picupDate || endDate < picupDate) {
            return null;
        }
        ProAllocationOccupyRelationV ProAllocationOccupyRelation = proAllocationOccupyRelationV.copy(proFactoryAllotCalendarV, proPredictDetail);
        return ProAllocationOccupyRelation;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo completeProAllocation(BaseUser user, String storeoutid, String storeinid) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            baseJsonVo = this.sendAllocationBille(user, storeoutid, storeinid);
            map.put("today", DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd"));
            map.put("storeoutid", storeoutid);
            map.put("storeinid", storeinid);
            this.proAllocationSumHistoryOccupyServiceImpl.saveProMaterialPlanHistoryOccupy(map);
            if (baseJsonVo.getStatus() == 200) {
                List list = (List)baseJsonVo.getValue();
                int n = this.proAllocationSumMapper.updateBatchProAllocationSumEntityVo(map);
            } else {
                this.log.error(" sendAllocationBille  ===== >" + JSONObject.toJSONString((Object)baseJsonVo));
            }
        }
        catch (Exception e) {
            this.log.error("\u5f02\u5e38 : ", (Throwable)e);
            e.printStackTrace();
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage(e.getMessage());
        }
        return baseJsonVo;
    }

    private BaseJsonVo<List<ProAllocationSumEntityVo>> sendAllocationBille(BaseUser user, String storeoutid, String storeinid) throws Exception {
        BaseJsonVo baseJson = new BaseJsonVo();
        baseJson.setStatus(200);
        Date date = new Date();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("today", DateUtils.formatDate((Date)date, (String)"yyyyMMdd"));
        map.put("storeoutid", storeoutid);
        map.put("storeinid", storeinid);
        List list = this.proAllocationSumMapper.findBuildAllocation(map);
        this.log.info("==>ProAllocationSumServiceImpl.sendAllocationBille\u65b9\u6cd5412\u884c\uff0c\u53c2\u6570\uff1a{}\uff0c\u7ed3\u679c{}", map, (Object)JsonUtils.objectToJson((Object)list));
        if (list == null || list.size() == 0) {
            baseJson.setStatus(500);
            baseJson.setMessage("\u65e0\u751f\u6210\u8c03\u62e8\u5355\u6240\u9700\u7684\u8c03\u62e8\u8ba1\u5212\u6570\u636e");
            return baseJson;
        }
        baseJson.setValue((Object)list);
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        for (ProAllocationSumEntityVo pas : list) {
            if (newMap.keySet().contains(pas.getOnlyOne())) {
                if (newMap.get(pas.getOnlyOne()) != null) {
                    ((List)newMap.get(pas.getOnlyOne())).add(pas);
                    continue;
                }
                newMap.put(pas.getOnlyOne(), new ArrayList());
                ((List)newMap.get(pas.getOnlyOne())).add(pas);
                continue;
            }
            ArrayList listnew = new ArrayList();
            listnew.add(pas);
            newMap.put(pas.getOnlyOne(), listnew);
        }
        ArrayList<IcAllotVO> newIcAllotVOs = new ArrayList<IcAllotVO>();
        StringBuffer sb = new StringBuffer();
        for (Map.Entry entry : newMap.entrySet()) {
            IcAllotVO icAllotVOs = new IcAllotVO();
            IcAllotEntity icAllot = new IcAllotEntity();
            icAllot.setDdate(date);
            if (user != null) {
                icAllot.setEmpid(user.getEmployeeId());
                icAllot.setCcreator(user.getId());
            }
            icAllot.setDcreatetime(date);
            icAllot.setCremark("\u7531\u8c03\u62e8\u7cfb\u7edf\u751f\u6210\u7684\u5355\u636e");
            icAllot.setAllottype(Integer.valueOf(2));
            icAllot.setIstatus(Integer.valueOf(0));
            ArrayList<IcAllotDetailEntity> add = new ArrayList<IcAllotDetailEntity>();
            for (ProAllocationSumEntityVo proAllocationSumEntity : (List)entry.getValue()) {
                icAllot.setLeadtime(proAllocationSumEntity.getLeadtime());
                icAllot.setLogisticsdate(proAllocationSumEntity.getPlanStartTime());
                icAllot.setEndlogisticsdate(proAllocationSumEntity.getPlanEndTime());
                icAllot.setStoreinid(proAllocationSumEntity.getStoreinId());
                icAllot.setStoreoutid(proAllocationSumEntity.getStoreoutId());
                String endTime = proAllocationSumEntity.getPlanStartTime();
                Integer T = proAllocationSumEntity.getPactoryfreshness();
                String startTime = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.StrToDate((String)endTime, (String)"yyyyMMdd"), (int)(-T.intValue())), (String)"yyyyMMdd");
                if (StringUtils.isNotBlank((String)sb.toString()) || proAllocationSumEntity.getAllocationSum() - 0 == 0) continue;
                IcAllotDetailEntity iad = new IcAllotDetailEntity();
                iad.setCmatid(proAllocationSumEntity.getMatId());
                iad.setIqty(new BigDecimal(proAllocationSumEntity.getAllocationSum()));
                iad.setUnitid(proAllocationSumEntity.getUnitId());
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("startTime", startTime);
                param.put("endTime", endTime);
                param.put("matId", proAllocationSumEntity.getMatId());
                param.put("storeId", proAllocationSumEntity.getStoreoutId());
                List proStoreMaterialEntityList = this.proStoreMaterialMapper.findOne(param);
                this.log.info("==>ProAllocationSumServiceImpl.sendAllocationBille\u65b9\u6cd5 493\u884c\uff0c\u53c2\u6570\uff1a{}\uff0c\u7ed3\u679c{}", param, (Object)JsonUtils.objectToJson((Object)proStoreMaterialEntityList));
                for (ProStoreMaterialEntity proStoreMaterialEntity : proStoreMaterialEntityList) {
                    if (proStoreMaterialEntity == null) continue;
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                    String dates = simpleDateFormat.format(proStoreMaterialEntity.getProdtime());
                    iad.setCbatchname(dates);
                    break;
                }
                if (StringUtils.isBlank((String)iad.getCbatchname())) {
                    String dates = DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd");
                    iad.setCbatchname(dates);
                    iad.setCremark("\u672a\u5339\u914d\u4e0a\u5e93\u5b58\u65e5\u671f,\u9ed8\u8ba4\u5f53\u524d\u65f6\u95f4\u4e3a\u6279\u6b21\u4fe1\u606f");
                }
                add.add(iad);
            }
            icAllotVOs.setIcAllot(icAllot);
            icAllotVOs.setAdd(add);
            newIcAllotVOs.add(icAllotVOs);
        }
        if (StringUtils.isNotBlank((String)sb.toString())) {
            baseJson.setStatus(500);
            baseJson.setMessage(sb.toString());
            return baseJson;
        }
        try {
            BaseJsonVo baseJsonVo = this.wmsServiceClient.saveOrUpdateFromPro(user.getId(), newIcAllotVOs);
            this.log.info("==>ProAllocationSumServiceImpl.sendAllocationBille\u65b9\u6cd5 528\u884c\uff0c\u53c2\u6570\uff1a{}\uff0c{}\uff0c\u7ed3\u679c{}", new Object[]{user.getId(), newIcAllotVOs, JsonUtils.objectToJson((Object)baseJsonVo)});
            if (baseJsonVo.getStatus() != 200) {
                return baseJsonVo;
            }
            return baseJson;
        }
        catch (Exception e) {
            this.log.error("\u5fae\u670d\u52a1\u5f02\u5e38WMS", (Throwable)e);
            baseJson.setStatus(500);
            baseJson.setMessage(e.getMessage());
            return baseJson;
        }
    }

    public BaseJsonVo<List<ProAllocationOccupyRelationV>> findListrelationNew(Integer pageNo, Integer pageSize, Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (pageNo == null) {
                pageNo = 0;
            }
            if (pageSize == null) {
                pageSize = 0;
            }
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            baseJsonVo.setValue((Object)this.proAllocationOccupyRelationNewDao.findProAllocationOccupyRelations(param));
        }
        catch (Exception e) {
            e.printStackTrace();
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    private List<ProStoreMaterialV> filerDatas(List<ProStoreMaterialV> proStoreMaterialEntitys) {
        ArrayList<ProStoreMaterialV> proStoreMaterialEntitysA = new ArrayList<ProStoreMaterialV>();
        if (proStoreMaterialEntitys != null && proStoreMaterialEntitys.size() > 0) {
            for (ProStoreMaterialV proStoreMaterialEntity : proStoreMaterialEntitys) {
                if (proStoreMaterialEntity.getInitialnum() == null || proStoreMaterialEntity.getInitialnum() <= 0 || proStoreMaterialEntity.getDatatpye() == 1) continue;
                proStoreMaterialEntity.setSiltcargonum(null);
                proStoreMaterialEntity.setMatchingoccupynum(null);
                proStoreMaterialEntitysA.add(proStoreMaterialEntity);
            }
        }
        return proStoreMaterialEntitysA;
    }
}

