/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.service.impl;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.pro.dao.impl.ProFactoryAllotCalendarDao;
import cc.lechun.pro.dao.impl.ProFactoryDao;
import cc.lechun.pro.dao.impl.ProTransportCalendarDao;
import cc.lechun.pro.entity.ProFactoryAllotCalendarEntity;
import cc.lechun.pro.entity.ProTransportCalendarEntity;
import cc.lechun.pro.entity.vo.ProFactoryAllotCalendarV;
import cc.lechun.pro.entity.vo.ProFactoryConfigAllotV;
import cc.lechun.pro.entity.vo.ProFactoryV;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProFactoryAllotCalendarServiceImpl {
    @Autowired
    private ProTransportCalendarDao proTransportCalendarDao;
    @Autowired
    private ProFactoryDao proFactoryDao;
    @Autowired
    private ProFactoryAllotCalendarDao proFactoryAllotCalendarDao;

    public BaseJsonVo<List<ProFactoryAllotCalendarV>> findList(Integer pageNo, Integer pageSize, Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (pageNo == null) {
                pageNo = 0;
            }
            if (pageSize == null) {
                pageSize = 0;
            }
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            baseJsonVo.setValue((Object)this.proFactoryAllotCalendarDao.findList(param));
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    public void saveProFactoryAllotCalendar() throws Exception {
        List list = this.builProFactoryAllotCalendar();
        this.proFactoryAllotCalendarDao.saveProFactoryAllotCalendar(list);
    }

    public List<ProFactoryAllotCalendarEntity> builProFactoryAllotCalendar() throws Exception {
        ArrayList<ProFactoryAllotCalendarEntity> list = new ArrayList();
        List proTransportCalendars = this.proTransportCalendarDao.findProTransportCalendars();
        List proFactoryVs = this.proFactoryDao.findfacoryAndSuns(Integer.valueOf(1));
        list = this.builProFactoryAllotCalendar(proTransportCalendars, proFactoryVs);
        return list;
    }

    private List<ProFactoryAllotCalendarEntity> builProFactoryAllotCalendar(List<ProTransportCalendarEntity> proTransportCalendars, List<ProFactoryV> proFactoryVs) throws Exception {
        ArrayList<ProFactoryAllotCalendarEntity> list = new ArrayList<ProFactoryAllotCalendarEntity>();
        if (proTransportCalendars.size() > 0 && proFactoryVs.size() > 0) {
            for (ProFactoryV proFactoryV : proFactoryVs) {
                if (proFactoryV.getProFactoryConfigAllots() == null || proFactoryV.getProFactoryConfigAllots().size() <= 0) continue;
                for (ProFactoryConfigAllotV proFactoryConfigAllotV : proFactoryV.getProFactoryConfigAllots()) {
                    List proFactoryAllotCalendars = this.builProFactoryAllotCalendar(proTransportCalendars, proFactoryConfigAllotV, proFactoryV);
                    if (proFactoryAllotCalendars.size() <= 0) continue;
                    list.addAll(proFactoryAllotCalendars);
                }
            }
        }
        return list;
    }

    private List<ProFactoryAllotCalendarEntity> builProFactoryAllotCalendar(List<ProTransportCalendarEntity> proTransportCalendars, ProFactoryConfigAllotV proFactoryConfigAllotV, ProFactoryV proFactoryV) throws Exception {
        ArrayList<ProFactoryAllotCalendarEntity> list = new ArrayList<ProFactoryAllotCalendarEntity>();
        for (ProTransportCalendarEntity proTransportCalendar : proTransportCalendars) {
            ProFactoryAllotCalendarEntity proFactoryAllotCalendarEntity = this.builProFactoryAllotCalendar(proTransportCalendar, proFactoryConfigAllotV, proFactoryV);
            if (null == proFactoryAllotCalendarEntity) continue;
            list.add(proFactoryAllotCalendarEntity);
        }
        return list;
    }

    private ProFactoryAllotCalendarEntity builProFactoryAllotCalendar(ProTransportCalendarEntity proTransportCalendar, ProFactoryConfigAllotV proFactoryConfigAllotV, ProFactoryV proFactoryV) throws Exception {
        ProFactoryAllotCalendarEntity proFactoryAllotCalendar = new ProFactoryAllotCalendarEntity();
        if (!proTransportCalendar.getStoreinId().equals(proFactoryConfigAllotV.getStoreinid())) {
            return null;
        }
        if (!proTransportCalendar.getStoreoutId().equals(proFactoryConfigAllotV.getStoreoutid())) {
            return null;
        }
        proFactoryAllotCalendar.setStoreinid(proFactoryConfigAllotV.getStoreinid());
        proFactoryAllotCalendar.setStoreoutid(proFactoryConfigAllotV.getStoreoutid());
        proFactoryAllotCalendar.setFactoryid(proFactoryV.getId());
        proFactoryAllotCalendar.setLogisticsid(proTransportCalendar.getLogisticsCpId());
        proFactoryAllotCalendar.setLogisticsdate(DateUtils.getDateFromString((String)proTransportCalendar.getLogisticsDate(), (String)"yyyyMMdd"));
        proFactoryAllotCalendar.setFreshness(proFactoryConfigAllotV.getFreshness());
        proFactoryAllotCalendar.setSumtype(proFactoryConfigAllotV.getSumtype());
        proFactoryAllotCalendar.setMatclassid(proFactoryConfigAllotV.getMatclassid());
        proFactoryAllotCalendar.setArrivetime(proTransportCalendar.getArrivetime());
        proFactoryAllotCalendar.setLeadtime(DateUtils.getAddDateByDay((Date)proFactoryAllotCalendar.getLogisticsdate(), (int)(-proFactoryConfigAllotV.getAllotleadtime().intValue())));
        proFactoryAllotCalendar.setEndleadtime(DateUtils.getAddDateByDay((Date)proFactoryAllotCalendar.getLogisticsdate(), (int)(proFactoryConfigAllotV.getAllotleadtime() > 0 ? -1 : 0)));
        proFactoryAllotCalendar.setPlanstarttime(DateUtils.getAddDateByDay((Date)proTransportCalendar.getArrivetime(), (int)1));
        proFactoryAllotCalendar.setPlanendtime(DateUtils.getAddDateByDay((Date)proFactoryAllotCalendar.getPlanstarttime(), (int)(proFactoryConfigAllotV.getAllotcoverdays() - 1)));
        return proFactoryAllotCalendar;
    }
}

