/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.service.impl;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.BaseUser;
import cc.lechun.pro.dao.ProTransportCalendarMapper;
import cc.lechun.pro.dao.impl.ProTransportCalendarDao;
import cc.lechun.pro.entity.ProTransportAllocationData;
import cc.lechun.pro.entity.ProTransportCalendarEntity;
import cc.lechun.pro.service.ProTransportCalendarService;
import cc.lechun.pro.service.impl.ProFactoryAllotCalendarServiceImpl;
import com.github.pagehelper.PageHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

@Service
public class ProTransportCalendarServiceImpl
implements ProTransportCalendarService {
    @Autowired
    private ProTransportCalendarMapper proTransportCalendarMapper;
    @Autowired
    private ProTransportCalendarDao proTransportCalendarDao;
    @Autowired
    private ProFactoryAllotCalendarServiceImpl proFactoryAllotCalendarServiceImpl;

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo saveOrUpdateList(@RequestBody List<ProTransportCalendarEntity> proTransportCalendarEntitys, List<String> deleteids, BaseUser user) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (null != proTransportCalendarEntitys && proTransportCalendarEntitys.size() > 0) {
                this.proTransportCalendarDao.saveOrUpdate(proTransportCalendarEntitys, user);
            }
            if (deleteids != null && deleteids.size() > 0) {
                this.proTransportCalendarMapper.deleteByIds(deleteids);
            }
            this.proFactoryAllotCalendarServiceImpl.saveProFactoryAllotCalendar();
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage(e.getMessage());
        }
        return baseJsonVo;
    }

    public BaseJsonVo<List<ProTransportCalendarEntity>> findList(@RequestHeader(value="pageNo") Integer pageNo, @RequestHeader(value="pageSize") Integer pageSize, @RequestBody Map<String, Object> param) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (pageNo == null) {
                pageNo = 0;
            }
            if (pageSize == null) {
                pageSize = 0;
            }
            if (pageNo > 0 && pageSize > 0) {
                PageHelper.startPage((int)pageNo, (int)pageSize);
            }
            baseJsonVo.setValue((Object)this.proTransportCalendarMapper.loadList(param));
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo deleteByIds(@RequestBody List<String> deleteIds) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            if (deleteIds != null && deleteIds.size() > 0) {
                this.proTransportCalendarMapper.deleteByIds(deleteIds);
            } else {
                baseJsonVo.setStatus(500);
                baseJsonVo.setError_msg("deleteIds is null");
            }
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    public BaseJsonVo<List<ProTransportAllocationData>> getProTransportAllocationData() {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        Date date = new Date();
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            String today = DateUtils.formatDate((Date)date, (String)"yyyyMMdd");
            param.put("beforDays", today);
            List list = this.proTransportCalendarMapper.findProTransportAllocationData(param);
            baseJsonVo.setValue((Object)list);
        }
        catch (Exception e) {
            e.printStackTrace();
            baseJsonVo.setStatus(500);
            baseJsonVo.setError_msg(e.getMessage());
        }
        return baseJsonVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseJsonVo<List<ProTransportCalendarEntity>> createAllotCalendar(List<ProTransportCalendarEntity> proTransportCalendarEntitys, BaseUser user) {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        baseJsonVo.setStatus(200);
        try {
            this.proTransportCalendarDao.saveOrUpdate(proTransportCalendarEntitys, user);
        }
        catch (Exception e) {
            baseJsonVo.setStatus(500);
            baseJsonVo.setMessage("\u540e\u53f0\u5f02\u5e38 \uff1a" + e.getMessage());
        }
        return baseJsonVo;
    }
}

