/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.pro.util.log;

import cc.lechun.pro.util.log.entity.BaseUseTimeEntity;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUseTimeAspect {
    private static final Logger logger = LoggerFactory.getLogger((String)"");
    private final String POINT_CUT_CONTROL = "execution(public * cc.lechun.pro.control.*.*(..))";
    private final String POINT_CUT_DAO = "execution(public * cc.lechun.pro.dao.impl.*.*(..))";
    private final String POINT_CUT_SERVICE = "execution(public * cc.lechun.pro.service.impl.*.*(..))";
    private final String POINT_CUT_CLIENT = "execution(public * cc.lechun.pro.apiinvoke.*.*(..))";

    public Object doAroundAdviceCONTROL(ProceedingJoinPoint proceedingJoinPoint) {
        Object object = null;
        try {
            object = this.doAroundAdvice(proceedingJoinPoint);
        }
        catch (Throwable throwable) {
            logger.error("\u5f02\u5e38", throwable);
        }
        return object;
    }

    public Object doAroundAdviceDAO(ProceedingJoinPoint proceedingJoinPoint) {
        Object object = null;
        try {
            object = this.doAroundAdvice(proceedingJoinPoint);
        }
        catch (Throwable throwable) {
            logger.error("\u5f02\u5e38", throwable);
        }
        return object;
    }

    public Object doAroundAdviceSERVICE(ProceedingJoinPoint proceedingJoinPoint) {
        Object object = null;
        try {
            object = this.doAroundAdvice(proceedingJoinPoint);
        }
        catch (Throwable throwable) {
            logger.error("\u5f02\u5e38", throwable);
        }
        return object;
    }

    public Object doAroundAdviceCLIENT(ProceedingJoinPoint proceedingJoinPoint) {
        Object object = null;
        try {
            object = this.doAroundAdvice(proceedingJoinPoint);
        }
        catch (Throwable throwable) {
            logger.error("\u5f02\u5e38", throwable);
        }
        return object;
    }

    public Object doAroundAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Long startTime = System.currentTimeMillis();
        BaseUseTimeEntity baseUseTimeEntity = new BaseUseTimeEntity();
        Object obj = proceedingJoinPoint.proceed();
        MethodSignature ht = (MethodSignature)proceedingJoinPoint.getSignature();
        Method targetMethod = ht.getMethod();
        baseUseTimeEntity.setPath(proceedingJoinPoint.getTarget().getClass().getName() + "." + targetMethod.getName());
        Long endTime = System.currentTimeMillis();
        long useTime = endTime - startTime;
        baseUseTimeEntity.setUseTime((double)useTime);
        if (useTime > 10000L) {
            logger.info("===============\u8017\u65f6====================" + JSONObject.toJSONString((Object)baseUseTimeEntity));
        }
        return obj;
    }
}

