package cc.lechun.qimen.wms.api.wms;

import cc.lechun.framework.common.vo.BaseJsonVo;
import com.qimen.api.request.*;
import com.qimen.api.response.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;

public interface ExampleQimenSendWmsApi {
    /**
    //taobao.qimen.deliveryorder.create  发货单创建接口
    @RequestMapping(value="/sendWms/deliveryorder/create",method = RequestMethod.POST)
    public BaseJsonVo<DeliveryorderCreateResponse > deliveryorderCreate(HttpServletRequest request, @RequestBody DeliveryorderCreateRequest req);
    //taobao.qimen.deliveryorder.confirm 发货单确认接口
    @RequestMapping(value="/sendWms/deliveryorder/confirm",method = RequestMethod.POST)
    public BaseJsonVo<DeliveryorderConfirmResponse > deliveryorderConfirm(HttpServletRequest request, @RequestBody DeliveryorderConfirmRequest req);
   // taobao.qimen.deliveryorder.batchconfirm 发货单确认接口
    @RequestMapping(value="/sendWms/deliveryorder/batchconfirm",method = RequestMethod.POST)
    public BaseJsonVo<DeliveryorderBatchconfirmResponse > deliveryorderBatchconfirm(HttpServletRequest request, @RequestBody DeliveryorderBatchconfirmRequest req);
    //taobao.qimen.deliveryorder.batchcreate 发货单创建批量接口
    @RequestMapping(value="/sendWms/deliveryorder/batchcreate",method = RequestMethod.POST)
    public BaseJsonVo<DeliveryorderBatchcreateResponse > deliveryorderBatchcreate(HttpServletRequest request, @RequestBody DeliveryorderBatchcreateRequest req);
    //taobao.qimen.deliveryorder.query 发货单查询接口
    @RequestMapping(value="/sendWms/deliveryorder/query",method = RequestMethod.POST)
    public BaseJsonVo<DeliveryorderQueryResponse> deliveryorderQuery(HttpServletRequest request, @RequestBody DeliveryorderQueryRequest req);
    //taobao.qimen.deliveryorder.batchcreate.answer  发货单创建结果通知接口(批量) WMS调用接口，用于异步化的批量发货单创建结果通知。（如菜鸟发货单批量创建结果的返回）
    @RequestMapping(value="/sendWms/deliveryorder/batchcreate/answer",method = RequestMethod.POST)
    BaseJsonVo<DeliveryorderBatchcreateAnswerResponse > deliveryorderBatchcreateAnswer(HttpServletRequest request, @RequestBody DeliveryorderBatchcreateAnswerRequest req);


    //taobao.qimen.deliveryordersum.query 订单出库统计查询
    @RequestMapping(value="/sendWms/deliveryordersum/query",method = RequestMethod.POST)
    public BaseJsonVo<DeliveryordersumQueryResponse > deliveryordersumQuery(HttpServletRequest request, @RequestBody DeliveryordersumQueryRequest req);

    //taobao.qimen.singleitem.query 商品查询接口
    @RequestMapping(value="/sendWms/singleitem/query",method = RequestMethod.POST)
    public BaseJsonVo<SingleitemQueryResponse > singleitemQuery(HttpServletRequest request, @RequestBody SingleitemQueryRequest req);




    //taobao.qimen.inventory.query 库存查询接口（多商品）
    @RequestMapping(value="/sendWms/inventory/query",method = RequestMethod.POST)
    public BaseJsonVo<InventoryQueryResponse > inventoryQuery(HttpServletRequest request, @RequestBody InventoryQueryRequest req);
    //taobao.qimen.inventory.report ( 库存盘点通知接口 ) WMS调用奇门的接口,将库存盘点情况回传ERP
    @RequestMapping(value="/sendWms/inventory/report",method = RequestMethod.POST)
    public BaseJsonVo<InventoryReportRequest > inventoryReport(HttpServletRequest request, @RequestBody InventoryReportRequest req);
    //taobao.qimen.inventorycheck.query 库存盘点查询接口
    @RequestMapping(value="/sendWms/inventorycheck/query",method = RequestMethod.POST)
    public BaseJsonVo<InventorycheckQueryResponse > inventorycheckQuery(HttpServletRequest request, @RequestBody InventorycheckQueryRequest req);

    //taobao.qimen.inventoryreserve.create 库存预占接口
    @RequestMapping(value="/sendWms/inventoryreserve/create",method = RequestMethod.POST)
    public BaseJsonVo<InventoryreserveCreateResponse > inventoryreserveCreate(HttpServletRequest request, @RequestBody InventoryreserveCreateRequest req);

    //taobao.qimen.inventoryreserve.cancel 库存预占取消接口
    @RequestMapping(value="/sendWms/inventoryreserve/cancel",method = RequestMethod.POST)
    public BaseJsonVo<InventoryreserveCancelResponse  > inventoryreserveCancel(HttpServletRequest request, @RequestBody InventoryreserveCancelRequest req);
   //taobao.qimen.inventorybatch.query 商品单仓批次库存查询接口 ERP 通过该接口查询指定商品的单仓批次库存
   @RequestMapping(value="/sendWms/inventorybatch/query",method = RequestMethod.POST)
   public BaseJsonVo<InventorybatchQueryResponse> inventorybatchQuery(HttpServletRequest request, @RequestBody InventorybatchQueryRequest req);



    //taobao.qimen.inventoryrule.create 渠道间库存规则设置接口
    @RequestMapping(value="/sendWms/inventoryrule/create",method = RequestMethod.POST)
    public BaseJsonVo<InventoryruleCreateResponse> inventoryreserveCreate(HttpServletRequest request, @RequestBody InventoryruleCreateRequest req);




    //taobao.qimen.returnorder.create 退货入库单创建接口
    @RequestMapping(value="/sendWms/returnorder/create",method = RequestMethod.POST)
    public BaseJsonVo<ReturnorderCreateResponse> returnorderCreate(HttpServletRequest request, @RequestBody ReturnorderCreateRequest req);
    //taobao.qimen.returnorder.confirm 退货入库单确认接口
    @RequestMapping(value="/sendWms/returnorder/confirm",method = RequestMethod.POST)
    public BaseJsonVo<ReturnorderConfirmResponse > returnorderConfirm(HttpServletRequest request, @RequestBody ReturnorderConfirmRequest req);
    //taobao.qimen.returnorder.query 退货入库单查询接口
    @RequestMapping(value="/sendWms/returnorder/query",method = RequestMethod.POST)
    public BaseJsonVo<ReturnorderQueryResponse > returnorderQuery(HttpServletRequest request, @RequestBody ReturnorderQueryRequest req);


    //taobao.qimen.entryorder.create 入库单创建接口
    @RequestMapping(value="/sendWms/entryorder/create",method = RequestMethod.POST)
    public BaseJsonVo<EntryorderCreateResponse> entryorderrCreate(HttpServletRequest request, @RequestBody EntryorderCreateRequest req);
    //taobao.qimen.entryorder.query 入库单查询接口
    @RequestMapping(value="/sendWms/entryorder/query",method = RequestMethod.POST)
    public BaseJsonVo<EntryorderQueryResponse> entryorderQuery(HttpServletRequest request, @RequestBody EntryorderQueryRequest req);
    //taobao.qimen.entryorder.confirm ( 入库单确认接口 WMS调用接口，回传入库单信息)
    @RequestMapping(value="/sendWms/entryorder/confirm",method = RequestMethod.POST)
    public BaseJsonVo<EntryorderConfirmResponse > entryorderConfirm(HttpServletRequest request, @RequestBody EntryorderConfirmRequest req);



    //taobao.qimen.stockout.create 出库单创建接口
    @RequestMapping(value="/sendWms/stockout/create",method = RequestMethod.POST)
    public BaseJsonVo<StockoutCreateResponse> stockoutCreate(HttpServletRequest request, @RequestBody StockoutCreateRequest req);
    //taobao.qimen.stockout.confirm ( 出库单确认接口 ) 货品出库后，WMS将状态回传给ERP
    @RequestMapping(value="/sendWms/stockout/confirm",method = RequestMethod.POST)
    public BaseJsonVo<StockoutConfirmResponse > stockoutConfirm(HttpServletRequest request, @RequestBody StockoutConfirmRequest req);
    //taobao.qimen.stockout.query 出库单查询接口
    @RequestMapping(value="/sendWms/stockout/query",method = RequestMethod.POST)
    public BaseJsonVo<StockoutQueryResponse > stockoutQuery(HttpServletRequest request, @RequestBody StockoutQueryRequest req);


    //taobao.qimen.stockchange.report 库存异动通知接口 WMS调用奇门的接口,将库存异动信息信息回传给ERP
    @RequestMapping(value="/sendWms/stockchange/report",method = RequestMethod.POST)
    public BaseJsonVo<StockchangeReportResponse > stockchangeReport(HttpServletRequest request, @RequestBody StockchangeReportRequest  req);

    //taobao.qimen.shop.synchronize 店铺同步接口
    @RequestMapping(value="/sendWms/shop/synchronize",method = RequestMethod.POST)
    public BaseJsonVo<ShopSynchronizeResponse  > shopSynchronize(HttpServletRequest request, @RequestBody ShopSynchronizeRequest req);



    //taobao.qimen.store.update  门店更新接口
    @RequestMapping(value="/sendWms/store/update",method = RequestMethod.POST)
    public BaseJsonVo<QimenStoreUpdateResponse > storeUpdate(HttpServletRequest request, @RequestBody QimenStoreUpdateRequest req);
    //taobao.qimen.store.create( 门店新增接口 ) isv调用接口来讲线下门店同步到线上
    @RequestMapping(value="/sendWms/store/create",method = RequestMethod.POST)
    public BaseJsonVo<QimenStoreCreateResponse > storeCreate(HttpServletRequest request, @RequestBody QimenStoreCreateRequest req);
    //taobao.qimen.store.delete( 门店删除接口 ) 商家在ERP等系统中调用该接口，删除线下门店
    @RequestMapping(value="/sendWms/store/delete",method = RequestMethod.POST)
    public BaseJsonVo<QimenStoreDeleteRequest > storeDelete(HttpServletRequest request, @RequestBody QimenStoreDeleteRequest req);
    //taobao.qimen.store.query( 门店信息查询接口 ) 商家在ERP等系统中调用该接口，查询门店相关信息
    @RequestMapping(value="/sendWms/store/query",method = RequestMethod.POST)
    public BaseJsonVo<QimenStoreQueryRequest > storeQuery(HttpServletRequest request, @RequestBody QimenStoreQueryRequest req);
    //taobao.qimen.storecategory.get( 门店类目获取接口 ) 商家在ERP中调用该接口，获取门店类目
    @RequestMapping(value="/sendWms/storecategory/get",method = RequestMethod.POST)
    public BaseJsonVo<QimenStorecategoryGetRequest > storecategoryGet(HttpServletRequest request, @RequestBody QimenStorecategoryGetRequest req);
    //taobao.qimen.itemstore.banding ( 商品关联绑定接口 ) 商家在ERP等系统中调用该接口，将线上商品和线下门店“新建/删除”关联。这里的线上。每次只能单个商品关联多个门店，门店上限200
    @RequestMapping(value="/sendWms/itemstore/banding",method = RequestMethod.POST)
    public BaseJsonVo<QimenItemstoreBandingResponse > itemstoreBanding(HttpServletRequest request, @RequestBody QimenItemstoreBandingRequest req);
    //taobao.qimen.itemstore.query( 商品关联门店查询接口 ) 商家在ERP等系统中调用该接口，查询线上商品所关联的门店列表
    @RequestMapping(value="/sendWms/itemstore/query",method = RequestMethod.POST)
    public BaseJsonVo<QimenItemstoreQueryResponse  > itemstoreQuery(HttpServletRequest request, @RequestBody QimenItemstoreQueryRequest req);
    //taobao.qimen.storeitem.query( 门店关联商品查询接口 ) 商家在ERP等系统中调用该接口，查询某门店所关联的线上商品列表
    @RequestMapping(value="/sendWms/storeitem/query",method = RequestMethod.POST)
    public BaseJsonVo<QimenStoreitemQueryResponse > storeitemQuery(HttpServletRequest request, @RequestBody QimenStoreitemQueryRequest req);




    //taobao.qimen.sn.report ( 发货单SN通知接口 ) WMS调用奇门的接口,在仓库出库单后, 把SN信息回传给ERP
    @RequestMapping(value="/sendWms/sn/report",method = RequestMethod.POST)
    public BaseJsonVo<SnReportResponse > snReport(HttpServletRequest request, @RequestBody SnReportRequest req);

    //taobao.qimen.transferorder.query 调拨单查询
    @RequestMapping(value="/sendWms/transferorder/query",method = RequestMethod.POST)
    public BaseJsonVo<TransferorderQueryResponse  > transferorderQuery(HttpServletRequest request, @RequestBody TransferorderQueryRequest req);

    //taobao.qimen.transferorder.create 调拨单创建
    @RequestMapping(value="/sendWms/transferorder/create",method = RequestMethod.POST)
    public BaseJsonVo<TransferorderQueryResponse  > transferorderCreate(HttpServletRequest request, @RequestBody TransferorderQueryRequest req);
    //taobao.qimen.transferorder.report
    @RequestMapping(value="/sendWms/transferorder/report",method = RequestMethod.POST)
    public BaseJsonVo<TransferorderReportResponse   > transferorderReport(HttpServletRequest request, @RequestBody TransferorderReportRequest req);



    //taobao.qimen.combineitem.query 组合货品关系查询接口
    @RequestMapping(value="/sendWms/combineitem/query",method = RequestMethod.POST)
    public BaseJsonVo<TransferorderCreateResponse   > combineitemQuery(HttpServletRequest request, @RequestBody TransferorderCreateRequest req);

    //taobao.qimen.combineitem.delete 组合货品删除接口
    @RequestMapping(value="/sendWms/combineitem/delete",method = RequestMethod.POST)
    public BaseJsonVo<CombineitemDeleteResponse> combineitemDelete(HttpServletRequest request, @RequestBody CombineitemDeleteRequest req);


    //taobao.qimen.orderprocess.report  订单流水通知接口 WMS调用奇门的接口,将订单在仓库的状态回传给ERP；场景说明：仓库仓内操作状态回传给ERP, 比如打包操作完成时, 回传一个打 包完成的状态给到ERP, ERP自行决定如何处理。
    @RequestMapping(value="/sendWms/orderprocess/report",method = RequestMethod.POST)
    public BaseJsonVo<OrderprocessReportResponse > orderprocessReport(HttpServletRequest request, @RequestBody OrderprocessReportRequest req);
    //taobao.qimen.orderprocess.query 订单流水查询接口
    @RequestMapping(value="/sendWms/orderprocess/query",method = RequestMethod.POST)
    public BaseJsonVo<OrderprocessQueryResponse> orderprocessQuery(HttpServletRequest request, @RequestBody OrderprocessQueryRequest req);




    //taobao.qimen.order.query 根据收件人信息查询交易单号接口 WMS 调用该接口，根据收件人信息查询平台交易订单号。
    @RequestMapping(value="/sendWms/order/query",method = RequestMethod.POST)
    public BaseJsonVo<OrderQueryResponse > orderQuery(HttpServletRequest request, @RequestBody OrderQueryRequest req);
    //taobao.qimen.order.cancel 单据取消接口
    @RequestMapping(value="/sendWms/order/cancel",method = RequestMethod.POST)
    public BaseJsonVo<OrderCancelResponse> orderCancel(HttpServletRequest request, @RequestBody OrderCancelRequest req);
    //taobao.qimen.order.pending 单据挂起（恢复）接口
    @RequestMapping(value="/sendWms/order/pending",method = RequestMethod.POST)
    public BaseJsonVo<OrderPendingResponse> orderPending(HttpServletRequest request, @RequestBody OrderPendingRequest req);
    //taobao.qimen.order.callback 配送拦截接口
    @RequestMapping(value="/sendWms/order/callback",method = RequestMethod.POST)
    BaseJsonVo<OrderCallbackResponse> orderCallback(HttpServletRequest request, @RequestBody OrderCallbackRequest req);
    //taobao.qimen.order.sn.report 订单SN通知接口 WMS调用奇门的接口,在出库、发货、入库等场景下，ERP和WMS之间同步操作的SN列表
    @RequestMapping(value="/sendWms/order/sn/report",method = RequestMethod.POST)
    BaseJsonVo<OrderSnReportResponse> orderSnNeport(HttpServletRequest request, @RequestBody OrderSnReportRequest req);
    //taobao.qimen.orderstatus.batchquery 订单状态查询接口(批量)
    @RequestMapping(value="/sendWms/orderstatus/batchquery",method = RequestMethod.POST)
    BaseJsonVo<OrderstatusBatchqueryResponse> orderstatusBatchquery(HttpServletRequest request, @RequestBody OrderstatusBatchqueryRequest req);


    //taobao.qimen.itemmapping.create 前后端商品映射接口
    @RequestMapping(value="/sendWms/itemmapping/create",method = RequestMethod.POST)
    public BaseJsonVo<ItemmappingCreateResponse> itemmappingCreate(HttpServletRequest request, @RequestBody ItemmappingCreateRequest req);

    //taobao.qimen.itemmapping.query 前后端商品映射查询接口
    @RequestMapping(value="/sendWms/itemmapping/query",method = RequestMethod.POST)
    public BaseJsonVo<SingleitemQueryResponse> itemmappingQuery(HttpServletRequest request, @RequestBody SingleitemQueryRequest req);


    //taobao.qimen.stock.query 库存查询接口（多条件）
    @RequestMapping(value="/sendWms/stock/query",method = RequestMethod.POST)
    public BaseJsonVo<StockQueryResponse> stockQuery(HttpServletRequest request, @RequestBody StockQueryRequest req);







    //taobao.qimen.storeprocess.create 仓内加工单创建接口
    @RequestMapping(value="/sendWms/storeprocess/create",method = RequestMethod.POST)
    public BaseJsonVo<StoreprocessCreateResponse > storeprocessCreate(HttpServletRequest request, @RequestBody StoreprocessCreateRequest req);
   // taobao.qimen.storeprocess.confirm ( 仓内加工单确认接口 ) WMS调用奇门的接口,回传仓内加工单创建情况
   @RequestMapping(value="/sendWms/storeprocess/confirm",method = RequestMethod.POST)
   BaseJsonVo<StoreprocessConfirmResponse  > storeprocessConfirm(HttpServletRequest request, @RequestBody StoreprocessConfirmRequest req);

    //taobao.qimen.itemlack.query 发货单缺货查询接口
    @RequestMapping(value="/sendWms/itemlack/query",method = RequestMethod.POST)
    BaseJsonVo<ItemlackQueryResponse  > itemlackQuery(HttpServletRequest request, @RequestBody ItemlackQueryRequest req);

    //taobao.qimen.replenishplan.create 商家补货计划创建接口
    @RequestMapping(value="/sendWms/replenishplan/create",method = RequestMethod.POST)
    BaseJsonVo<ReplenishplanCreateResponse  > replenishplanCreate(HttpServletRequest request, @RequestBody ReplenishplanCreateRequest req);


    //taobao.qimen.warehouseinfo.query 货主仓库资源查询接口
    @RequestMapping(value="/sendWms/warehouseinfo/query",method = RequestMethod.POST)
    BaseJsonVo<WarehouseinfoQueryResponse  > warehouseinfoQuery(HttpServletRequest request, @RequestBody WarehouseinfoQueryRequest req);

    //taobao.qimen.expressinfo.query 配送公司信息查询接口
    @RequestMapping(value="/sendWms/expressinfo/query",method = RequestMethod.POST)
    BaseJsonVo<ExpressinfoQueryResponse > expressinfoQuery(HttpServletRequest request, @RequestBody ExpressinfoQueryRequest req);

    //taobao.qimen.channelinventory.query 渠道库存查询接口
    @RequestMapping(value="/sendWms/channelinventory/query",method = RequestMethod.POST)
    BaseJsonVo<ChannelinventoryQueryResponse  > channelinventoryQuery(HttpServletRequest request, @RequestBody ChannelinventoryQueryRequest req);

    //taobao.qimen.wms.returnapply.report 退货异常包裹单通知接口
    @RequestMapping(value="/sendWms/wms/returnapply/report",method = RequestMethod.POST)
    public BaseJsonVo<WmsReturnapplyReportResponse   > wmsReturnapplyReport(HttpServletRequest request, @RequestBody WmsReturnapplyReportRequest req);

    //taobao.qimen.returnapply.report 退货异常包裹单通知接口
    @RequestMapping(value="/sendWms/returnapply/report",method = RequestMethod.POST)
    public BaseJsonVo<ReturnapplyReportResponse   > returnapplyReport(HttpServletRequest request, @RequestBody ReturnapplyReportRequest req);

    //taobao.qimen.service.heartbeat 心跳接口
    @RequestMapping(value="/sendWms/service/heartbeat",method = RequestMethod.POST)
    public BaseJsonVo<ServiceHeartbeatResponse   > serviceHeartbeat(HttpServletRequest request, @RequestBody ServiceHeartbeatRequest req);

    //taobao.qimen.supplier.synchronize 供应商同步接口
    @RequestMapping(value="/sendWms/supplier/synchronize",method = RequestMethod.POST)
    public BaseJsonVo<SupplierSynchronizeResponse   > supplierSynchronize(HttpServletRequest request, @RequestBody SupplierSynchronizeRequest req);

    //taobao.qimen.warehouseinfo.synchronize 仓库同步接口
    @RequestMapping(value="/sendWms/warehouseinfo/synchronize",method = RequestMethod.POST)
    public BaseJsonVo<WarehouseinfoSynchronizeResponse  > warehouseinfoSynchronize(HttpServletRequest request, @RequestBody WarehouseinfoSynchronizeRequest req);

    //taobao.qimen.singleitem.synchronize 商品同步接口
    @RequestMapping(value="/sendWms/singleitem/synchronize",method = RequestMethod.POST)
    public BaseJsonVo<SingleitemSynchronizeResponse > singleitemSynchronize(HttpServletRequest request, @RequestBody SingleitemSynchronizeRequest req);
    //taobao.qimen.items.synchronize 商品同步接口 (批量)
    @RequestMapping(value="/sendWms/items/synchronize",method = RequestMethod.POST)
    public BaseJsonVo<ItemsSynchronizeResponse > itemsSynchronize(HttpServletRequest request, @RequestBody ItemsSynchronizeRequest req);
    //taobao.qimen.combineitem.synchronize ( 组合商品接口 )
    @RequestMapping(value="/sendWms/combineitem/synchronize",method = RequestMethod.POST)
    public BaseJsonVo<CombineitemSynchronizeResponse > combineitemSynchronize(HttpServletRequest request, @RequestBody CombineitemSynchronizeRequest req);
    //taobao.qimen.wavenum.report ( 发货单波次通知接口 ) WMS调用奇门的接口,该接口用来给ERP或者OMS回传波次号及对应的发货单号，以支持商家货票同行、波次内包裹的处理等需求
    @RequestMapping(value="/sendWms/wavenum/report",method = RequestMethod.POST)
    public BaseJsonVo<ReturnorderCreateResponse> wavenumReport(HttpServletRequest request, @RequestBody ReturnorderCreateRequest req);
    //taobao.qimen.itemlack.report  发货单缺货通知接口 WMS调用奇门的接口,将商家在库某商品缺货的信息回传给ERP
    @RequestMapping(value="/sendWms/itemlack/report",method = RequestMethod.POST)
    public BaseJsonVo<ItemlackReportResponse > itemlackReport(HttpServletRequest request, @RequestBody ItemlackReportRequest req);
    //taobao.qimen.orderexception.report 订单异常通知接口 WMS调用奇门的接口,当WMS接收到ERP的发货指令时，由于种种原因（5.1.5说明了各种异常场景）可能无法完成发货。WMS通过调用此接口，通知ERP具体异常情况
    @RequestMapping(value="/sendWms/orderexception/report",method = RequestMethod.POST)
    public BaseJsonVo<OrderexceptionReportResponse  > orderexceptionRreport(HttpServletRequest request, @RequestBody OrderexceptionReportRequest req);
    //taobao.qimen.returnpackage.report  退货包裹状态通知接口
    @RequestMapping(value="/sendWms/returnpackage/report",method = RequestMethod.POST)
    public BaseJsonVo<ReturnpackageReportResponse > returnpackageReport(HttpServletRequest request, @RequestBody ReturnpackageReportRequest req);
    //taobao.qimen.receiverinfo.query OAID 收件人信息解密接口 WMS 调用该接口，通过 OAID 查询解密后的收件人信息
    @RequestMapping(value="/sendWms/receiverinfo/query",method = RequestMethod.POST)
    public BaseJsonVo<ReceiverinfoQueryResponse  > receiverinfoQuery(HttpServletRequest request, @RequestBody ReceiverinfoQueryRequest req);
*/
}
