/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.sys.entity.util.domain;

import cc.lechun.framework.common.utils.serviceresult.Message;
import cc.lechun.sys.entity.bo.FormatConfBO;
import cc.lechun.sys.entity.util.domain.BillPrint;
import cc.lechun.sys.entity.util.domain.PreGetBillPDF;
import cc.lechun.sys.entity.util.domain.print.ThreeSections;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.Table;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;

public class GetBillPDF
extends PreGetBillPDF {
    private BillPrint billPrint;

    public GetBillPDF(Collection<FormatConfBO> gridconfs, BillPrint billPrint) {
        super(gridconfs);
        this.billPrint = billPrint;
    }

    public Message createPDF(OutputStream outputStream) {
        Message message = new Message(true, "");
        try {
            Document document = this.getDocument(outputStream);
            this.addTitle(document);
            this.addHead(document);
            this.addBody(document);
            this.addRemark(document);
            this.addFoot(document);
            this.print(document);
        }
        catch (Exception e) {
            e.printStackTrace();
            message.setSuccess(false);
            message.setMsg("PDF\u751f\u6210\u5931\u8d25.Error - " + e.getMessage());
        }
        return message;
    }

    public Iterable getData() {
        return this.billPrint.getIterable();
    }

    @Override
    public Table getHeadCell() throws IOException {
        return this.getTableHead(this.billPrint.getQuery());
    }

    @Override
    public LinkedList<ThreeSections.Entry> getHead() {
        return this.billPrint.getHeads();
    }

    @Override
    public ThreeSections.Entry getTitle() {
        return this.billPrint.getTitle();
    }

    @Override
    public LinkedList<ThreeSections.Entry> getFoot() {
        return this.billPrint.getFoots();
    }

    @Override
    public LinkedList<ThreeSections.Entry> getRemark() {
        return this.billPrint.getRemarks();
    }

    @Override
    public PdfFont getFont() throws IOException {
        String url = this.billPrint.getFontPath();
        if (StringUtils.isBlank((CharSequence)url)) {
            return PdfFontFactory.createFont();
        }
        String encoding = this.billPrint.getFontEncoding();
        if (StringUtils.isBlank((CharSequence)encoding)) {
            encoding = "Identity-H";
        }
        return PdfFontFactory.createFont((String)url, (String)encoding);
    }

    @Override
    public float[] colWidths_head() {
        return this.billPrint.getColWidths_head();
    }

    @Override
    public float[] colWidths_foot() {
        return this.billPrint.getColWidths_foot();
    }

    @Override
    public float[] colWidths_remark() {
        return this.billPrint.getColWidths_remark();
    }

    @Override
    public int colWidths_data() {
        return this.billPrint.getColWidths_data();
    }
}

