/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.sys.entity.print;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.sys.entity.bo.FormatConfBO;
import cc.lechun.sys.entity.print.util.SetAndGet;
import cc.lechun.sys.entity.print.util.ThreeSections;
import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.border.SolidBorder;
import com.itextpdf.layout.element.BlockElement;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.property.HorizontalAlignment;
import com.itextpdf.layout.property.TextAlignment;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;

public abstract class PrePrinter<E>
implements ThreeSections {
    private Collection<FormatConfBO> gridconfs;
    private LinkedList<String> cols = new LinkedList();

    public PrePrinter() {
    }

    public PrePrinter(Collection<FormatConfBO> gridconfs) {
        this.gridconfs = gridconfs;
    }

    @Override
    public Table initDiv(float[] columnWidths) {
        Table table = new Table(columnWidths);
        ((Table)table.setBorder(Border.NO_BORDER)).setFontColor(Color.BLACK);
        ((Table)((Table)table.setWidthPercent(100.0f)).setTextAlignment(TextAlignment.LEFT)).setHorizontalAlignment(HorizontalAlignment.LEFT);
        return table;
    }

    Table initHead(float[] columnWidths) {
        Table table = this.initDiv(columnWidths);
        return table;
    }

    @Override
    public Document addTitle(Document itextdoc) throws IOException {
        Table table = this.entryTitleTable(this.getTitle(), 1);
        if (table == null) {
            return itextdoc;
        }
        itextdoc.add((BlockElement)table);
        return itextdoc;
    }

    @Override
    public Document addHead(Document itextdoc) throws IOException {
        Table table = this.entryTable(this.getHead(), this.colWidths_head());
        if (table == null) {
            return itextdoc;
        }
        itextdoc.add((BlockElement)table);
        return itextdoc;
    }

    @Override
    public Table initBody(int columnWidths) {
        Table table = new Table(columnWidths);
        ((Table)((Table)table.setWidthPercent(100.0f)).setTextAlignment(TextAlignment.CENTER)).setHorizontalAlignment(HorizontalAlignment.CENTER);
        return table;
    }

    Table initFoot(float[] columnWidths) {
        Table table = this.initDiv(columnWidths);
        return table;
    }

    @Override
    public Document addFoot(Document itextdoc) throws IOException {
        Table table = this.entryTable(this.getFoot(), this.colWidths_foot());
        if (table == null) {
            return itextdoc;
        }
        itextdoc.add((BlockElement)table);
        return itextdoc;
    }

    public Document addRemark(Document itextdoc) throws IOException {
        Table table = this.entryTable(this.getRemark(), this.colWidths_remark());
        if (table == null) {
            return itextdoc;
        }
        itextdoc.add((BlockElement)table);
        return itextdoc;
    }

    Table entryTitleTable(ThreeSections.Entry entry, int colWidth) throws IOException {
        PdfFont font = this.getFont();
        Table table = new Table(colWidth);
        ((Table)table.setBorder(Border.NO_BORDER)).setFontColor(Color.BLACK);
        ((Table)((Table)table.setWidthPercent(100.0f)).setTextAlignment(TextAlignment.CENTER)).setHorizontalAlignment(HorizontalAlignment.CENTER);
        String name = entry.getName();
        Cell cell = (Cell)new Cell().add((BlockElement)((Paragraph)((Paragraph)new Paragraph(name).setTextAlignment(TextAlignment.CENTER)).setFont(font)).setFontSize(20.0f)).setBorder(Border.NO_BORDER);
        table.addCell(cell);
        return table;
    }

    Table entryTable(LinkedList<ThreeSections.Entry> entries, float[] colWidths) throws IOException {
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        if (colWidths == null || colWidths.length == 0) {
            return null;
        }
        PdfFont font = this.getFont();
        Table table = this.initHead(colWidths);
        for (ThreeSections.Entry e : entries) {
            String name = e.getName();
            if (StringUtils.isBlank((CharSequence)name)) {
                name = " ";
            }
            Cell cell = (Cell)new Cell().add((BlockElement)((Paragraph)((Paragraph)new Paragraph(name).setTextAlignment(TextAlignment.LEFT)).setFont(font)).setFontSize(10.0f)).setBorder(Border.NO_BORDER);
            table.addCell(cell);
            String v = e.getValue();
            if (v == null || "".equals(v)) {
                v = " ";
            }
            Cell cell1 = (Cell)new Cell().add((BlockElement)((Paragraph)((Paragraph)new Paragraph(v).setTextAlignment(TextAlignment.LEFT)).setFont(font)).setFontSize(10.0f)).setBorder(Border.NO_BORDER);
            table.addCell(cell1);
        }
        if (colWidths.length == 0) {
            return null;
        }
        return table;
    }

    public Table getTableHead(ThreeSections.Query query) throws IOException {
        Collection<FormatConfBO> gridconfs = this.gridconfs;
        ArrayList<FormatConfBO> confs = new ArrayList<FormatConfBO>();
        confs.addAll(gridconfs);
        if (gridconfs == null || gridconfs.isEmpty()) {
            return null;
        }
        int i = 0;
        int size = confs.size();
        float[] columnWidths = new float[size];
        LinkedList<Cell> cells = new LinkedList<Cell>();
        PdfFont headerFont = this.getFont();
        for (FormatConfBO vo : confs) {
            String colName = vo.getColumnName();
            String col = vo.getColumnid();
            if (StringUtils.isBlank((CharSequence)colName) || StringUtils.isBlank((CharSequence)col)) continue;
            Cell cell = new Cell().add((BlockElement)new Paragraph(colName));
            ((Cell)((Cell)((Cell)cell.setFont(headerFont)).setBold()).setBorder((Border)new SolidBorder(Color.BLACK, 0.5f))).setFontSize(10.0f);
            cells.add(cell);
            columnWidths[i++] = colName.length();
            this.cols.add(col);
        }
        int col_data = this.colWidths_data();
        Table headCell = this.initBody(col_data);
        for (Cell cell : cells) {
            headCell.addHeaderCell(cell);
        }
        return headCell;
    }

    public abstract Iterable<E> getData();

    public abstract Table getHeadCell() throws IOException;

    public abstract LinkedList<ThreeSections.Entry> getHead();

    public abstract ThreeSections.Entry getTitle();

    public abstract LinkedList<ThreeSections.Entry> getFoot();

    public abstract LinkedList<ThreeSections.Entry> getRemark();

    @Override
    public Document addBody(Document itextdoc) throws Exception {
        Table table = this.getHeadCell();
        if (table == null) {
            return itextdoc;
        }
        Iterable<E> iterable = this.getData();
        if (iterable == null) {
            return itextdoc;
        }
        if (this.cols.isEmpty()) {
            return itextdoc;
        }
        PdfFont bodyFont = this.getFont();
        PropertyDescriptor descriptor = null;
        for (E e : iterable) {
            for (String str : this.cols) {
                Object get;
                Field field;
                if (StringUtils.isBlank((CharSequence)str)) continue;
                try {
                    field = e.getClass().getDeclaredField(str);
                }
                catch (NoSuchFieldException ex) {
                    Class<?> supercls = e.getClass().getSuperclass();
                    if (supercls == null) {
                        throw new RuntimeException(ex);
                    }
                    field = supercls.getDeclaredField(str);
                }
                SetAndGet setAndGet = field.getAnnotation(SetAndGet.class);
                if (setAndGet != null) {
                    get = setAndGet.getMethod();
                    String set = setAndGet.setMethod();
                    descriptor = new PropertyDescriptor(str, e.getClass(), (String)get, set);
                } else {
                    try {
                        descriptor = new PropertyDescriptor(str, e.getClass());
                    }
                    catch (Exception e2) {
                        StringBuffer sb = new StringBuffer();
                        Method setMethod = null;
                        Method getMethod = null;
                        try {
                            Field f = e.getClass().getDeclaredField(str);
                            if (f != null) {
                                String methodEnd = str.substring(0, 1) + str.substring(1);
                                sb.append("set" + methodEnd);
                                setMethod = e.getClass().getDeclaredMethod(sb.toString(), f.getType());
                                sb.delete(0, sb.length());
                                sb.append("get" + methodEnd);
                                getMethod = e.getClass().getDeclaredMethod(sb.toString(), new Class[0]);
                                descriptor = new PropertyDescriptor(str, getMethod, setMethod);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                get = descriptor.getReadMethod();
                Object v = ((Method)get).invoke(e, new Object[0]);
                if (v instanceof Date) {
                    v = DateUtils.formatDate((Date)((Date)v), (String)"");
                }
                Cell cell = new Cell().add((BlockElement)new Paragraph(v == null ? "" : v.toString()));
                ((Cell)((Cell)cell.setFont(bodyFont)).setBorder((Border)new SolidBorder(Color.BLACK, 0.5f))).setFontSize(8.0f);
                table.addCell(cell);
            }
        }
        itextdoc.add((BlockElement)table);
        return itextdoc;
    }

    @Override
    public Document getDocument(OutputStream outputStream) throws IOException {
        PdfDocument pdfDocument = new PdfDocument(new PdfWriter(outputStream));
        return new Document(pdfDocument);
    }

    @Override
    public void print(Document itextdoc) throws IOException {
        if (itextdoc == null) {
            throw new NullPointerException("\u9700\u8981\u5148\u5b9e\u4f8b\u5316#com.itextpdf.layout.Document\u5bf9\u8c61");
        }
        itextdoc.flush();
        itextdoc.close();
    }

    public LinkedList<String> getCols() {
        return this.cols;
    }

    public PrePrinter setCols(LinkedList<String> cols) {
        this.cols = cols;
        return this;
    }
}

