### <center>**#订单类PDF生成工具使用说明**</center>

#### #PDF模块共计三个部分
- 单据头信息
- 数据表信息 [#含备注]
- 单据底单信息 如制单人/发货人签字等

单据HEAD和Foot信息以及备注都是一个没有Border的Table. 支持自定义列宽, 如:
> 销售业务员: 张三  这里可以认为是两列也可以认为是一列 , 只是需要注意对应列宽即可

HEAD/Foot/备注的信息组织规则都是一致的, 以下是HEAD信息组织举例:
```java

//获取字体文件path, 可以通过jdk resoure接口获取, 只要path正确即可
//如果不指定字体则,中文显示可能会异常
String font = "/home/palm/myapps/projects/intelligent-built-web/cloud-erp/src/main/resources/Noto/NotoSerifCJKsc-hinted/NotoSerifCJKsc-Black.otf" ;

//需要展示的列表数据
List<SalesOrder> list = salesOrderService.findInfoByParams(0, 0, params);

// OrderPrint对象包含很多自定义设置, 需要先实例化这个对象; 
//也可以使用无参构造实例化
//ThreeSections.Query 对象为中间数据列表的表头数据查询参数对象, 数据从grid配置表中获取
OrderPrint<SalesOrder> orderPrint = 
new OrderPrint(new ThreeSections.Query(user.getCguid(),user.getCtenantid(), 1,"jqGrid_saleOrder_List")) ;

//设置数据/字体和该字体对应编码
//该对象全部类set方法都支持链式调用
orderPrint.setIterable(list).setFontPath(font).setFontEncoding(PdfEncodings.IDENTITY_H);

//组织HEAD信息并设置到对象中为单据头pdf生成准备数据
OrderPrint.Type HEAD = OrderPrint.Type.HEAD ;
orderPrint.addEntry("客户:",0,"河北钢铁",0, HEAD).
	addEntry("销售业务员:",0,"张三",0,HEAD).
	addEntry("单据日期:",0,"2017-07-12",0,HEAD).
	addEntry("交货日期:",0,"2017-07-12",0,HEAD).
	addEntry("单据编码:",0,"XSDD-20170712-004",0,HEAD) ;

//也可以自己组织对象ThreeSections.Entry然后调用如下方法
orderPrint.addEntry(new ThreeSections.Entry("客户:",0,"河北钢铁",0), OrderPrint.Type.HEAD) ;

//设置各个 table的列宽
float[] head = new float[]{3,6,3,6,3,6} ;
float[] data = new float[]{4,4,2,4,4,2,2,3,3,4,4,3,3} ;

float[] mark = new float[]{3,rm.length()} ;

float[] foot = {40,35,25};

//set columnWidths
orderPrint.setColWidths_head(head).setColWidths_foot(foot).
setColWidths_remark(mark).setColWidths_data(data) ;

//生成pdf然后输出到指定目的地,  当前为ServletOutputStream
GetOrderPDF getOrderPDF = new GetOrderPDF(tenantService,orderPrint) ;
getOrderPDF.createPDF(response.getOutputStream()) ;

response.setCharacterEncoding("UTF-8");
response.setContentType("application/pdf");

```

#### #效果
![Alt text](part1.png)
![Alt text](part2.png)
