/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.sys.util;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBigDataExport<T> {
    private Logger log = LoggerFactory.getLogger(MyBigDataExport.class);

    public void export(HttpServletRequest request, HttpServletResponse response, Class<T> pojoClass, MyExportMehtod<T> myExportMehtod, String filename) {
        try {
            Workbook workbook = null;
            filename = StringUtils.isBlank((CharSequence)filename) ? "export.xlsx" : filename + ".xlsx";
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.setHeader("Content-disposition", "attachment;filename=" + filename);
            ExportParams exportParams = new ExportParams();
            exportParams.setType(ExcelType.XSSF);
            boolean flag = true;
            int start = 0;
            int rows = 2000;
            int sum = 0;
            List<Object> list = new ArrayList();
            while (flag) {
                list = myExportMehtod.getMyBigData(request, start * rows, rows);
                if (list == null || list.size() == 0) {
                    flag = false;
                    break;
                }
                this.log.info("\u7b2c" + start + "\u9875\u6570\u636e \u6bcf\u9875\u6240" + rows + "\u6761,\u5b9e\u9645\u6bcf\u9875\u591a" + (list != null ? list.size() : 0) + "\u6761 ,\u603b\u5171 " + (sum += list.size()) + "\u6761");
                workbook = ExcelExportUtil.exportBigExcel((ExportParams)exportParams, pojoClass, list);
                list.clear();
                ++start;
            }
            workbook.write((OutputStream)response.getOutputStream());
            ExcelExportUtil.closeExportBigExcel();
        }
        catch (Exception e) {
            this.log.error("\u5bfc\u51fa\u5f02\u5e38\uff1a{}", (Throwable)e);
            ExcelExportUtil.closeExportBigExcel();
        }
    }

    public void exportMapAllDatas(HttpServletRequest request, HttpServletResponse response, List<Map<String, Object>> llstMap, String titile, String filename) {
        try {
            Workbook workbook = null;
            filename = StringUtils.isBlank((CharSequence)filename) ? "export.xlsx" : filename + ".xlsx";
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.setHeader("Content-disposition", "attachment;filename=" + filename);
            boolean flag = true;
            int start = 1;
            int rows = 10000;
            ArrayList<ExcelExportEntity> colList = new ArrayList<ExcelExportEntity>();
            Map<String, Object> mapObj = null;
            int max = 0;
            for (Map<String, Object> map : llstMap) {
                if (map.size() <= max) continue;
                mapObj = map;
                max = map.size();
            }
            if (mapObj != null && mapObj.size() > 0) {
                for (Map.Entry entry : mapObj.entrySet()) {
                    colList.add(new ExcelExportEntity((String)entry.getKey(), entry.getKey()));
                }
            }
            while (flag) {
                List<Map<String, Object>> list = this.grouByLowSize(llstMap, start, rows);
                ExportParams exportParams = new ExportParams(titile, titile);
                exportParams.setType(ExcelType.XSSF);
                workbook = ExcelExportUtil.exportBigExcel((ExportParams)exportParams, colList, list);
                this.log.info("\u7b2c" + start + "\u9875\u6570\u636e \u6bcf\u9875\u6240" + rows + "\u6761,\u5b9e\u9645\u6bcf\u9875\u591a" + (list != null ? list.size() : 0) + "\u6761");
                if (list == null || list.size() < rows) {
                    flag = false;
                    break;
                }
                ++start;
            }
            llstMap.clear();
            workbook.write((OutputStream)response.getOutputStream());
            ExcelExportUtil.closeExportBigExcel();
        }
        catch (Exception e) {
            this.log.error("\u5bfc\u51fa\u5f02\u5e38\uff1a{}", (Throwable)e);
            ExcelExportUtil.closeExportBigExcel();
        }
    }

    private List<Map<String, Object>> grouByLowSize(List<Map<String, Object>> list, int start, int pagesize) {
        int totalcount = list.size();
        int pagecount = 0;
        int m = totalcount % pagesize;
        pagecount = m > 0 ? totalcount / pagesize + 1 : totalcount / pagesize;
        List<Map<String, Object>> subList = new ArrayList<Map<String, Object>>();
        if (start > pagecount) {
            return subList;
        }
        subList = m == 0 ? list.subList((start - 1) * pagesize, pagesize * start) : (start == pagecount ? list.subList((start - 1) * pagesize, totalcount) : list.subList((start - 1) * pagesize, pagesize * start));
        return subList;
    }

    public static interface MyExportMehtod<T> {
        public List<T> getMyBigData(HttpServletRequest var1, int var2, int var3);
    }
}

