/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.sys.util.lock;

import cc.lechun.framework.common.utils.serviceresult.LogUtil;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.sys.entity.log.MyLogEntity;
import cc.lechun.sys.util.lock.reids.Lock;
import cc.lechun.sys.util.lock.reids.Opertion;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class MyLockDomain {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private LogUtil logUtil;
    @Resource
    private Lock lock;

    @Transactional(rollbackFor={Exception.class})
    public <T> BaseJsonVo<T> opertion(final String orderNo, String module, String function, String operation, final LockOpertion<T> domwan) {
        T t = domwan.find(orderNo);
        BaseJsonVo baseJsonVo = domwan.checkBefore(t);
        if (baseJsonVo.getStatus() == 200) {
            baseJsonVo = (BaseJsonVo)this.lock.myLock(domwan.getKey(t), new Opertion<BaseJsonVo<T>>(){

                @Override
                public BaseJsonVo<T> runMethod() throws Exception {
                    Object find = domwan.find(orderNo);
                    return domwan.opertion(find);
                }
            });
        }
        MyLogEntity mylog = new MyLogEntity();
        mylog.setModule(module);
        mylog.setFunction(function);
        mylog.setOperation(operation);
        if (orderNo.equals(domwan.getKey(t))) {
            mylog.setCode(orderNo);
        } else {
            mylog.setCode(orderNo + "-" + domwan.getKey(t));
        }
        mylog.setDescription("\u64cd\u4f5c\u6210\u529f");
        if (null == baseJsonVo || baseJsonVo.getStatus() != 200) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            mylog.setDescription("\u64cd\u4f5c\u6210\u529f\u5931\u8d25:" + baseJsonVo.getMessage());
        }
        this.logger.info(this.logUtil.getQueryMarker(), this.logUtil.getColumn4(), this.logUtil.setLoggerContent(mylog.toString()));
        return baseJsonVo;
    }

    public static interface LockOpertion<T> {
        public T find(String var1);

        public String getKey(T var1);

        public BaseJsonVo<T> checkBefore(T var1);

        public BaseJsonVo<T> opertion(T var1);
    }
}

