/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.sys.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.Charsets;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class APIUtils {
    public static final String WEBSITE = "https://www.jiandaoyun.com";
    private boolean retryIfRateLimited = true;
    private String urlGetWidgets;
    private String urlGetFormData;
    private String urlRetrieveData;
    private String urlUpdateData;
    private String urlCreateData;
    private String urlDeleteData;
    private String apiKey;

    public APIUtils(String appId, String entryId, String apiKey) {
        this.apiKey = apiKey;
        this.initUrl(appId, entryId);
    }

    private void initUrl(String appId, String entryId) {
        this.urlGetWidgets = "https://www.jiandaoyun.com/api/v1/app/" + appId + "/entry/" + entryId + "/widgets";
        this.urlGetFormData = "https://www.jiandaoyun.com/api/v1/app/" + appId + "/entry/" + entryId + "/data";
        this.urlRetrieveData = "https://www.jiandaoyun.com/api/v1/app/" + appId + "/entry/" + entryId + "/data_retrieve";
        this.urlUpdateData = "https://www.jiandaoyun.com/api/v1/app/" + appId + "/entry/" + entryId + "/data_update";
        this.urlCreateData = "https://www.jiandaoyun.com/api/v1/app/" + appId + "/entry/" + entryId + "/data_create";
        this.urlDeleteData = "https://www.jiandaoyun.com/api/v1/app/" + appId + "/entry/" + entryId + "/data_delete";
    }

    public HttpClient getSSLHttpClient() throws Exception {
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        }).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
    }

    public Header[] getHttpHeaders() {
        ArrayList<BasicHeader> headerList = new ArrayList<BasicHeader>();
        headerList.add(new BasicHeader("Authorization", "Bearer " + this.apiKey));
        headerList.add(new BasicHeader("Content-Type", "application/json;charset=utf-8"));
        return headerList.toArray(new Header[headerList.size()]);
    }

    public Object sendRequest(String method, String url, Map<String, Object> data) throws Exception {
        HttpPost request;
        HttpClient client = this.getSSLHttpClient();
        Header[] headers = this.getHttpHeaders();
        if ("GET".equals(method = method.toUpperCase())) {
            URIBuilder uriBuilder = new URIBuilder(url);
            if (data != null) {
                for (Map.Entry<String, Object> entry : data.entrySet()) {
                    uriBuilder.addParameter(entry.getKey(), (String)entry.getValue());
                }
            }
            request = new HttpGet(uriBuilder.build());
        } else if ("POST".equals(method)) {
            request = new HttpPost(url);
            ObjectMapper mapper = new ObjectMapper();
            StringEntity entity = new StringEntity(mapper.writeValueAsString(data), Charsets.UTF_8);
            request.setEntity((HttpEntity)entity);
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684HTTP\u52a8\u8bcd");
        }
        request.setHeaders(headers);
        HttpResponse response = client.execute((HttpUriRequest)request);
        int statusCode = response.getStatusLine().getStatusCode();
        ObjectMapper mapper = new ObjectMapper();
        Map result = (Map)mapper.readValue(response.getEntity().getContent(), Object.class);
        if (statusCode >= 400) {
            if ((Integer)result.get("code") == 8303 && this.retryIfRateLimited) {
                Thread.sleep(5000L);
                return this.sendRequest(method, url, data);
            }
            throw new RuntimeException("\u8bf7\u6c42\u9519\u8bef\uff0cError Code: " + result.get("code") + ", Error Msg: " + result.get("msg"));
        }
        return result;
    }

    public List<Map<String, Object>> getFormWidgets() {
        List widgets = null;
        try {
            Map result = (Map)this.sendRequest("POST", this.urlGetWidgets, new HashMap<String, Object>());
            widgets = (List)result.get("widgets");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return widgets;
    }

    public List<Map<String, Object>> getFormData(final int limit, final String[] fields, final Map<String, Object> filter, String dataId) {
        List data = null;
        try {
            HashMap<String, Object> requestData = new HashMap<String, Object>(){
                {
                    this.put("limit", limit);
                    this.put("fields", fields);
                    this.put("filter", filter);
                }
            };
            if (dataId != null) {
                requestData.put("data_id", dataId);
            }
            Map result = (Map)this.sendRequest("POST", this.urlGetFormData, (Map<String, Object>)requestData);
            data = (List)result.get("data");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public List<Map<String, Object>> getAllFormData(String[] fields, Map<String, Object> filter) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        String offset = null;
        do {
            List<Map<String, Object>> data;
            if ((data = this.getFormData(100, fields, filter, offset)) == null || data.isEmpty()) {
                offset = null;
                continue;
            }
            offset = (String)data.get(data.size() - 1).get("_id");
            dataList.addAll(data);
        } while (offset != null);
        return dataList;
    }

    public Map<String, Object> retrieveData(String dataId) {
        Map data = null;
        try {
            HashMap<String, Object> requestData = new HashMap<String, Object>();
            requestData.put("data_id", dataId);
            Map result = (Map)this.sendRequest("POST", this.urlRetrieveData, requestData);
            data = (Map)result.get("data");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public Map<String, Object> createData(Map<String, Object> rawData) {
        Map data = null;
        try {
            HashMap<String, Object> requestData = new HashMap<String, Object>();
            requestData.put("data", rawData);
            Map result = (Map)this.sendRequest("POST", this.urlCreateData, requestData);
            data = (Map)result.get("data");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public Map<String, Object> updateData(String dataId, Map<String, Object> update) {
        Map data = null;
        try {
            HashMap<String, Object> requestData = new HashMap<String, Object>();
            requestData.put("data_id", dataId);
            requestData.put("data", update);
            Map result = (Map)this.sendRequest("POST", this.urlUpdateData, requestData);
            data = (Map)result.get("data");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public Map<String, String> deleteData(String dataId) {
        Map result = null;
        try {
            HashMap<String, Object> requestData = new HashMap<String, Object>();
            requestData.put("data_id", dataId);
            result = (Map)this.sendRequest("POST", this.urlDeleteData, requestData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

