/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.sys.base;

import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.core.baseclass.BaseDao;
import cc.lechun.sys.base.BaseService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseServiceImpl<T, PK extends Serializable>
implements BaseService<T, PK> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected BaseDao<T, PK> baseDao;
    @Resource
    protected RedisCacheUtil redisCacheUtil;
    protected String className = this.getClass().getName();
    protected String cachKey = this.className + "_setCache";

    @Override
    public String getCachKey() {
        return this.cachKey;
    }

    @Override
    public int deleteByPrimaryKey(PK var1) {
        this.removeCache();
        return this.baseDao.deleteByPrimaryKey(var1);
    }

    @Override
    public int insert(T var1) {
        this.removeCache();
        return this.baseDao.insert(var1);
    }

    @Override
    public int insertSelective(T var1) {
        this.removeCache();
        return this.baseDao.insertSelective(var1);
    }

    @Override
    public T selectByPrimaryKey(PK var1) {
        String key = this.className + "selectByPrimaryKey" + var1;
        Object o = this.redisCacheUtil.get(key);
        if (o != null) {
            return (T)o;
        }
        Object t = this.baseDao.selectByPrimaryKey(var1);
        if (t != null) {
            this.redisCacheUtil.set(key, t, Long.valueOf(1800L));
        }
        return (T)t;
    }

    @Override
    public List<T> getList(T var1) {
        String key = this.className + "getList" + var1.hashCode();
        Object o = this.redisCacheUtil.get(key);
        if (o != null) {
            return (List)o;
        }
        List t = this.baseDao.getList(var1);
        if (t != null && t.size() > 0) {
            this.redisCacheUtil.set(key, (Object)t, Long.valueOf(100L));
        }
        return t;
    }

    @Override
    public int updateByPrimaryKeySelective(T var1) {
        this.removeCache();
        return this.baseDao.updateByPrimaryKeySelective(var1);
    }

    @Override
    public int updateByPrimaryKey(T var1) {
        this.removeCache();
        return this.baseDao.updateByPrimaryKey(var1);
    }

    @Override
    public int existsByEntity(T var1) {
        Integer t = this.baseDao.existsByEntity(var1);
        return t;
    }

    @Override
    public int exists(PK var1) {
        Integer t = this.baseDao.exists(var1);
        return t;
    }

    @Override
    public T getSingle(T var1) {
        String key = this.className + "getSingle" + var1.hashCode();
        Object o = this.redisCacheUtil.get(key);
        if (o != null) {
            return (T)o;
        }
        Object t = this.baseDao.getSingle(var1);
        if (t != null) {
            this.redisCacheUtil.set(key, t, Long.valueOf(1800L));
        }
        return (T)t;
    }

    public void removeCache() {
        this.redisCacheUtil.removePattern(this.className + "*");
    }
}

