/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.api;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Enumeration;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import weixin.popular.api.BaseAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.payservice.StaffInfo;
import weixin.popular.bean.payservice.StaffResult;
import weixin.popular.client.LocalHttpClient;

public class PayServiceAPI
extends BaseAPI {
    public static StaffResult regGuides(String store_id, String corpid, String name, String mobile, String qr_code, String sub_mchid, String avatar, String userid, String certPath) throws Exception {
        logger.info("\u63a5\u6536\u53c2\u6570:store_id={},corpid={},name={},mobile={},qr_code={},sub_mchid={},avatar={},userid={},certPath={}", new Object[]{store_id, corpid, name, mobile, qr_code, sub_mchid, avatar, userid, certPath});
        name = PayServiceAPI.encryBody(name, certPath);
        mobile = PayServiceAPI.encryBody(mobile, certPath);
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.mch.weixin.qq.com/v3/smartguide/guides").addParameter("sub_mchid", sub_mchid).addParameter("corpid", corpid).addParameter("store_id", store_id).addParameter("userid", userid).addParameter("name", name).addParameter("mobile", mobile).addParameter("qr_code", qr_code).addParameter("avatar", avatar).build();
        logger.info("request:{},{}", (Object)httpUriRequest, (Object)httpUriRequest.getURI().toURL());
        return LocalHttpClient.executeJsonResult(httpUriRequest, StaffResult.class);
    }

    public static BaseResult setAssign(String guide_id, String sub_mchid, String out_trade_no) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.mch.weixin.qq.com" + "/v3/smartguide/guides/{guide_id}/assign".replace("{guide_id}", guide_id)).addParameter("sub_mchid", sub_mchid).addParameter("out_trade_no", out_trade_no).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static StaffInfo getStaff(String access_token, String userId) {
        logger.info("\u67e5\u627e\u5458\u5de5\u4fe1\u606f:{}", (Object)("https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token=" + access_token + "&userid=" + userId));
        HttpUriRequest httpUriRequest = RequestBuilder.get().setUri("https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token=" + access_token + "&userid=" + userId).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, StaffInfo.class);
    }

    public static X509Certificate loadCertificate2(InputStream inputStream) {
        try {
            CertificateFactory e = CertificateFactory.getInstance("X509");
            X509Certificate cert = (X509Certificate)e.generateCertificate(inputStream);
            cert.checkValidity();
            return cert;
        }
        catch (CertificateExpiredException var3) {
            throw new RuntimeException("\u8bc1\u4e66\u5df2\u8fc7\u671f", var3);
        }
        catch (CertificateNotYetValidException var4) {
            throw new RuntimeException("\u8bc1\u4e66\u5c1a\u672a\u751f\u6548", var4);
        }
        catch (CertificateException var5) {
            throw new RuntimeException("\u65e0\u6548\u7684\u8bc1\u4e66", var5);
        }
    }

    public static X509Certificate getX509Certificate(FileInputStream bais) {
        PublicKey pk = null;
        try {
            CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509");
            logger.info("\u521d\u59cb\u5316:{}", (Object)certificatefactory);
            logger.info("\u521d\u59cb\u5316FileInputStream:{}", (Object)bais);
            X509Certificate cert = (X509Certificate)certificatefactory.generateCertificate(bais);
            pk = cert.getPublicKey();
            logger.info("\u516c\u94a5:{}", (Object)cert.getPublicKey());
            X509Certificate x509Certificate = cert;
            return x509Certificate;
        }
        catch (CertificateExpiredException var3) {
            throw new RuntimeException("\u8bc1\u4e66\u5df2\u8fc7\u671f", var3);
        }
        catch (CertificateNotYetValidException var4) {
            throw new RuntimeException("\u8bc1\u4e66\u5c1a\u672a\u751f\u6548", var4);
        }
        catch (CertificateException e) {
            logger.error("\u65e0\u6548\u7684\u8bc1\u4e66", (Throwable)e);
            e.printStackTrace();
            throw new RuntimeException("\u65e0\u6548\u7684\u8bc1\u4e66", e);
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String rsaEncryptOAEP(String message, X509Certificate certificate) throws IllegalBlockSizeException, IOException {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(1, certificate.getPublicKey());
            byte[] data = message.getBytes("utf-8");
            byte[] cipherdata = cipher.doFinal(data);
            return Base64.getEncoder().encodeToString(cipherdata);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301RSA v1.5/OAEP", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u8bc1\u4e66", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalBlockSizeException("\u52a0\u5bc6\u539f\u4e32\u7684\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7214\u5b57\u8282");
        }
    }

    private static String encryBody(String message, String certPath) {
        try {
            logger.info("\u521d\u59cb\u5316:KeyStore..");
            KeyStore ks = KeyStore.getInstance("PKCS12");
            logger.info("\u521d\u59cb\u5316:KeyStore..{}", (Object)ks.toString());
            FileInputStream fis = new FileInputStream(certPath);
            char[] nPassword = null;
            nPassword = "heht3prdb5qwxga4jhsb4drvxjqyn6ud".toCharArray();
            ks.load(fis, nPassword);
            fis.close();
            Enumeration<String> enuml = ks.aliases();
            String keyAlias = null;
            if (enuml.hasMoreElements()) {
                keyAlias = enuml.nextElement();
            }
            logger.info("\u521d\u59cb\u5316:Certificate..");
            Certificate cert = ks.getCertificate(keyAlias);
            logger.info("\u521d\u59cb\u5316\u5b8c\u6210:Certificate..{}", (Object)cert.toString());
            PublicKey pubkey = cert.getPublicKey();
            Cipher c1 = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            c1.init(1, pubkey);
            return Base64.getEncoder().encodeToString(c1.doFinal(message.getBytes("utf-8")));
        }
        catch (Exception ex) {
            logger.info("\u9519\u8bef\u6d88\u606f:{}", (Object)ex.getMessage());
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private static String decryBody(String keyValue) {
        try {
            return "";
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }
}

