/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.manager.config;

import com.aliyun.Context;
import com.aliyun.bean.common.ToolkitProfile;
import com.aliyun.manager.config.AbstractConfigManager;
import com.aliyun.utils.CommonUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class ToolkitProfileConfigManager
extends AbstractConfigManager<ToolkitProfile> {
    private MavenProject project = Context.getProject();
    private Log logger = Context.getLogger();

    public ToolkitProfileConfigManager() {
        super(false);
    }

    public ToolkitProfile loadProperties(String configFile, String defaultFile, String accessKeyId, String accessKeySecret) throws MojoExecutionException {
        try {
            ToolkitProfile profile = this.load(configFile, defaultFile, ToolkitProfile.class);
            if (accessKeyId != null && accessKeySecret != null) {
                profile.setAccessKeyId(accessKeyId);
                profile.setAccessKeySecret(accessKeySecret);
                this.logger.info((CharSequence)"Using AK/SK in command line");
            }
            if (profile.getRegionId() != null && profile.getRegionId().contains(":")) {
                this.logger.warn((CharSequence)"You set a namespaceId in toolkit profile, please consider replacing it with a physical region id.");
                int index = profile.getRegionId().indexOf(":");
                profile.setRegionId(profile.getRegionId().substring(0, index));
            }
            if (profile.getEndpoint() == null) {
                if (CommonUtils.Product.Edas.name().equalsIgnoreCase(profile.getProduct())) {
                    profile.setEndpoint("edas." + profile.getRegionId() + ".aliyuncs.com");
                } else if (CommonUtils.Product.Sae.name().equalsIgnoreCase(profile.getProduct())) {
                    profile.setEndpoint("sae." + profile.getRegionId() + ".aliyuncs.com");
                } else {
                    this.logger.warn((CharSequence)"Product settings only support edas and sae, using edas as default");
                    profile.setEndpoint("edas." + profile.getRegionId() + ".aliyuncs.com");
                }
            }
            return profile;
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
            throw new MojoExecutionException(ex.getMessage());
        }
    }
}

