/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mojo;

import com.aliyun.Context;
import com.aliyun.bean.common.BuildProfile;
import com.aliyun.bean.common.OssProfile;
import com.aliyun.bean.common.ToolkitProfile;
import com.aliyun.bean.config.DefaultConfigBean;
import com.aliyun.bean.config.ToolkitDeployConfig;
import com.aliyun.bean.config.ToolkitPackageConfig;
import com.aliyun.exception.ErrMsg;
import com.aliyun.manager.LoadConfigManager;
import com.aliyun.manager.config.DefaultConfigManager;
import com.aliyun.manager.config.ToolkitDeployConfigManager;
import com.aliyun.manager.config.ToolkitPackageConfigManager;
import com.aliyun.manager.config.ToolkitProfileConfigManager;
import com.aliyun.manager.deploy.ToolkitDeployManager;
import com.aliyun.utils.CommonUtils;
import com.aliyuncs.DefaultAcsClient;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.PACKAGE)
public class ToolkitDeployMojo
extends AbstractMojo {
    private static final String OLD_DEFAULT_DEPLOY_CONFIG_FILE = ".edas_config.yaml";
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="toolkit_profile")
    private String toolkitProfile;
    @Parameter(property="toolkit_deploy")
    private String toolkitDeploy;
    @Parameter(property="toolkit_package")
    private String toolkitPackage;
    @Parameter(property="edas_config")
    private String configFile;
    @Parameter(property="access_key_id")
    private String accessKeyId;
    @Parameter(property="access_key_secret")
    private String accessKeySecret;
    @Parameter(property="access_key_file")
    private String accessKeyFile;
    @Parameter(property="deploy_version")
    private String deployVersion;
    @Parameter(property="deploy_desc")
    private String deployDesc;
    @Parameter(property="deploy_artifacts")
    private String deployArtifacts;

    public void execute() throws MojoExecutionException {
        Log logger = this.getLog();
        Context.setLogger(logger);
        Context.setProject(this.project);
        if (!this.deployCurrentArtifact()) {
            return;
        }
        this.loadProperties();
        this.initAcsClient();
        this.deploy();
    }

    private void deploy() throws MojoExecutionException {
        try {
            ToolkitDeployManager deployManager = new ToolkitDeployManager();
            deployManager.deploy(Context.getToolkitDeployConfig(), Context.getToolkitPackageConfig());
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)ex.getMessage(), (Throwable)ex);
            throw new MojoExecutionException("Failed to deploy: " + ex.getMessage());
        }
    }

    private void initAcsClient() throws MojoExecutionException {
        try {
            DefaultAcsClient client = CommonUtils.initAcsClient(Context.getToolkitProfileConfig());
            Context.setAcsClient(client);
        }
        catch (Exception ex) {
            String msg = "Failed to init acs client: " + ex.getMessage();
            this.getLog().error((CharSequence)msg, (Throwable)ex);
            throw new MojoExecutionException(msg);
        }
    }

    private void transformAndSetContext(DefaultConfigBean oldConfig) throws Exception {
        DefaultConfigBean.Oss oss;
        DefaultConfigBean.App app = oldConfig.getApp();
        if (app == null) {
            app = new DefaultConfigBean.App();
            oldConfig.setApp(app);
        }
        if ((oss = oldConfig.getOss()) == null) {
            oss = new DefaultConfigBean.Oss();
            oldConfig.setOss(oss);
        }
        if (app.getAppId() == null) {
            throw new Exception("app_id is not defined in config file.");
        }
        ToolkitDeployConfig deployConfig = new ToolkitDeployConfig();
        deployConfig.setKind("AppDeployment");
        ToolkitDeployConfig.Spec spec = new ToolkitDeployConfig.Spec();
        if (CommonUtils.isNotEmpty(oldConfig.getApp()) && CommonUtils.isNotEmpty(oldConfig.getApp().getType())) {
            spec.setType(oldConfig.getApp().getType());
        } else {
            spec.setType("edas");
        }
        spec.setTarget(new ToolkitDeployConfig.Target());
        spec.getTarget().setAppId(app.getAppId());
        if (!Strings.isNullOrEmpty((String)this.deployVersion)) {
            spec.setVersion(this.deployVersion);
        } else {
            spec.setVersion(app.getPackageVersion());
        }
        spec.setBatchWaitTime(app.getBatchWaitTime());
        if (!Strings.isNullOrEmpty((String)this.deployDesc)) {
            spec.setDesc(this.deployDesc);
        } else {
            spec.setDesc(app.getDesc());
        }
        spec.setGroupId(app.getGroupId());
        spec.setBatch(app.getBatch());
        if (app.getAppEnv() != null) {
            ObjectMapper jsonMapper = new ObjectMapper();
            jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            List envs = (List)jsonMapper.readValue(app.getAppEnv(), (TypeReference)new TypeReference<List<ToolkitDeployConfig.Env>>(){});
            spec.setEnvs(envs);
        }
        spec.setStageTimeout(app.getStageTimeout());
        spec.setServiceStageTimeout(app.getServiceStageTimeout());
        spec.setInstanceStageTimeout(app.getInstanceStageTimeout());
        deployConfig.setSpec(spec);
        Context.setToolkitDeployConfig(deployConfig);
        ToolkitPackageConfig packageConfig = new ToolkitPackageConfig();
        packageConfig.setKind("AppPackage");
        packageConfig.setSpec(new ToolkitPackageConfig.Spec());
        packageConfig.getSpec().setImageUrl(app.getImageUrl());
        packageConfig.getSpec().setPackageUrl(app.getWarUrl());
        if (app.getImageUrl() != null) {
            packageConfig.getSpec().setPackageType("Image");
        } else {
            if ("pom".equalsIgnoreCase(this.project.getPackaging())) {
                throw new Exception(ErrMsg.getPomDeployErrMsg());
            }
            if ("jar".equalsIgnoreCase(this.project.getPackaging())) {
                packageConfig.getSpec().setPackageType("FatJar");
            } else if ("war".equalsIgnoreCase(this.project.getPackaging())) {
                packageConfig.getSpec().setPackageType("War");
            } else {
                throw new Exception("Unknown packaing: " + this.project.getPackaging());
            }
        }
        packageConfig.getSpec().setBuild(new BuildProfile());
        if (oss.getBucket() != null) {
            OssProfile ossProfile = new OssProfile();
            packageConfig.getSpec().getBuild().setOss(ossProfile);
            ossProfile.setBucket(oss.getBucket());
            ossProfile.setRegionId(oss.getRegionId());
            ossProfile.setAccessKeyId(oss.getAccessKeyId());
            ossProfile.setAccessKeySecret(oss.getAccessKeySecret());
            ossProfile.setKey(oss.getKey());
        }
        Context.setToolkitPackageConfig(packageConfig);
    }

    private boolean deployCurrentArtifact() {
        if (StringUtils.isNotBlank((String)this.deployArtifacts)) {
            boolean target = false;
            for (String artifact : this.deployArtifacts.split(",")) {
                if (!artifact.equals(this.project.getArtifactId())) continue;
                target = true;
                break;
            }
            if (!target) {
                return false;
            }
        }
        return true;
    }

    private void loadProperties() throws MojoExecutionException {
        try {
            File baseDir = this.project.getBasedir();
            this.transformConfigFilePath(baseDir.getAbsolutePath());
            String newDefaultDeployFile = baseDir.getPath() + CommonUtils.getFileSeparator() + ".toolkit_deploy.yaml";
            if (this.toolkitDeploy != null || new File(newDefaultDeployFile).exists()) {
                ToolkitDeployConfigManager deployConfigManager = new ToolkitDeployConfigManager();
                ToolkitDeployConfig deployConfig = deployConfigManager.loadProperties(this.toolkitDeploy, newDefaultDeployFile);
                if (!Strings.isNullOrEmpty((String)this.deployVersion)) {
                    deployConfig.getSpec().setVersion(this.deployVersion);
                }
                if (!Strings.isNullOrEmpty((String)this.deployDesc)) {
                    deployConfig.getSpec().setDesc(this.deployDesc);
                }
                Context.setToolkitDeployConfig(deployConfig);
                String defaultPackageFile = baseDir.getPath() + CommonUtils.getFileSeparator() + ".toolkit_package.yaml";
                ToolkitPackageConfigManager packageConfigManager = new ToolkitPackageConfigManager();
                ToolkitPackageConfig packageConfig = packageConfigManager.loadProperties(this.toolkitPackage, defaultPackageFile);
                if (packageConfig.getSpec().getBuild() == null) {
                    packageConfig.getSpec().setBuild(new BuildProfile());
                }
                Context.setToolkitPackageConfig(packageConfig);
            } else {
                String oldDefaultDeployFile = baseDir.getPath() + CommonUtils.getFileSeparator() + OLD_DEFAULT_DEPLOY_CONFIG_FILE;
                DefaultConfigManager defaultConfigManager = new DefaultConfigManager();
                DefaultConfigBean oldConfig = defaultConfigManager.loadProperties(this.configFile, oldDefaultDeployFile);
                this.transformAndSetContext(oldConfig);
            }
            ToolkitProfileConfigManager profileConfigManager = new ToolkitProfileConfigManager();
            ToolkitProfile profile = null;
            String defaultProfile = baseDir.getPath() + CommonUtils.getFileSeparator() + ".toolkit_profile.yaml";
            if (this.toolkitProfile != null || new File(defaultProfile).exists()) {
                profile = profileConfigManager.loadProperties(this.toolkitProfile, defaultProfile, this.accessKeyId, this.accessKeySecret);
            }
            if (profile == null) {
                if (this.toolkitDeploy == null && !new File(newDefaultDeployFile).exists()) {
                    String defaultConfigFile = baseDir.getPath() + CommonUtils.getFileSeparator() + OLD_DEFAULT_DEPLOY_CONFIG_FILE;
                    LoadConfigManager loadConfigManager = new LoadConfigManager();
                    DefaultConfigBean oldProfileBean = loadConfigManager.loadProperties(this.configFile, defaultConfigFile, this.accessKeyFile, this.accessKeyId, this.accessKeySecret);
                    profile = new ToolkitProfile();
                    DefaultConfigBean.Env env = oldProfileBean.getEnv();
                    profile.setAccessKeyId(env.getAccessKeyId());
                    profile.setAccessKeySecret(env.getAccessKeySecret());
                    profile.setRegionId(env.getRegionId());
                    profile.setEndpoint(env.getEndpoint());
                    if (profile.getEndpoint() == null) {
                        profile.setEndpoint("edas." + env.getRegionId() + ".aliyuncs.com");
                    }
                } else {
                    throw new Exception("No toolkit profile is found for deploy.");
                }
            }
            Context.setToolkitProfileConfig(profile);
        }
        catch (Exception ex) {
            String msg = "Failed to load config file: " + ex.getMessage();
            throw new MojoExecutionException(msg);
        }
    }

    private String transformPathToAbsolutePath(String baseDir, String path) {
        if (StringUtils.isNotBlank((String)path) && !Paths.get(path, new String[0]).isAbsolute()) {
            return baseDir + File.separator + path;
        }
        return path;
    }

    private void transformConfigFilePath(String baseDir) {
        this.toolkitProfile = this.transformPathToAbsolutePath(baseDir, this.toolkitProfile);
        this.toolkitDeploy = this.transformPathToAbsolutePath(baseDir, this.toolkitDeploy);
        this.toolkitPackage = this.transformPathToAbsolutePath(baseDir, this.toolkitPackage);
        this.configFile = this.transformPathToAbsolutePath(baseDir, this.configFile);
        this.accessKeyFile = this.transformPathToAbsolutePath(baseDir, this.accessKeyFile);
        this.accessKeyFile = this.transformPathToAbsolutePath(baseDir, this.accessKeyFile);
    }
}

